<?php
return array(
	'title'      => 'Axtra Team Setting',
	'id'         => 'axtra_meta_team',
	'icon'       => 'el el-cogs',
	'position'   => 'normal',
	'priority'   => 'core',
	'post_types' => array( 'team' ),
	'sections'   => array(
		array(
			'id'     => 'axtra_team_meta_setting',
			'fields' => array(
				array(
					'id'    => 'team_designation',
					'type'  => 'text',
					'title' => esc_html__( 'Designation', 'axtra' ),
				),
				array(
                    'id' => 'show_portfolio_info',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Project Information', 'axtra'),
                    'desc' => esc_html__('Enable to Show Project Information', 'axtra'),
                ),
				array(
					'id'    => 'portfolio_title',
					'type'  => 'text',
					'title' => esc_html__( 'Portfolio Title', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'portfolio_behance_title',
					'type'  => 'text',
					'title' => esc_html__( 'Behance Title', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'portfolio_behance_link',
					'type'  => 'text',
					'title' => esc_html__( 'Behance link', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'portfolio_dribbble_title',
					'type'  => 'text',
					'title' => esc_html__( 'Dribbble Title', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'portfolio_dribbble_link',
					'type'  => 'text',
					'title' => esc_html__( 'Dribbble link', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'portfolio_meduim_title',
					'type'  => 'text',
					'title' => esc_html__( 'Meduim Title', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'portfolio_meduim_link',
					'type'  => 'text',
					'title' => esc_html__( 'Meduim link', 'axtra' ),
					'required' => array('show_portfolio_info', '=', true),
				),
				array(
					'id'    => 'social_profile',
					'type'  => 'social_media',
					'title' => esc_html__( 'Social Profiles', 'axtra' ),
				),
				
				//CTA Action
				array(
                    'id' => 'show_cta_area',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide CTA Information', 'axtra'),
                    'desc' => esc_html__('Enable to Show CTA Information', 'axtra'),
                ),
				array(
					'id'    => 'team_cta_subtitle',
					'type'  => 'text',
					'title' => esc_html__( 'CTA Sub Title', 'axtra' ),
					'required' => array('show_cta_area', '=', true),
				),
				array(
					'id'    => 'team_cta_title',
					'type'  => 'textarea',
					'title' => esc_html__( 'CTA Title', 'axtra' ),
					'required' => array('show_cta_area', '=', true),
				),
				array(
					'id'    => 'team_cta_btn_title',
					'type'  => 'text',
					'title' => esc_html__( 'CTA Button Title', 'axtra' ),
					'required' => array('show_cta_area', '=', true),
				),
				array(
					'id'    => 'team_cta_btn_link',
					'type'  => 'text',
					'title' => esc_html__( 'CTA Button Link', 'axtra' ),
					'required' => array('show_cta_area', '=', true),
				),
			),
		),
	),
);