<?php
return array(
	'title'      => 'Axtra Career Setting',
	'id'         => 'axtra_meta_career',
	'icon'       => 'el el-cogs',
	'position'   => 'normal',
	'priority'   => 'core',
	'post_types' => array( 'career' ),
	'sections'   => array(
		array(
			'id'     => 'axtra_career_meta_setting',
			'fields' => array(
				array(
                    'id'       => 'career_image',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Career Detail Parallax Image', 'axtra'),
                    'desc'     => esc_html__('Insert Career Detail Parallax Image URl', 'axtra'),
                ),
				array(
                    'id'    => 'job_open_roles',
                    'type'  => 'text',
                    'title' => esc_html__('Job Open Roles', 'axtra'),
                ),
				//Job Details
				array(
                    'id' => 'show_job_details',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Career Job Information', 'axtra'),
                    'desc' => esc_html__('Enable to Show Career Job Information', 'axtra'),
                ),
				array(
                    'id'    => 'job_location',
                    'type'  => 'text',
                    'title' => esc_html__('Job Location', 'axtra'),
                    'required' => array('show_job_details', '=', true),
                ),
				array(
                    'id'    => 'job_date',
                    'type'  => 'text',
                    'title' => esc_html__('Job Date', 'axtra'),
                    'required' => array('show_job_details', '=', true),
                ),
				array(
                    'id'    => 'job_type',
                    'type'  => 'text',
                    'title' => esc_html__('Job Types', 'axtra'),
                    'required' => array('show_job_details', '=', true),
                ),
				
				//Job Info
				array(
                    'id' => 'show_job_info',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Career Job Information', 'axtra'),
                    'desc' => esc_html__('Enable to Show Career Job Information', 'axtra'),
                ),
				array(
                    'id'    => 'job_experience',
                    'type'  => 'text',
                    'title' => esc_html__('Job Experience', 'axtra'),
                    'required' => array('show_job_info', '=', true),
                ),
				array(
                    'id'    => 'job_working_hours',
                    'type'  => 'text',
                    'title' => esc_html__('Working Hours', 'axtra'),
                    'required' => array('show_job_info', '=', true),
                ),
				array(
                    'id'    => 'job_working_days',
                    'type'  => 'text',
                    'title' => esc_html__('Working Days', 'axtra'),
                    'required' => array('show_job_info', '=', true),
                ),
				array(
                    'id'    => 'job_salary',
                    'type'  => 'text',
                    'title' => esc_html__('Job Salary', 'axtra'),
                    'required' => array('show_job_info', '=', true),
                ),
				array(
                    'id'    => 'job_vacancy',
                    'type'  => 'text',
                    'title' => esc_html__('Job Vacancy', 'axtra'),
                    'required' => array('show_job_info', '=', true),
                ),
				array(
                    'id'    => 'job_deadline',
                    'type'  => 'text',
                    'title' => esc_html__('Job Deadline', 'axtra'),
                    'required' => array('show_job_info', '=', true),
                ),
				
				
				//Apply Button Title
				array(
                    'id'    => 'apply_btn_title',
                    'type'  => 'text',
                    'title' => esc_html__('Apply Button Title', 'axtra'),
                ),
				
				//Form Info
				array(
                    'id'       => 'form_logo_image',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Job Form Logo Image', 'axtra'),
                    'desc'     => esc_html__('Insert Job Form Logo Image URl', 'axtra'),
                ),
				array(
                    'id'    => 'form_job_title',
                    'type'  => 'text',
                    'title' => esc_html__('Form Job Title', 'axtra'),
                ),
				array(
                    'id'    => 'form_job_description',
                    'type'  => 'text',
                    'title' => esc_html__('Form Job Description', 'axtra'),
                ),
				
				array(
                    'id'    => 'apply_form_url',
                    'type'  => 'text',
                    'title' => esc_html__('Apply Form Url V1', 'axtra'),
                ),
				array(
                    'id'    => 'apply_form_url2',
                    'type'  => 'text',
                    'title' => esc_html__('Apply Form Url V1', 'axtra'),
                ),
			),
		),
	),
);