<?php

namespace AXTRAPLUGIN\Inc;


use AXTRAPLUGIN\Inc\Abstracts\Taxonomy;


class Taxonomies extends Taxonomy {


	public static function init() {

		$labels = array(
			'name'              => _x( 'Project Category', 'wpaxtra' ),
			'singular_name'     => _x( 'Project Category', 'wpaxtra' ),
			'search_items'      => __( 'Search Category', 'wpaxtra' ),
			'all_items'         => __( 'All Categories', 'wpaxtra' ),
			'parent_item'       => __( 'Parent Category', 'wpaxtra' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpaxtra' ),
			'edit_item'         => __( 'Edit Category', 'wpaxtra' ),
			'update_item'       => __( 'Update Category', 'wpaxtra' ),
			'add_new_item'      => __( 'Add New Category', 'wpaxtra' ),
			'new_item_name'     => __( 'New Category Name', 'wpaxtra' ),
			'menu_name'         => __( 'Project Category', 'wpaxtra' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'project_cat' ),
		);

		register_taxonomy( 'project_cat', 'project', $args );
		
		//Services Taxonomy Start
		$labels = array(
			'name'              => _x( 'Service Category', 'wpaxtra' ),
			'singular_name'     => _x( 'Service Category', 'wpaxtra' ),
			'search_items'      => __( 'Search Category', 'wpaxtra' ),
			'all_items'         => __( 'All Categories', 'wpaxtra' ),
			'parent_item'       => __( 'Parent Category', 'wpaxtra' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpaxtra' ),
			'edit_item'         => __( 'Edit Category', 'wpaxtra' ),
			'update_item'       => __( 'Update Category', 'wpaxtra' ),
			'add_new_item'      => __( 'Add New Category', 'wpaxtra' ),
			'new_item_name'     => __( 'New Category Name', 'wpaxtra' ),
			'menu_name'         => __( 'Service Category', 'wpaxtra' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'service_cat' ),
		);


		register_taxonomy( 'service_cat', 'service', $args );
		
		//Testimonials Taxonomy Start
		$labels = array(
			'name'              => _x( 'Testimonials Category', 'wpaxtra' ),
			'singular_name'     => _x( 'Testimonials Category', 'wpaxtra' ),
			'search_items'      => __( 'Search Category', 'wpaxtra' ),
			'all_items'         => __( 'All Categories', 'wpaxtra' ),
			'parent_item'       => __( 'Parent Category', 'wpaxtra' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpaxtra' ),
			'edit_item'         => __( 'Edit Category', 'wpaxtra' ),
			'update_item'       => __( 'Update Category', 'wpaxtra' ),
			'add_new_item'      => __( 'Add New Category', 'wpaxtra' ),
			'new_item_name'     => __( 'New Category Name', 'wpaxtra' ),
			'menu_name'         => __( 'Testimonials Category', 'wpaxtra' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'testimonials_cat' ),
		);


		register_taxonomy( 'testimonials_cat', 'testimonials', $args );
		
		
		//Team Taxonomy Start
		$labels = array(
			'name'              => _x( 'Team Category', 'wpaxtra' ),
			'singular_name'     => _x( 'Team Category', 'wpaxtra' ),
			'search_items'      => __( 'Search Category', 'wpaxtra' ),
			'all_items'         => __( 'All Categories', 'wpaxtra' ),
			'parent_item'       => __( 'Parent Category', 'wpaxtra' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpaxtra' ),
			'edit_item'         => __( 'Edit Category', 'wpaxtra' ),
			'update_item'       => __( 'Update Category', 'wpaxtra' ),
			'add_new_item'      => __( 'Add New Category', 'wpaxtra' ),
			'new_item_name'     => __( 'New Category Name', 'wpaxtra' ),
			'menu_name'         => __( 'Team Category', 'wpaxtra' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'team_cat' ),
		);


		register_taxonomy( 'team_cat', 'team', $args );
		
		//Faqs Taxonomy Start
		$labels = array(
			'name'              => _x( 'Faqs Category', 'wpaxtra' ),
			'singular_name'     => _x( 'Faqs Category', 'wpaxtra' ),
			'search_items'      => __( 'Search Category', 'wpaxtra' ),
			'all_items'         => __( 'All Categories', 'wpaxtra' ),
			'parent_item'       => __( 'Parent Category', 'wpaxtra' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpaxtra' ),
			'edit_item'         => __( 'Edit Category', 'wpaxtra' ),
			'update_item'       => __( 'Update Category', 'wpaxtra' ),
			'add_new_item'      => __( 'Add New Category', 'wpaxtra' ),
			'new_item_name'     => __( 'New Category Name', 'wpaxtra' ),
			'menu_name'         => __( 'Faqs Category', 'wpaxtra' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'faqs_cat' ),
		);


		register_taxonomy( 'faqs_cat', 'faqs', $args );
		
		//Career Taxonomy Start
		$labels = array(
			'name'              => _x( 'Careers Category', 'wpaxtra' ),
			'singular_name'     => _x( 'Careers Category', 'wpaxtra' ),
			'search_items'      => __( 'Search Category', 'wpaxtra' ),
			'all_items'         => __( 'All Categories', 'wpaxtra' ),
			'parent_item'       => __( 'Parent Category', 'wpaxtra' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpaxtra' ),
			'edit_item'         => __( 'Edit Category', 'wpaxtra' ),
			'update_item'       => __( 'Update Category', 'wpaxtra' ),
			'add_new_item'      => __( 'Add New Category', 'wpaxtra' ),
			'new_item_name'     => __( 'New Category Name', 'wpaxtra' ),
			'menu_name'         => __( 'Careers Category', 'wpaxtra' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'career_cat' ),
		);


		register_taxonomy( 'career_cat', 'career', $args );
		
		
	}
	
}
