<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Roll_Silde_Area extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_roll_silde_area';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Roll Silde Area', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'roll-slider-script', YT_URL . 'assets/js/roll-slider.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'roll-slider-script' ];
	}

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'roll_silde_area',
            [
                'label' => esc_html__( 'Roll Silde Area', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/roll/roll_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/roll/roll_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/roll/roll_layout_three.png'
					],
				],
			]
		);
		//Slider Repeater
		$repeater = new Repeater();
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'roll_slide',
			[
				'label'                 => __('Add Slide Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Block Section Style**/
		$this->start_controls_section(
			'block_title_style',
			[
				'label' => esc_html__('BLOCK SECTION STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_block_bg_style',
			[
				'label'       => __( 'ON/OFF  Section Background Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_section_background',
			[
				'label'                 => __( 'Section Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_block_bg_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'section_bgtype',
				'label' => __( 'Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .roll__area,
					{{WRAPPER}} .roll__area-2,
					{{WRAPPER}} .roll__area-3',				
				'condition'             => [
					'show_block_bg_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_block_title_style',
			[
				'label'       => __( 'ON/OFF  Box Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'block_title_typography',
                'label' => __('Block Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} h2',                
                'separator' => 'before',
				'condition'             => [
					'show_block_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'block_title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} h2' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_block_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <?php if($settings['layout_control'] == 'three'): ?>
    
    <!-- Roll area start -->
    <section class="roll__area">
        <div class="swiper roll__slider">
            <div class="swiper-wrapper roll__wrapper">
            	<?php foreach($settings['roll_slide'] as $key => $item): ?>
                <div class="swiper-slide roll__slide">
                	<h2><?php echo wp_kses($item['block_title'], true); ?></h2>
                </div>
            	<?php endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Roll area end -->
        
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Roll area start -->
    <section class="roll__area-3">
        <div dir="rtl" class="swiper roll__slider">
            <div class="swiper-wrapper roll__wrapper">
                <?php foreach($settings['roll_slide'] as $key => $item): ?>
                <div class="swiper-slide roll__slide ">
                	<h2><?php echo wp_kses($item['block_title'], true); ?></h2>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Roll area end -->
    
    <?php else: ?>
    
    <!-- Roll area start -->
    <section class="roll__area-2">
        <div class="swiper roll__slider">
            <div class="swiper-wrapper roll__wrapper">
                <?php foreach($settings['roll_slide'] as $key => $item): ?>
                <div class="swiper-slide roll__slide">
                	<h2><?php echo wp_kses($item['block_title'], true); ?></h2>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Roll area end -->
    	  
	<?php endif; 
    }
}