<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Project_Awards extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_project_awards';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Project Awards', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'project_awards',
            [
                'label' => esc_html__( 'Project Awards', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/awards/award_layout_two.png'
					],
				],
			]
		);
		$this->add_control(
            'video_source_url',
			[
				'label' => __( 'Video Source Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		//Experience Area
		$this->add_control(
			'show_experience_area',
			[
				'label'       => __( 'ON/OFF Experience Info', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'experience_year',
			[
				'label'       => __( 'Experience Years', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Years', 'axtra' ),
				'condition' => [
					'show_experience_area' => 'yes',
				],
			]
		);
		$this->add_control(
			'experience_title',
			[
				'label'       => __( 'Experience Description', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Description', 'axtra' ),
				'condition' => [
					'show_experience_area' => 'yes',
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'icon_image',
			[
				'label' => __( 'Icon Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'features',
			[
				'label'                 => __('Add Features Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title,
					{{WRAPPER}} .award__counter .counter__number',                
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .award__counter .counter__number' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .feature__text p, 
					{{WRAPPER}} .service__area-2 .sec-text p,  
					{{WRAPPER}} .award__counter p,
					{{WRAPPER}} .award__mid-7 p',                
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .feature__text p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__area-2 .sec-text p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .award__counter p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .award__mid-7 p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <!-- Award area start -->
    <section class="award__area-7">
        <div class="container">
            
            <div class="row inherit_row">
                <div class="col-xxl-12">
                    <div class="award__top-7">
                        <?php if($settings['show_experience_area']){ ?>
                        <div class="award__counter fade_bottom_2">
                            <?php if($settings['experience_year']){ ?><h2 class="counter__number"><?php echo wp_kses($settings['experience_year'], true); ?></h2><?php } ?>
                            <?php if($settings['experience_title']){ ?><p><?php echo wp_kses($settings['experience_title'], true); ?></p><?php } ?>
                        </div>
                        <?php } ?>
                        <?php if($settings['video_source_url']['url']){ ?>
                        <div class="award-video-7">
                            <video loop muted autoplay playsinline>
                            	<source src="<?php echo esc_url($settings['video_source_url']['url']); ?>" type="<?php esc_attr_e('video/mp4', 'axtra'); ?>">
                            </video>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        
            <div class="award__btm-7">
                <div class="row">
                    <?php if($settings['title']){ ?>
                    <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4">
                        <div class="award__left-7">
                        	<h2 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true); ?></h2>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if($settings['text']){ ?>
                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-8">
                        <div class="award__mid-7 text-anim">
                            <p><?php echo wp_kses($settings['text'], true); ?></p>
                        </div>
                    </div>
                    <?php } ?>
                    
                    <div class="col-xxl-4 col-xl-4 col-lg-4">
                        <div class="award__right-7">
                            <div class="award__list-7">
                                <?php foreach($settings['features'] as $key => $item): ?>
                                <div class="award__item-7 zoom_in">
                                    <?php if($item['icon_image']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($item['icon_image']['id'])); ?>" alt="<?php esc_attr_e('Image', 'axtra'); ?>"><?php } ?>
                                    <h3 class="title"><?php echo wp_kses($item['block_title'], true); ?></h3>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Award area end -->
    
	<?php 
    }
}
