<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Personal_Portfolio extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_personal_portfolio';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Personal Portfolio', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'main-slider-script', YT_URL . 'assets/js/main-slider.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'main-slider-script' ];
	}

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'personal_portfolio',
            [
                'label' => esc_html__( 'General', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/personal_portfolio_layout_one.png'
					],
				],
			]
		);
		$this->add_control(
			'show_slide_v1',
			[
				'label'       => __( 'ON/OFF Slide V1', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_slide_v1'      => 'yes'
				],
			]
		);
		$this->add_control(
			'title1',
			[
				'label'       => __( 'Main Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title/Heading', 'axtra' ),
				'condition' => [
					'show_slide_v1'      => 'yes'
				],
			]
		);
		$this->add_control(
			'title2',
			[
				'label'       => __( 'Transparent Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Transparent Title', 'axtra' ),
				'condition' => [
					'show_slide_v1'      => 'yes'
				],
			]
		);
		$this->add_control(
			'title3',
			[
				'label'       => __( 'Developer Title ', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Developer Title', 'axtra' ),
				'condition' => [
					'show_slide_v1'      => 'yes'
				],
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'show_slide_v1'      => 'yes'
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'show_slide_v1'      => 'yes'
				],
			]
		);
		$this->end_controls_section();
		
		//Digital Experience
		$this->start_controls_section(
            'digital_experience',
            [
                'label' => esc_html__( 'Digital Experience', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'show_digital_experience',
			[
				'label'       => __( 'ON/OFF Experience Area', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'experience_title',
			[
				'label'       => __( 'Experience Title ', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Title', 'axtra' ),
				'condition' => [
					'show_digital_experience'      => 'yes'
				],
			]
		);
		$this->add_control(
			'experience_text',
			[
				'label'       => __( 'Experience Description ', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Description', 'axtra' ),
				'condition' => [
					'show_digital_experience'      => 'yes'
				],
			]
		);
		$this->add_control(
			'btn_title1',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'show_digital_experience'      => 'yes'
				],
			]
		);
		$this->add_control(
            'btn_link1',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'show_digital_experience'      => 'yes'
				],
			]
		);
		$this->add_control(
			'brand_title',
			[
				'label'       => __( 'Brand Award Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Brand Award Title Here', 'axtra' ),
				'condition' => [
					'show_digital_experience'      => 'yes'
				],
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'client_image',
			[
				'label' => esc_html__('Client Image', 'axtra'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'client',
			[
				'label'                 => __('Add Clinets Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
		
		//Portfolio Section
		$this->start_controls_section(
            'portfolio_section',
            [
                'label' => esc_html__( 'Our Portfolio', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'show_portfolio_section',
			[
				'label'       => __( 'ON/OFF Portfolio Area', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'portfolio_title',
			[
				'label'       => __( 'Portfolio Title ', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Portfolio Title', 'axtra' ),
				'condition' => [
					'show_portfolio_section'      => 'yes'
				],
			]
		);
		$repeater_por = new Repeater();
		$repeater_por->add_control(
			'portfolio_image',
			[
				'label' => esc_html__('Client Image', 'axtra'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater_por->add_control(
			'portfolio_post_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater_por->add_control(
			'portfolio_post_date',
			[
				'label' => esc_html__('Post Date', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater_por->add_control(
			'social_btn_title',
			[
				'label' => __( 'External Link', 'axtra' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => ['url' => '','is_external' => true,'nofollow' => true,],
			]
		);
		$this->add_control(
			'portfolio',
			[
				'label'                 => __('Add Portfolio Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater_por->get_controls(),
			]
		);
		$this->end_controls_section();
		
		//Service Section
		$this->start_controls_section(
            'service_section',
            [
                'label' => esc_html__( 'Our Services', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'show_service_section',
			[
				'label'       => __( 'ON/OFF Service Area', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'service_title',
			[
				'label'       => __( 'Service Title ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Service Title', 'axtra' ),
				'condition' => [
					'show_service_section'      => 'yes'
				],
			]
		);
		$this->add_control(
			'service_text',
			[
				'label'       => __( 'Service Description ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Service Description', 'axtra' ),
				'condition' => [
					'show_service_section'      => 'yes'
				],
			]
		);
		$repeater_ser = new Repeater();
		$repeater_ser->add_control(
			'service_post_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater_ser->add_control(
			'features_list',
			[
				'label' => esc_html__('Feature List', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater_ser->add_control(
			'service_link',
			[
				'label' => __( 'External Link', 'axtra' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => ['url' => '','is_external' => true,'nofollow' => true,],
			]
		);
		$this->add_control(
			'service',
			[
				'label'                 => __('Add Services Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater_ser->get_controls(),
			]
		);
		$this->add_control(
			'section_bottom_text',
			[
				'label'       => __( 'Bottom Description ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Section Bottom Description', 'axtra' ),
				'condition' => [
					'show_service_section'      => 'yes'
				],
			]
		);
		$this->end_controls_section();
		
		//Get In Touch 
		$this->start_controls_section(
            'get_in_touch',
            [
                'label' => esc_html__( 'Get In Touch', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'show_contact_us',
			[
				'label'       => __( 'ON/OFF Contact Us', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'contact_title',
			[
				'label'       => __( 'Title ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$this->add_control(
			'contact_text',
			[
				'label'       => __( 'Description ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$this->add_control(
			'info_title',
			[
				'label'       => __( 'Info Title ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Info Title', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$this->add_control(
			'phone_no',
			[
				'label'       => __( 'Phone Number', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Phone Number', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$this->add_control(
			'email_address',
			[
				'label'       => __( 'Email Address', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Email Address', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$this->add_control(
			'social_title',
			[
				'label'       => __( 'Follow Title ', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Follow Title', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$repeater_soc = new Repeater();
		$repeater_soc->add_control(
			'social_icon_title',
			[
				'label' => esc_html__('Social Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater_soc->add_control(
			'social_link',
			[
				'label' => __( 'Social Link', 'axtra' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => ['url' => '','is_external' => true,'nofollow' => true,],
			]
		);
		$this->add_control(
			'social_info',
			[
				'label'                 => __('Add Social Icons', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater_soc->get_controls(),
			]
		);
		$this->add_control(
			'get_in_touch_form',
			[
				'label'       => __( 'Contact Form 7 Url ', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Get In Touch Form Url', 'axtra' ),
				'condition' => [
					'show_contact_us'      => 'yes'
				],
			]
		);
		$this->end_controls_section();
   		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .portfolio__hero .title.text-stroke,
					{{WRAPPER}} .portfolio__about .brand-title',
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__hero .title.text-stroke' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio__about .brand-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__hero .title.shape-circle,
                    {{WRAPPER}} .sec-title,
                    {{WRAPPER}} .portfolio__project .pp-slide-title,
                    {{WRAPPER}} .portfolio__footer-area .pf-title',
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__hero .title.shape-circle' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio__project .pp-slide-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio__footer-area .pf-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__about .sec-text p,
                    {{WRAPPER}} .portfolio__service .sec-text p,
                    {{WRAPPER}} .contact__text p',
				'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__about .sec-text p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio__service .sec-text p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact__text p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .wc-btn-dark',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .wc-btn-dark:hover',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .wc-btn-dark' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .wc-btn-dark',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .wc-btn-dark:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' =>
					'{{WRAPPER}} .wc-btn-dark',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .wc-btn-dark' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .wc-btn-dark',				
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .wc-btn-dark' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .wc-btn-dark:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <div class="portfolio__page">
        <div class="swiper portfolio__main-slider">
        	<div class="swiper-wrapper portfolio__main-wrapper">
                <?php if($settings['show_slide_v1']){ ?>
                <div class="swiper-slide">
                    <section class="portfolio__hero-area portfolio-section">
                        <div class="container">
                            <div class="row">
                                <div class="col-xxl-12">
                                    <div class="portfolio__hero">
                                        <?php if($settings['title1']){ ?><h1 class="title shape-circle"><?php echo wp_kses($settings['title1'], true);?></h1><?php } ?>
                                        <?php if($settings['title2']){ ?><h2 class="title text-stroke"><?php echo wp_kses($settings['title2'], true);?></h2><?php } ?>
                                        <?php if($settings['title3']){ ?><h2 class="title"><?php echo wp_kses($settings['title3'], true);?></h2><?php } ?>
                                        
										<?php if($settings['btn_title']){ ?>
                                        <div class="btn-wrapper">
                                        	<a href="<?php echo esc_url($settings['btn_link']['url']);?>" class="wc-btn-dark"><?php echo wp_kses($settings['btn_title'], true);?></a>
                                        </div>
                                        <?php } ?>
                                        
                                        <?php if($settings['feature_image']['id']){ ?>
                                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Personal Portfolio', 'axtra'); ?>" class="pp-thumb">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
				<?php } ?>
                
                <?php if($settings['show_digital_experience']){ ?>
                <div class="swiper-slide">
                    <section class="portfolio-section portfolio__about pt-140 pb-150">
                        <div class="container">
                            <div class="row">
                                <?php if($settings['experience_title']){ ?>
                                <div class="col-xxl-8 col-xxl-8 col-lg-8">
                                    <div class="portfolio__about-left">
                                        <h2 class="sec-title"> <?php echo wp_kses($settings['experience_title'], true);?> </h2>
                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/16.png" alt="<?php esc_attr_e('Shape', 'axtra'); ?>">
                                    </div>
                                </div>
                                <?php } ?>
                                
                                <div class="col-xxl-4 col-xl-4 col-lg-4">
                                    <div class="sec-text">
                                        <?php if($settings['experience_text']){ ?><p><?php echo wp_kses($settings['experience_text'], true);?></p><?php } ?>
                                        <?php if($settings['btn_title1']){ ?><a href="<?php echo esc_url($settings['btn_link1']['url']);?>" class="wc-btn-dark"><?php echo wp_kses($settings['btn_title1'], true);?></a><?php } ?>
                                    </div>
                                </div>
                            </div>
                        
                            <div class="about-row">
                                <div class="row">
                                    <?php if($settings['brand_title']){ ?>
                                    <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4">
                                        <div class="brand-title-wrap">
                                        	<h3 class="brand-title"><?php echo wp_kses($settings['brand_title'], true);?></h3>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    
                                    <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-8">
                                        <div class="brand-list">
                                        	<?php foreach($settings['client'] as $key => $item): ?>
                                            <div class="brand-logo">
                                            	<img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>">
                                            </div>
                                        	<?php endforeach;?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
				<?php } ?>
                
                <?php if($settings['show_portfolio_section']){ ?>
                <div class="swiper-slide">
                    <section class="portfolio-section portfolio__project">
                        <div class="container">
                            <?php if($settings['portfolio_title']){ ?>
                            <div class="row">
                                <div class="col-xxl-12">
                                    <div class="pp-title-wrap">
                                    	<h2 class="pp-title"><?php echo wp_kses($settings['portfolio_title'], true);?></h2>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <div class="row">
                                <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-8">
                                    <div class="pp-slider-wrapper">
                                        <div class="swiper portfolio__project-slider">
                                            <div class="swiper-wrapper">
                                                <?php foreach($settings['portfolio'] as $key => $item): ?>
                                                <div class="swiper-slide pp-slide">
                                                    <div class="pp-slide-img">
                                                        <a href="<?php echo esc_url($item['portfolio_link']['url']);?>"><img src="<?php echo esc_url(wp_get_attachment_url($item['portfolio_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>"></a>
                                                    </div>
                                                </div>
                                            	<?php endforeach; ?>
                                            </div>
                                        </div>
                                    
                                        <div class="pp-next swipper-btn"><?php esc_html_e('prev', 'axtra'); ?></div>
                                        <div class="pp-prev swipper-btn"><?php esc_html_e('Next', 'axtra'); ?></div>
                                    </div>
                                </div>
                            
                                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4">
                                    <div class="swiper portfolio__project-thumbs">
                                        <div class="swiper-wrapper">
                                            <?php foreach($settings['portfolio'] as $key => $item): ?>
                                            <div class="swiper-slide">
                                                <div class="pp-slide-thumb">
                                                    <h3 class="pp-slide-title"><?php echo wp_kses($item['portfolio_post_title'], true);?></h3>
                                                    <p><?php echo wp_kses($item['portfolio_post_date'], true);?></p>
                                                </div>
                                            </div>
                                        	<?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            
                            </div>
                        </div>
                    </section>
              	</div>
				<?php } ?>
                
                <?php if($settings['show_service_section']){ ?>
                <div class="swiper-slide">
                    <section class="portfolio-section portfolio__service pt-140 pb-140">
                        <div class="container">
                            <div class="row">
                                <?php if($settings['service_title']){ ?>
                                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-6">
                                    <h2 class="sec-title"> <?php echo wp_kses($settings['service_title'], true);?></h2>
                                </div>
                                <?php } ?>
                                <?php if($settings['service_text']){ ?>
                                <div class="col-xxl-7 col-xl-7 col-lg-6 col-md-6">
                                    <div class="sec-text">
                                        <p><?php echo wp_kses($settings['service_text'], true);?></p>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                            <div class="portfolio__service-list">
                                <div class="row">
                                    <?php foreach($settings['service'] as $key => $item): ?>
                                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                                        <div class="portfolio__service-item">
                                            <a href="service-details.html">
                                                <h3 class="ps-title"><?php echo wp_kses($item['service_post_title'], true);?></h3>
                                                <?php $features_list = $item['features_list'];
													if(!empty($features_list)){
													$features_list = explode("\n", ($features_list)); 
												?>
                                                <ul>
                                                    <?php foreach($features_list as $features): ?>
                                                    <li><?php echo wp_kses($features, true); ?></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                                <?php } ?>
                                        	</a>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <?php if($settings['section_bottom_text']){ ?>
                            <div class="row">
                                <div class="col-xxl-12">
                                    <div class="ps-btn">
                                    	<?php echo wp_kses($settings['section_bottom_text'], true);?>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                    	</div>
                    </section>
                </div>
				<?php } ?>
                
                <?php if($settings['show_contact_us']){ ?>
                <div class="swiper-slide">
                    <section class="portfolio-section portfolio__footer-area  pt-130">
                    
                    	<!-- Contact area start -->
                        <div class="">
                            <div class="container">
                                <?php if($settings['contact_title'] || $settings['contact_text']){ ?>
                                <div class="row">
                                    <?php if($settings['contact_title']){ ?>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                        <div class="sec-title-wrapper">
                                        	<h2 class="pf-title"><?php echo wp_kses($settings['contact_title'], true);?></h2>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php if($settings['contact_text']){ ?>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                        <div class="contact__text">
                                            <p><?php echo wp_kses($settings['contact_text'], true);?></p>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                                <?php } ?>
                                
                                <div class="row">
                                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                                        <div class="pf-contact">
                                            <h3><?php echo wp_kses($settings['info_title'], true);?> </h3>
                                            <?php if($settings['phone_no'] || $settings['email_address']){ ?>
                                            <ul>
                                                <?php if($settings['phone_no']){ ?><li><a href="tel:<?php echo esc_attr($settings['phone_no']);?>"><?php echo wp_kses($settings['phone_no'], true);?></a></li><?php } ?>
                                                <?php if($settings['email_address']){ ?><li><a href="mailto:<?php echo esc_attr($settings['email_address']);?>"><?php echo wp_kses($settings['email_address'], true);?></a></li><?php } ?>
                                            </ul>
                                            <?php } ?>
                                        </div>
                                        
                                        <div class="pf-social">
                                            <h3><?php echo wp_kses($settings['social_title'], true);?> </h3>
                                            <ul>
                                                <?php foreach($settings['social_info'] as $key => $item): ?>
                                                <li><a href="<?php echo esc_url($item['social_link']['url']);?>"><?php echo wp_kses($item['social_icon_title'], true);?></a></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    </div>
                                    <?php if($settings['get_in_touch_form']){ ?>
                                    <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7">
                                        <div class="contact__form">
                                            <?php echo do_shortcode($settings['get_in_touch_form']);?>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    	<!-- Contact area end -->
                    
                	</section>
                </div>
				<?php } ?>
        	</div>
            
            <div class="swiper-pagination circle-pagination-2"></div>
    	</div>
	</div>
    
           
    <?php
    }
}
