<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Testimonials_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_our_testimonials_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Testimonials V2', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'our_testimonials_v2',
            [
                'label' => esc_html__( 'Our Testimonials_v2', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial_layout.png'
					],
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
			]
		);
		$this->add_control(
			'show_client_info_v1',
			[
				'label'       => __( 'ON/OFF Client Info V1', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'client_image1',
			[
				'label' => __( 'Client Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition'             => [
					'show_client_info_v1'    => 'yes',
				],
			]
		);
		$this->add_control(
			'client_title1',
			[
				'label'       => __( 'Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition'             => [
					'show_client_info_v1'    => 'yes',
				],
			]
		);
		$this->add_control(
			'client_designation1',
			[
				'label'       => __( 'Designation', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'axtra' ),
				'condition'             => [
					'show_client_info_v1'    => 'yes',
				],
			]
		);
		$this->add_control(
            'client_video_link1',
			[
				'label' => __( 'Video Url V1', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition'             => [
					'show_client_info_v1'    => 'yes',
				],
			]
		);
		
		//Client Info V2
		$this->add_control(
			'show_client_info_v2',
			[
				'label'       => __( 'ON/OFF Client Info V2', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'client_image2',
			[
				'label' => __( 'Client Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition'             => [
					'show_client_info_v2'    => 'yes',
				],
			]
		);
		$this->add_control(
			'client_title2',
			[
				'label'       => __( 'Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition'             => [
					'show_client_info_v2'    => 'yes',
				],
			]
		);
		$this->add_control(
			'client_designation2',
			[
				'label'       => __( 'Designation', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'axtra' ),
				'condition'             => [
					'show_client_info_v2'    => 'yes',
				],
			]
		);
		$this->add_control(
            'client_video_link2',
			[
				'label' => __( 'Video Url V2', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition'             => [
					'show_client_info_v2'    => 'yes',
				],
			]
		);
		
		//Client Info V3
		$this->add_control(
			'show_client_info_v3',
			[
				'label'       => __( 'ON/OFF Client Info V3', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'client_image3',
			[
				'label' => __( 'Client Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition'             => [
					'show_client_info_v3'    => 'yes',
				],
			]
		);
		$this->add_control(
			'client_title3',
			[
				'label'       => __( 'Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition'             => [
					'show_client_info_v3'    => 'yes',
				],
			]
		);
		$this->add_control(
			'client_designation3',
			[
				'label'       => __( 'Designation', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'axtra' ),
				'condition'             => [
					'show_client_info_v3'    => 'yes',
				],
			]
		);
		$this->add_control(
            'client_video_link3',
			[
				'label' => __( 'Video Url V3', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition'             => [
					'show_client_info_v3'    => 'yes',
				],
			]
		);
		$this->end_controls_section();
   		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Sub title Style**/
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '{{WRAPPER}} .sec-sub-title',
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title',                 
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .testimonial__area p',               
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial__area p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <!-- Testimonial area start -->
    <section class="testimonial__area">
        <div class="container g-0 line">
        	<span class="line-3"></span>
            <div class="row">
                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8">
                    <div class="testimonial__wrapper">
                        <?php if($settings['show_client_info_v1']){ ?>
                        <div class="testimonial__item item-1">
                            <div class="button modal-trigger">
                                <?php if($settings['client_image1']['id']){ ?>
                                <div class="testimonial__img b-right">
                                	<img src="<?php echo esc_url(wp_get_attachment_url($settings['client_image1']['id']));?>" alt="<?php esc_attr_e('Testimonial Image', 'axtra'); ?>">
                                </div>
                                <?php } ?>
                                <h2 class="testimonial__title"><?php echo wp_kses($settings['client_title1'], true);?></h2>
                                <h3 class="testimonial__role"><?php echo wp_kses($settings['client_designation1'], true);?></h3>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <?php if($settings['subtitle'] || $settings['title'] || $settings['text']){ ?>
                        <div class="sec-title-wrapper text-anim">
                            <?php if($settings['subtitle']){ ?><h4 class="sec-sub-title"><?php echo wp_kses($settings['subtitle'], true);?></h4><?php } ?>
                            <?php if($settings['title']){ ?><h5 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true);?></h5><?php } ?>
                            <?php if($settings['text']){ ?><p><?php echo wp_kses($settings['text'], true);?></p><?php } ?>
                        </div>
                        <?php } ?>
                    </div>
                	
                    <?php if($settings['show_client_info_v2']){ ?>
                    <div class="testimonial__item item-2">
                        <div class="button modal-trigger-2">
                            <?php if($settings['client_image2']['id']){ ?>
                            <div class="testimonial__img b-left">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['client_image2']['id']));?>" alt="<?php esc_attr_e('Testimonial Image', 'axtra'); ?>">
                            </div>
                            <?php } ?>
                            
                            <h2 class="testimonial__title"><?php echo wp_kses($settings['client_title2'], true);?></h2>
                            <h3 class="testimonial__role"><?php echo wp_kses($settings['client_designation2'], true);?></h3>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            	
                <?php if($settings['show_client_info_v3']){ ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="testimonial__item item-3 img-">
                        <div class="button modal-trigger-3">
                            <?php if($settings['client_image3']['id']){ ?>
                            <div class="testimonial__img b-left">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['client_image3']['id']));?>" alt="<?php esc_attr_e('Testimonial Image', 'axtra'); ?>">
                            </div>
                            <?php } ?>
                            
                            <h2 class="testimonial__title"><?php echo wp_kses($settings['client_title3'], true);?></h2>
                            <h3 class="testimonial__role"><?php echo wp_kses($settings['client_designation3'], true);?></h3>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
        
        <?php if($settings['client_video_link1']['url']){ ?>
    <!-- Modal 1 -->
    <div class="modal__testimonial" id="modal_testimonial">
        <div class="modal__testimonial-content">
        	<span class="modal__close" id="modal_close"><i class="fa-solid fa-xmark"></i></span>
            <iframe src="<?php echo esc_url($settings['client_video_link1']['url']);?>" title="Testimonial Video" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope;" allowfullscreen></iframe>
        </div>
    </div>
    <?php } ?>
    
    <?php if($settings['client_video_link2']['url']){ ?>
    <!-- Modal 2 -->
    <div class="modal__testimonial" id="modal_testimonial2">
        <div class="modal__testimonial-content">
            <span class="modal__close" id="modal_close2"><i class="fa-solid fa-xmark"></i></span>
            <iframe src="<?php echo esc_url($settings['client_video_link2']['url']);?>" allowfullscreen></iframe>
        </div>
    </div>
    <?php } ?>
    
    <?php if($settings['client_video_link3']['url']){ ?>
    <!-- Modal 3 -->
    <div class="modal__testimonial" id="modal_testimonial3">
        <div class="modal__testimonial-content">
            <span class="modal__close" id="modal_close3"><i class="fa-solid fa-xmark"></i></span>
            <iframe src="<?php echo esc_url($settings['client_video_link3']['url']);?>" allowfullscreen></iframe>
        </div>
    </div>
    <?php } ?>
        
    </section>
    <!-- Testimonial area end -->
    
     
               
    <?php
    }
}
