<?php

namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Services extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'axtra_our_services';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Services', 'axtra' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'axtra' ];
	}
	
	public function get_script_depends() {
		wp_register_script( 'axtra_services', YT_URL . 'assets/js/services.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'axtra_services' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_services',
			[
				'label' => esc_html__( 'Our Services', 'axtra' ),
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/service_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/service_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/service_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/service_layout_four.png'
					],
					'five' => [
						'label' => esc_html__('Layout 5', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/service_layout_five.png'
					],
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['four']
				],
			]
		);
		$this->add_control(
			'style_two',
			[
				'label'       => __( 'Enable/Disable Padding Bottom', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'show_title_area',
			[
				'label'       => __( 'ON/OFF Title Section', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['one', 'two', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'show_title_area'      => 'yes',
					'layout_control'      => ['one', 'two', 'four']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'show_title_area'      => 'yes',
					'layout_control'      => ['one', 'two', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'show_title_area'      => 'yes',
					'layout_control'      => ['one', 'two', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'show_title_area'      => 'yes',
					'layout_control'      => ['two', 'four']
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'show_title_area'      => 'yes',
					'layout_control'      => ['two', 'four']
				],
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['four']
				],
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['one', 'two', 'three']
				],
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
            'query_category', 
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__('Category', 'axtra'),
				'label_block' => true,
				'options' => get_service_categories(),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->end_controls_section();
	
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '
					{{WRAPPER}} .sec-sub-title,
					{{WRAPPER}} .sec-subtile-6
				',
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-subtile-6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => '{{WRAPPER}} .sec-title, {{WRAPPER}} .sec-title-6',
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title-6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .service__area-3 .sec-title-wrapper p,
					{{WRAPPER}} .service__top-text p,
					{{WRAPPER}} .service__top-text p span,
					{{WRAPPER}} .service__right-4 p,
					{{WRAPPER}} .portfolio__service .sec-text p',
				'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service__area-3 .sec-title-wrapper p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__top-text p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__top-text p span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__right-4 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__service .sec-text p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-view',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item:hover span,		
					{{WRAPPER}} .btn-view:hover',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .btn-view' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-view',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'border-color: {{VALUE}}!important',
					'{{WRAPPER}} .btn-view:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' => 
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-view',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .btn-view' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-view',				
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'color: {{VALUE}}!important',
					'{{WRAPPER}} .btn-view' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'color: {{VALUE}}!important',
					'{{WRAPPER}} .btn-view:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Post Item Style**/
		$this->start_controls_section(
			'loop_post_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .service__title-3,
					{{WRAPPER}} .service__number span,
					{{WRAPPER}} .service__title,
					{{WRAPPER}} .service__title-7,
					{{WRAPPER}} .service__item-number,
					{{WRAPPER}} .service__item-title,
					{{WRAPPER}} .portfolio__service-item .ps-title',
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service__title-3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__number span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__title-7' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-number' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__service-item .ps-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Post Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service__title-3:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__number:hover span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__title-7:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__service-item .ps-title:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF Post Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_content_typography',
                'label' => __('Post Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .service__content-3 p,
					{{WRAPPER}} .service__content-3 ul li,
					{{WRAPPER}} .service__text p,
					{{WRAPPER}} .service__item-7 p,
					{{WRAPPER}} .service__item-7 ul li,
					{{WRAPPER}} .portfolio__service-item ul li',
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_content_color',
            [
                'label' => __('Post Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service__content-3 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__content-3 ul li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__text p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-7 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-7 ul li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__service-item ul li' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'service',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( axtra_set( $settings, 'query_category' ) ) $args['service_cat'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
	{ ?>
	
    <?php if($settings['layout_control'] == 'five'): ?>
    
    <section class="portfolio__service service-v5 pt-140 pb-140">
        <div class="container">
           <?php if($settings['show_title_area']){ ?> 
            <div class="row">
                <?php if($settings[ 'title' ]){ ?>
                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-6">
                	<h2 class="sec-title animation__char_come"> <?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                </div>
                <?php } ?>
                
				<?php if($settings[ 'text' ]){ ?>
                <div class="col-xxl-7 col-xl-7 col-lg-6 col-md-6">
                    <div class="sec-text">
                        <p><?php echo wp_kses( $settings[ 'text' ], true );?></p>
                    </div>
                </div>
                <?php } ?>
            </div>
            <?php } ?>
            <div class="portfolio__service-list">
                <div class="row">
                	<?php 
						while ( $query->have_posts() ) : $query->the_post(); 
					?>
                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                        <div class="portfolio__service-item">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <h3 class="ps-title"><?php the_title(); ?></h3>
                                <?php $features_list = get_post_meta( get_the_id(), 'features_list', true );
									if(!empty($features_list)){
									$features_list = explode("\n", ($features_list)); 
								?>
                                <ul>
                                    <?php foreach($features_list as $features): ?>
                                    <li><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?> 
                            </a>
                        </div>
                    </div>
                	<?php endwhile; ?>
                </div>
            </div>
        </div>
    </section>
    
    <?php elseif($settings['layout_control'] == 'four'): ?>
    
    <!-- Service area end -->
    <section class="service__area-4">
        <div class="container g-0 line_4 pt-150 pb-140">
            <?php if($settings[ 'show_line_pattern' ]){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
            
			<?php if($settings[ 'show_title_area' ]){ ?>
            <div class="row">
                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-6">
                    <div class="service__left-6">
                        <?php if($settings[ 'subtitle' ]){ ?><h2 class="sec-subtile-6"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'title' ]){ ?><h3 class="sec-title-6 title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                    </div>
                </div>
                
                <div class="col-xxl-7 col-xl-7 col-lg-6 col-md-6">
                    <div class="service__right-4">
                        <?php if($settings['text']){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                        <?php if($settings['btn_title']){ ?><a class="btn-view" href="<?php echo esc_url( $settings[ 'btn_link' ]['url'] );?>"> <?php echo wp_kses( $settings[ 'btn_title' ], true );?> <i class="fa-solid fa-arrow-right"></i></a><?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>
            <div class="service__inner-4">
                <div class="row">
                    
					<?php if($settings['feature_image']['id']){ ?>
                    <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-6">
                        <div class="service__img-left">
                        	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id'])); ?>" alt="<?php esc_attr_e('Feature Icon', 'axtra'); ?>">
                        </div>
                    </div>
                    <?php } ?>
                    
                    <div class="col-xxl-7 col-xl-7 col-lg-6 col-md-6">
                        <div class="service__list-4">
                            <?php 
								$i = 1;
								while ( $query->have_posts() ) : $query->the_post(); 
							?>
                            <div class="service__item-4 fade_bottom_2">
                                <div class="service__item-number">
                                	<span><?php $i = sprintf('%02d', $i); echo $i; ?></span>
                                </div>
                                <div class="service__title-wrapper-4">
                                	<h4><a class="service__item-title" href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
                                </div>
                                <div class="service__item-icon">
                                	<a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><i class="fa-solid fa-arrow-right"></i></a>
                                </div>
                            </div>
                          	<?php $i++; endwhile; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Service area end -->
    
	<?php elseif($settings['layout_control'] == 'three'): ?>
	
    <!-- Service area start -->
    <section class="service__area-7 pt-130">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="service__items-7 animation_service_7">
                        <?php 
							while ( $query->have_posts() ) : $query->the_post(); 
						?>
                        <div class="service__item-7">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                            	<h3 class="service__title-7"><?php the_title(); ?></h3>
                            </a>
                            <p><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                            <?php $features_list = get_post_meta( get_the_id(), 'features_list', true );
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); 
							?>
							<ul class="">
								<?php foreach($features_list as $features): ?>
								<li><?php echo wp_kses($features, true); ?></li>
								<?php endforeach; ?>
							</ul>
							<?php } ?> 
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Service area end -->
	
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Service area start -->
    <section class="service__area pt-110 pb-150">
        <div class="container">
            <?php if($settings[ 'show_title_area' ]){ ?>
            <div class="row">
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="sec-title-wrapper wrap">
                        <?php if($settings[ 'subtitle' ]){ ?><h2 class="sec-sub-title title-anim"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'title' ]){ ?><h3 class="sec-title title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                    </div>
                </div>
                
				<?php if($settings[ 'text' ]){ ?>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                    <div class="service__top-text text-anim">
                        <p><?php echo wp_kses( $settings[ 'text' ], true );?></p>
                    </div>
                </div>
                <?php } ?>
                <?php if($settings[ 'btn_title' ]){ ?>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3">
                    <div class="service__top-btn">
                        <div id="btn_wrapper">
                            <a href="<?php echo esc_url( $settings[ 'btn_link' ]['url'] );?>" class="btn-item wc-btn-secondary btn-hover"><span></span> <?php echo wp_kses( $settings[ 'btn_title' ], true );?> <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        	<?php } ?>
            
            <div class="service__list-wrapper">
                <div class="row">
                    <div class="col-xxl-4 col-xl-4 col-lg-0 col-md-0">
                        <div class="service__img-wrapper">
                            <?php 
								$count = 1;
								global $post;
								while ( $query->have_posts() ) : $query->the_post(); 
								$post_thumbnail_id = get_post_thumbnail_id($post->ID);
								$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
							?>
                            <img src="<?php echo esc_url($post_thumbnail_url); ?>" alt="<?php esc_attr_e('Service Image', 'axtra'); ?>" class="service__img img-<?php echo esc_attr($count); ?> <?php if($count == 1) echo 'active'; ?>">
                            
                            <span class="shape-box-<?php echo esc_attr($count); ?> <?php if($count == 1) echo 'current'; ?>"></span>
                            <?php $count++; endwhile; ?>
                        </div>
                    </div>
                    
                    <div class="col-xxl-8 col-xl-8 col-lg-12 col-md-12">
                        <div class="service__list">
                        	<?php 
								$i = 1;
								global $post;
								while ( $query->have_posts() ) : $query->the_post(); 
								$post_thumbnail_id = get_post_thumbnail_id($post->ID);
								$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
							?>
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="service__item animation_home1_service" data-service="<?php echo esc_attr($i); ?>">
                                	<div class="service__number"><span><?php $i = sprintf('%02d', $i); echo $i; ?></span></div>
                                    <div class="service__title-wrapper">
                                        <h4 class="service__title"><?php the_title(); ?></h4>
                                    </div>
                                    <div class="service__text">
                                        <p><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                    </div>
                                    <div class="service__link">
                                    	<p><i class="fa-solid fa-arrow-right"></i></p>
                                    </div>
                                </div>
                            </a>
                        	<?php $i++; endwhile; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Service area end -->
    
    <?php else: ?>
    
    <!-- Service area start -->
    <section class="service__area-3 <?php if($settings['style_two']) echo 'service-v4'; ?> pb-150">
        <div class="container">
            <?php if($settings[ 'show_title_area' ]){ ?>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper pt-130 text-anim">
                        <?php if($settings[ 'subtitle' ]){ ?><h2 class="sec-sub-title title-anim"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'title' ]){ ?><h3 class="sec-title title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                        <?php if($settings[ 'text' ]){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>
            <div class="row">
                <div class="col-xx-12">
                    <div class="service__list-3">
                        <?php 
							global $post;
							while ( $query->have_posts() ) : $query->the_post(); 
							$post_thumbnail_id = get_post_thumbnail_id($post->ID);
							$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
						?>
                        <div class="service__item-3 service_animation">
                        	<h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="service__title-3"><?php the_title(); ?></a></h3>
                            <div class="service__content-3">
                                <p><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?> </p>
                                
                                <?php $features_list = get_post_meta( get_the_id(), 'features_list', true );
									if(!empty($features_list)){
									$features_list = explode("\n", ($features_list)); 
								?>
                                <ul class="">
                                    <?php foreach($features_list as $features): ?>
                                    <li><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?>                                
                            </div>
                            <div class="service__btn-3">
                                <div id="btn_wrapper">
                                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="wc-btn-black btn-hover btn-item"><span></span> <?php esc_html_e('Details', 'axtra'); ?> <i class="fa-solid fa-arrow-right"></i></a>
                                </div>
                            </div>                        
                        	<div class="service__hover-3" style="background-image: url('<?php echo esc_url($post_thumbnail_url); ?>');"></div>
                        </div>
                    	<?php endwhile; ?>
                        <div class="service3__img-wrap">
                        	<div class="service3__img"></div>
                        </div>
                    </div>
                </div>
            
            </div>
        </div>
    </section>
    <!-- Service area end -->
         
	<?php endif; }
    wp_reset_postdata();
	}

}