<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Features extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_our_eatures';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Features', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'our_features',
            [
                'label' => esc_html__( 'Our Features', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/features/feature_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/features/feature_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/features/feature_layout_three.png'
					],
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF  line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['three']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three']
				],
			]
		);
		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'axtra' ),
				'condition' => [
					'layout_control'      => ['three']
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three']
				],
			]
		);
		$this->add_control(
			'show_pattern_image',
			[
				'label'       => __( 'ON/OFF Pattern Image', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['three']
				],
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['three']
				],
			]
		);
		// Features Repeater
		$repeater = new Repeater();
		$repeater->add_control(
			'counter_value',
			[
				'label' => esc_html__('Counter Value', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon_image',
			[
				'label' => __( 'Icon Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'block_text',
			[
				'label' => esc_html__('Text', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'features_list',
			[
				'label' => esc_html__('Feature List', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'features',
			[
				'label'                 => __('Add Features Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title, 
					{{WRAPPER}} .sec-subtile-6,    
					{{WRAPPER}} .sec-title-6',             
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-subtile-6' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title-6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .feature__text p, 
					{{WRAPPER}} .service__area-2 .sec-text p, 
					{{WRAPPER}} .feature__content-right p',                
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .feature__text p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__area-2 .sec-text p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .feature__content-right p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item:hover span',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' =>
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .btn-item',				
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Post Item Style**/
		$this->start_controls_section(
			'loop_post_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		/**Post Title Start**/
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .feature__title,
					{{WRAPPER}} .service__title-2',
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .feature__title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__title-2' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Post Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .feature__title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__title-2:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		/**Post Content Start**/
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF Post Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_content_typography',
                'label' => __('Post Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .feature__item p,
					{{WRAPPER}} .service__item-2 p,
					{{WRAPPER}} .service__item-2 ul li',
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_content_color',
            [
                'label' => __('Post Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .feature__item p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-2 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__item-2 ul li' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
	}

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <?php if($settings['layout_control'] == 'three'): ?>
	
    <!-- Feature area start -->
    <section class="feature__area-6">
        <div class="container line_4">
            <?php if($settings['show_line_pattern']){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
            
            <div class="row">
                
				<?php if($settings['subtitle'] || $settings['title']){ ?>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-6">
                    <div class="feature__content-left">
                        <?php if($settings['subtitle']){ ?><h2 class="sec-subtile-6"><?php echo wp_kses($settings['subtitle'], true); ?></h2><?php } ?>
                        <?php if($settings['title']){ ?><h3 class="sec-title-6 title-anim"><?php echo wp_kses($settings['title'], true); ?></h3><?php } ?>
                    </div>
                </div>
                <?php } ?>
                
                <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-6">
                    <div class="feature__content-right">
                        <?php if($settings['sub_heading']){ ?><h4 class="feature__title-6"><?php echo wp_kses($settings['sub_heading'], true); ?></h4><?php } ?>
                        <?php echo wp_kses($settings['text'], true); ?>
                        
						<?php if($settings['show_pattern_image']){ ?>
                        <img class="feature__img-1" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/feature/4/1.png" alt="<?php esc_attr_e('Icon', 'axtra'); ?>">
                        <img class="feature__img-2" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/feature/4/2.png" alt="<?php esc_attr_e('Icon', 'axtra'); ?>">
                        <img class="feature__img-3" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/feature/4/3.png" alt="<?php esc_attr_e('Icon', 'axtra'); ?>">
                        <?php } ?>
                    </div>
                </div>
                
				<?php if($settings['feature_image']['id']){ ?>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                    <div class="feature__content">
                    	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id'])); ?>" alt="<?php esc_attr_e('Feature Icon', 'axtra'); ?>">
                    </div>
                </div>
                <?php } ?>
                
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                    <div class="feature__content-btm">
                        <?php foreach($settings['features'] as $key => $item): ?>
                        <div class="feature__content-item fade_bottom_4">
                            <?php if($item['icon_image']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($item['icon_image']['id'])); ?>" alt="<?php esc_attr_e('Feature Icon', 'axtra'); ?>"><?php } ?>
                            <h5><?php echo wp_kses($item['block_title'], true); ?></h5>
                            <p><?php echo wp_kses($item['block_text'], true); ?></p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Feature area end -->
    
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Service area start -->
    <section class="service__area-2 pt-130 pb-110">
        <div class="container">
            <div class="row">
                <?php if($settings['text']){ ?>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                    <div class="sec-text text-anim">
                        <p><?php echo wp_kses($settings['text'], true); ?></p>
                    </div>
                </div>
                <?php } ?>
                
                <?php if($settings['title']){ ?>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                    <div class="sec-title-wrapper">
                        <h2 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true); ?></h2>
                    </div>
                </div>
                <?php } ?>
            </div>
        
            <div class="row pt-140">
                <div class="col-xxl-12">
                    <div class="service__list-2 animation__service-2">
                        <?php foreach($settings['features'] as $key => $item): ?>
                        <div class="service__item-2">
                            <div>
                                <?php if($item['icon_image']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($item['icon_image']['id'])); ?>" alt="<?php esc_attr_e('Feature Icon', 'axtra'); ?>"><?php } ?>
                                <h3 class="service__title-2"><?php echo wp_kses($item['block_title'], true); ?></h3>
                                <p><?php echo wp_kses($item['block_text'], true); ?></p>
                                
								<?php $features_list = $item['features_list'];
									if(!empty($features_list)){
									$features_list = explode("\n", ($features_list)); 
								?>
                                <ul>
                                    <?php foreach($features_list as $features): ?>
                                    <li><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?>
                                
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <?php if($settings['btn_title']){ ?>
                <div class="col-xxl-12">
                    <div id="btn_wrapper" class="service__btn-2">
                        <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="wc-btn-pink btn-hover btn-item"><span></span> <?php echo wp_kses($settings['btn_title'], true); ?>  <i class="fa-solid fa-arrow-right"></i></a>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </section>
    <!-- Service area end -->
    
    <?php else: ?>
    
    <!-- Feature area start -->
    <section class="feature__area-2 pt-130">
        <div class="feature__top">
            <div class="container">
                <div class="row">
                    <?php if($settings['title']){ ?>
                    <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-6">
                        <div class="sec-title-wrapper">
                        	<h2 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true); ?></h2>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if($settings['text']){ ?>
                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-6">
                        <div class="feature__text text-anim">
                            <p><?php echo wp_kses($settings['text'], true); ?> </p>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    
        <div class="feature__btm">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="feature__list animation__feature2">
                            <?php foreach($settings['features'] as $key => $item): ?>
                            <div class="feature__item">
                                <?php if($item['icon_image']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($item['icon_image']['id'])); ?>" alt="<?php esc_attr_e('Feature Icon', 'axtra'); ?>"><?php } ?>
                                <h3 class="feature__title"><?php echo wp_kses($item['block_title'], true); ?></h3>
                                <p><?php echo wp_kses($item['block_text'], true); ?></p>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Feature area end -->
	  
	<?php endif;
    }
}
