<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Client extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_our_client';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Clients', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'our_client',
            [
                'label' => esc_html__( 'Choose Template', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/clients/client_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/clients/client_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/clients/client_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/clients/client_layout_four.png'
					],
					'five' => [
						'label' => esc_html__('Layout 5', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/clients/client_layout_five.png'
					],
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF Line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['three', 'four']
				],
			]
		);
		$this->add_control(
			'count_num',
			[
				'label'       => __( 'Count Number', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Count Number', 'axtra' ),
				'condition' => [
					'layout_control'      => ['five']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two', 'five']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'description',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['five']
				],
			]
		);
		
		$this->end_controls_section();
   		
		$this->cf_repeater_slider_control();
		/** Style Tab **/
		
		/**Count number Style**/		
		$this->start_controls_section(
			'count_num_style',
			[
				'label' => esc_html__('Cunter Number STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_count_num_style',
			[
				'label'       => __( 'ON/OFF Cunter Number Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'count_num_typography',
                'label' => __('Cunter Number Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .react_border span',
                'separator' => 'before',
				'condition'             => [
					'show_count_num_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'count_num_color',
            [
                'label' => __('Cunter Number Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .react_border span' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_count_num_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		
		/**Sub title Style**/
		$this->start_controls_section(
			'client_sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_client_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'client_sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '
					{{WRAPPER}} .sec-sub-title,
					{{WRAPPER}} .client__area-8 .about-sub-right
				',
                'separator' => 'before',
				'condition'             => [
					'show_client_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'client_sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .client__area-8 .about-sub-right' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_client_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => '
                    {{WRAPPER}} .brand__title-3,  
					{{WRAPPER}} .sec-title,
					{{WRAPPER}} .client__section__title
				',                 
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .brand__title-3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .client__section__title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .client__section__dis',               
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .client__section__dis' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
    }
	
	/**
	 *	Repeater TAB
	 **/
	protected function cf_repeater_slider_control()
	{

		$this->start_controls_section(
			'Sponcers',
			[
				'label'                 => __('Clients', 'axtra'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'client_image',
			[
				'label'                 => esc_html__('Choose Image', 'axtra'),
				'type'                  => Controls_Manager::MEDIA,
				'default'               => [
					'url' => Utils::get_placeholder_image_src(),
				]
			]
		);
		$this->add_control(
			'client',
			[
				'label'                 => __('Add Clients Item', 'axtra'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
	
	$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    
	
	<?php if($settings['layout_control'] == 'five'): ?>
    
    <!-- client 8 -->
    <div class="client__area-8 sp-x">
    	<?php if($settings['subtitle']){ ?><h6 class="text-end about-sub-right"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h6><?php } ?>
        <?php if($settings['count_num']){ ?>
        <div class="section_wrapper">
        	<h4 class="react_border"><span><?php echo wp_kses($settings['count_num'], true);?></span></h4>
        </div>
        <?php } ?>
        
        <?php if($settings['title'] || $settings['description']){ ?>
        <div class="client__section">
            <?php if($settings['title']){ ?><h2 class="client__section__title fade_bottom_5"> <?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
        	<?php if($settings['description']){ ?><p class="client__section__dis fade_bottom_5"> <?php echo wp_kses($settings['description'], true);?></p><?php } ?>
        </div>
        <?php } ?>
        <div class="client__logo">
        	<?php foreach($settings['client'] as $key => $item): ?>
        	<img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>" class="fade_bottom_5">
        	<?php endforeach;?> 
        </div>
    </div>
    <!-- /client 8 -->
    
    <?php elseif($settings['layout_control'] == 'four'): ?>
    
    <!-- Brand area start -->
    <section class="brand__area">
        <div class="container line pt-140 pb-110 no-p">
        	<?php if( $settings[ 'show_line_pattern' ]){ ?><span class="line-3"></span><?php } ?>
            <div class="row">
                <div class="col-xxl-12">
                    <?php if( $settings[ 'title' ]){ ?><h2 class="brand__title-3 title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?> </h2><?php } ?>
                    <div class="brand__list brand-gap">
                    	<?php foreach($settings['client'] as $key => $item): ?>
                        <div class="brand__item-2 fade_bottom">
                        	<img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>">
                        </div>
                    	<?php endforeach;?> 
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Brand area end -->
	
	<?php elseif($settings['layout_control'] == 'three'): ?>
	
    <!-- Brand area start -->
    <section class="brand__area-4">
        <div class="container g-0 line_4 pt-130 pb-150">
            <?php if( $settings[ 'show_line_pattern' ]){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
            <div class="row">
                <div class="col-xxl-12">
                    <?php if( $settings[ 'title' ]){ ?><h2 class="brand__title-3 title-anim" data-speed="1"><?php echo wp_kses( $settings[ 'title' ], true );?> </h2><?php } ?>
                    <div class="brand__list-3">
                        <?php foreach($settings['client'] as $key => $item): ?>
                        <div class="brand__item-2 fade_bottom">
                            <img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>">
                        </div>
                        <?php endforeach;?>                    
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Brand area end -->
    
	<?php elseif($settings['layout_control'] == 'two'): ?>
    <!-- Brand area start -->
    <section class="brand__area">
        <div class="container g-0 line pt-140 pb-130">
        	<span class="line-3"></span>
            <div class="row">
                <?php if( $settings[ 'subtitle' ] || $settings[ 'title' ]){ ?>
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper">
                        <?php if( $settings[ 'subtitle' ]){ ?><h2 class="sec-sub-title title-anim"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if( $settings[ 'title' ]){ ?><h3 class="sec-title title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                    </div>
                </div>
            	<?php } ?>
                <div class="col-xxl-12">
                    <div class="brand__list">
                        <?php foreach($settings['client'] as $key => $item): ?>
                        <div class="brand__item fade_bottom">
                        	<img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>">
                        </div>
                    <?php endforeach;?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Brand area end -->
    
    <?php else:?>
    
    <!-- Brand area start -->
    <section class="brand__area">
        <div class="container pt-140 pb-140">
            <div class="row">
                <div class="col-xxl-12">
                    <?php if( $settings[ 'title' ] ):?>
                    <h2 class="brand__title-3 title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                    <?php endif;?>
                    
                    <div class="brand__list-3">
                        <?php foreach($settings['client'] as $key => $item): ?>
                        <div class="brand__item-2 fade_bottom">
                        	<img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>">
                        </div>
                    	<?php endforeach;?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Brand area end -->
        
    <?php endif;
    }
}
