<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'axtra_latest_news';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Latest News', 'axtra' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'axtra' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'latest_news',
			[
				'label' => esc_html__( 'Latest News', 'axtra' ),
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/news/news_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/news/news_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/news/news_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/news/news_layout_four.png'
					],
					'five' => [
						'label' => esc_html__('Layout 5', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/news/news_layout_five.png'
					],
					'six' => [
						'label' => esc_html__('Layout 6', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/news/news_layout_six.png'
					],
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF Line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['five']
				],
			]
		);
		$this->add_control(
			'style_two',
			[
				'label'       => __( 'Enable/Disable Space', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'three', 'five']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six' ]
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'five', 'six']
				],
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two', 'five']
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'layout_control'      => ['two', 'five']
				],
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six']
				],
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six']
				],
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six']
				],
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'axtra'),
			  'label_block' => true,
			  'options' => get_blog_categories(),
			  'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six']
			  	],
			]
		);	
		$this->add_control(
			'show_pattern',
			[
				'label'       => __( 'ON/OFF Patterns Line', 'axtra' ),
                'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'show_pagination',
			[
				'label'       => __( 'Enable/Disable Pagination', 'axtra' ),
                'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['one', 'six']
				],
			]
		);	
		$this->end_controls_section();
	
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '{{WRAPPER}} .sec-sub-title',
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title',                
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .blog__area-3 .sec-title-wrapper p', 
					'{{WRAPPER}} .blog__area-2 .sec-text p',                
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__area-3 .sec-title-wrapper p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .blog__area-2 .sec-text p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item:hover span',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' =>
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .btn-item',				
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Post Item Style**/
		$this->start_controls_section(
			'loop_post_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		/**Post Meta Description Style**/
		$this->add_control(
			'show_loop_meta_style',
			[
				'label'       => __( 'ON/OFF Post Meta Description Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_meta_typography',
                'label' => __('Post Meta Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .blog__meta',
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_meta_color',
            [
                'label' => __('Post Meta Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__meta a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .blog__meta' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_meta_hover_color',
            [
                'label' => __('Post Meta Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__meta a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .blog__meta:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		/**Post Title Style**/
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .blog__title-3',
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__title-3' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Post Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__title-3:hover' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		/**Post Button Style**/
		$this->add_control(
			'show_loop_btn_style',
			[
				'label'       => __( 'ON/OFF Post Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_btn_typography',
                'label' => __('Post Button Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .blog__btn',
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_color',
            [
                'label' => __('Post Button Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__btn' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_hover_color',
            [
                'label' => __('Post Button Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog__btn:hover' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( axtra_set( $settings, 'query_category' ) ) $args['category_name'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
	{ ?>
    
    <?php if($settings['layout_control'] == 'six'): ?>
	
	<!-- Blog area start -->
    <section class="blog__area-6 blog__animation">
        <div class="container g-0 line pt-110 pb-110">
            <span class="line-3"></span>
            <?php if($settings[ 'title' ] || $settings[ 'text' ]){ ?>
            <div class="row pb-130">
                <?php if($settings[ 'title' ]){ ?>
                <div class="col-xxl-8 col-xl-7 col-lg-6 col-md-6">
                    <div class="sec-title-wrapper">
                    	<h2 class="sec-title-2 animation__char_come"><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                    </div>
                </div>
                <?php } ?>
                <?php if($settings[ 'text' ]){ ?>
                <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-6">
                    <div class="blog__text">
                        <p><?php echo wp_kses( $settings[ 'text' ], true );?> </p>
                    </div>
                </div>
                <?php } ?>
            </div>
    		<?php } ?>
            
            <div class="row reset-grid">
            	<?php while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <article class="blog__item">
                        <?php if(has_post_thumbnail()){ ?>
                        <div class="blog__img-wrapper">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="img-box">
                                    <?php the_post_thumbnail('axtra_390x450', array( 'class'=> 'image-box__item')); ?>
                                    <?php the_post_thumbnail('axtra_390x450', array( 'class'=> 'image-box__item')); ?>
                                </div>
                            </a>
                        </div>
                        <?php } ?>
                        <h4 class="blog__meta">
                        	<?php the_category(' '); ?> . 
                            <?php echo wp_kses(get_the_date(), true);?>
                        </h4>
                        <h5><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__title"><?php the_title(); ?></a></h5>
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__btn"><?php esc_html_e('Read More', 'axtra'); ?> <span><i class="fa-solid fa-arrow-right"></i></span></a>
                    </article>
                </div>
            	<?php endwhile; ?>
            </div>
            
            <!--Pagination-->
			<?php if($settings['show_pagination']) {?>
            <div class="blog__pagination wow wcfadeUp ">
                <?php axtra_the_pagination2(array('total'=>$query->max_num_pages, 'next_text' => '<i class="fa fa-angle-right"></i>', 'prev_text' => '<i class="fa fa-angle-left"></i>')); ?>
            </div>
            <?php } ?>
            
        </div>
    </section>
    <!-- Blog area end -->
	
	<?php elseif($settings['layout_control'] == 'five'): ?>
    
    <!-- Blog area start -->
    <section class="blog__area-4 blog__animation">
        <div class="container g-0 line_4 pt-150 pb-150">
            <?php if($settings[ 'show_line_pattern' ]){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
             
            <div class="row">
                <?php if($settings[ 'subtitle' ] || $settings[ 'title' ] || $settings[ 'text' ] || $settings[ 'btn_title' ]){ ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="sec-title-wrapper text-anim">
                        <?php if($settings[ 'subtitle' ]){ ?><h2 class="sec-subtile-6"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'title' ]){ ?><h3 class="sec-title-6 title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                        <?php if($settings[ 'text' ]){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                        <?php if($settings[ 'btn_title' ]){ ?><a class="btn-started" href="<?php echo esc_url( $settings[ 'btn_link' ]['url'] );?>"><?php echo wp_kses( $settings[ 'btn_title' ], true );?> <span><i class="fa-solid fa-arrow-right"></i></span></a><?php } ?>
                    </div>
                </div>
                <?php } ?>
                
                <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <article class="blog__item-4">
                        <?php if(has_post_thumbnail()){ ?>
                        <div class="blog__img-4">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                            	<?php the_post_thumbnail('axtra_390x260'); ?>
                            </a>
                        </div>
                        <?php } ?>
                        <h4 class="blog__meta-4">
                        	<?php the_category(' '); ?> 
                            <span><?php echo wp_kses(get_the_date(), true);?></span>
                        </h4>
                        <h5><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__title-4"><?php the_title(); ?></a></h5>
                    	<a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__btn-4"><?php esc_html_e('Read More', 'axtra'); ?> <span><i class="fa-solid fa-arrow-right"></i></span></a>
                    </article>
                </div>
            	<?php endwhile; ?>
            </div>
            
            
            
        </div>
    </section>
    <!-- Blog area end -->
    
	<?php elseif($settings['layout_control'] == 'four'): ?>
	
    <!-- Blog area start -->
    <section class="blog__area-7 blog__animation">
        <div class="container g-0 pb-140">
            <div class="row">
                <?php if($settings['title']){ ?>
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
                    <div class="sec-title-wrapper">
                    	<h3 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true);?></h3>
                    </div>
                </div>
                <?php } ?>
                
                <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <article class="blog__item">
                        <?php if(has_post_thumbnail()){ ?>
                        <div class="blog__img-wrapper">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="img-box">
                                    <?php the_post_thumbnail('axtra_390x450', array( 'class'=> 'image-box__item')); ?>
                                    <?php the_post_thumbnail('axtra_390x450', array( 'class'=> 'image-box__item')); ?>
                                </div>
                            </a>
                        </div>
                        <?php } ?>
                        
                    	<h4 class="blog__meta">
                        	<?php the_category(' '); ?> . 
                            <?php echo wp_kses(get_the_date(), true);?>
                        </h4>
                    	<h5><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__title"><?php the_title(); ?></a></h5>
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__btn"><?php esc_html_e('Read More', 'axtra'); ?> <span><i class="fa-solid fa-arrow-right"></i></span></a>
                    </article>
                </div>
            	<?php endwhile; ?>
            </div>
        </div>
    </section>
    <!-- Blog area end -->
	
	<?php elseif($settings['layout_control'] == 'three'): ?>
	
    <!-- Blog area start -->
    <section class="blog__area no-pb blog__animation">
        <div class="container g-0 line pt-150 pb-140">
        	<span class="line-3"></span>
            <div class="row">
                <?php if($settings['subtitle'] || $settings['title']) { ?>
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
                    <div class="sec-title-wrapper">
                        <?php if($settings['subtitle']) { ?><h2 class="sec-sub-title"><?php echo wp_kses($settings['subtitle'], true);?></h2><?php } ?>
                        <?php if($settings['title']) { ?><h3 class="sec-title"><?php echo wp_kses($settings['title'], true);?></h3><?php } ?>
                    </div>
                </div>
                <?php } ?>
                
				<?php while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <article class="blog__item">
                        <div class="blog__img-wrapper">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="img-box">
                                    <?php the_post_thumbnail('axtra_390x450', array( 'class'=> 'image-box__item')); ?>
                                    <?php the_post_thumbnail('axtra_390x450', array( 'class'=> 'image-box__item')); ?>
                                </div>
                            </a>
                        </div>
                    	<h4 class="blog__meta">
                        	<?php the_category(' '); ?> . 
                            <?php echo wp_kses(get_the_date(), true);?>
                        </h4>
                    	<h5><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__title"><?php the_title(); ?></a></h5>
                    	<a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__btn"><?php esc_html_e('Read More', 'axtra');?> <span><i class="fa-solid fa-arrow-right"></i></span></a>
                    </article>
                </div>
            	<?php endwhile; ?>
            </div>
        </div>
    </section>
    <!-- Blog area end -->
	
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Blog area start -->
    <section class="blog__area-2 blog__animation">
        <div class="container g-0 pt-150 pb-110">
            <div class="row ">
                <?php if($settings['title']) { ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="sec-title-wrapper">
                    	<h2 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true);?></h2>
                    </div>
                </div>
                <?php } ?>
                
                <?php if($settings['text']) { ?>
                <div class="col-xxl-4 col-xl-4 col-lg-5 col-md-4">
                    <div class="sec-text text-anim">
                    	<p><?php echo wp_kses($settings['text'], true);?></p>
                    </div>
                </div>
                <?php } ?>
                
                <?php if($settings['btn_title']){ ?>
                <div class="col-xxl-4 col-xl-4 col-lg-3 col-md-4">
                    <div id="btn_wrapper" class="sec-btn">
                        <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="wc-btn-pink btn-hover btn-item"><span></span> <?php echo wp_kses($settings['btn_title'], true); ?> <i class="fa-solid fa-arrow-right"></i></a>
                    </div>
                </div>
                <?php } ?>
            </div>
        
            <div class="row">
            	<?php while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <article class="blog__item-2">
                        <div class="blog__img-wrapper">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="img-box">
                                    <?php the_post_thumbnail('axtra_367x500', array( 'class'=> 'image-box__item')); ?>
                                    <?php the_post_thumbnail('axtra_367x500', array( 'class'=> 'image-box__item')); ?>
                                </div>
                            </a>
                        </div>
                        <h4 class="blog__meta-2">
                        	<?php the_category(' '); ?> . 
                            <?php echo wp_kses(get_the_date(), true);?>
                        </h4>
                        <h5><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__title-2"><?php the_title(); ?></a></h5>
                    </article>
                </div>
            	<?php endwhile; ?>
            </div>
        </div>
    </section>
    <!-- Blog area end -->
    
    <?php else: ?>
    
    <!-- Blog area start -->
    <section class="blog__area-3 <?php if($settings['style_two']) echo 'blog-v3'; else echo 'pb-140'; ?> blog__animation">
        <div class="container <?php if( $settings['show_pattern'] ){?>line<?php };?>">
        	<?php if( $settings['show_pattern'] ){?><div class="line-3"></div><?php };?>
            <?php if($settings['subtitle'] || $settings['title'] || $settings['text']) { ?>
            <div class="row ">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper text-anim pt-130">
                        <?php if($settings['subtitle']) { ?><h2 class="sec-sub-title"><?php echo wp_kses($settings['subtitle'], true);?></h2><?php } ?>
                        <?php if($settings['title']) { ?><h3 class="sec-title title-anim"><?php echo wp_kses($settings['title'], true);?></h3><?php } ?>
                        <?php if($settings['text']) { ?><p><?php echo wp_kses($settings['text'], true);?></p><?php } ?>
                    </div>
                </div>
            </div>
        	<?php } ?>
            <div class="row">
            	<?php while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="col-xxl-6 col-xl-6 col-lg-6">
                    <article class="blog__item-3">
                        <div class="blog__img-wrapper-3">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="img-box">
                                    <?php the_post_thumbnail('axtra_367x500', array( 'class'=> 'image-box__item')); ?>
                                    <?php the_post_thumbnail('axtra_367x500', array( 'class'=> 'image-box__item')); ?>
                                </div>
                            </a>
                        </div>
                        <div class="blog__info-3">
                            <h4 class="blog__meta">
								<?php the_category(' '); ?> . 
                                <?php echo wp_kses(get_the_date(), true);?>
                            </h4>
                            <h5><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__title-3"><?php the_title(); ?></a></h5>
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="blog__btn"><?php esc_html_e('Read More', 'axtra'); ?> <span><i
                            class="fa-solid fa-arrow-right"></i></span></a>
                        </div>
                    </article>
                </div>
            	<?php endwhile; ?>
            </div>
            
            <?php if($settings['show_pagination']) {?>
            <div class="blog__pagination wow wcfadeUp pb-30">
                <?php axtra_the_pagination2(array('total'=>$query->max_num_pages, 'next_text' => '<i class="fa fa-angle-right"></i>', 'prev_text' => '<i class="fa fa-angle-left"></i>')); ?>
            </div>
            <?php } ?>
            
        </div>
    </section>
    <!-- Blog area end -->
	<?php endif;?>
    
    <?php }
	wp_reset_postdata();
	}

}
