<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Interactive_Image_Slider extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_interactive_image_slider';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Interactive Image Slider', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'image-slider-script', YT_URL . 'assets/js/image-slider.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'image-slider-script' ];
	}

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'interactive_image_slider',
            [
                'label' => esc_html__( 'Interactive Image Slider', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/interactive-slider-image.png'
					],
				],
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'axtra'),
			  'label_block' => true,
			  'options' => get_project_categories(),
			]
		);
		$this->end_controls_section();
   	 	
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Post Sub Title Style**/
		$this->start_controls_section(
			'post_subtitle_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_post_subtitle_style',
			[
				'label'       => __( 'ON/OFF Post Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_subtitle_typography',
                'label' => __('Post Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .gallary12__content__name',
				'separator' => 'before',
				'condition'             => [
					'show_post_subtitle_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'post_subtitle_color',
            [
                'label' => __('Post Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .gallary12__content__name' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_post_subtitle_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_post_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .gallary12__content__title,
					{{WRAPPER}} .gallary12__content__title span',
				'separator' => 'before',
				'condition'             => [
					'show_post_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'post_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .gallary12__content__title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .gallary12__content__title span' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_post_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		
		
	}
	
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( axtra_set( $settings, 'query_category' ) ) $args['project_cat'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
	{ ?>
	
    <div class="hero__area-15">
        <div class="swiper-container main-slider">
            <div class="swiper-wrapper">
                <?php 
					while ( $query->have_posts() ) : $query->the_post(); 
					$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
				?>
                <div class="swiper-slide">
                    <a href="<?php echo esc_url( get_permalink( get_the_id() ) );?>">
                        <div class="gallary12">
                            <div class="gallary12__content">
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/portfolio/portfolio-home-5/arrow-up.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>">
                                <span class="gallary12__content__name"><?php echo implode( ', ', (array)$term_list );?> - <?php echo esc_attr(get_the_date('Y')); ?></span>
                                <h4 class="gallary12__content__title"><?php the_title(); ?> </h4>
                            </div>
                            <div class="gallary12__thumb">
                                <?php the_post_thumbnail('axtra_1920x950'); ?>
                            </div>
                        </div>
                    </a>
                </div>
                <?php endwhile; ?>
            </div>
        
            <div class="swiper-pagination"></div>
        </div>
    
        <div class="swiper-container thumb-slider">
            <div class="swiper-wrapper" role="navigation">
                <?php 
					global $post;
					while ( $query->have_posts() ) : $query->the_post();
					$post_thumbnail_id = get_post_thumbnail_id($post->ID);
           			$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id); 
				?>
                <div class="swiper-slide">
                    <div class="gallary__thumb" style="background-image:url(<?php echo esc_url($post_thumbnail_url); ?>)">
                    </div>
                </div>
            	<?php endwhile; ?>
            </div>
        </div>
    </div>
           
    <?php }
    wp_reset_postdata();
	}

}
