<?php

namespace AXTRAPLUGIN\Element;


class Elementor {
	static $widgets = array(
		//Home Page One
		'our_banner',
		'our_client',
		'who_we_are',
		'our_services',
		'our_projects',
		'our_testimonials',
		'why_choose_us',
		'pricing_table',
		'latest_news',
		
		//Home Page Two
		'our_features',
		'roll_silde_area',
		'about_us',
		'our_awards',
		'call_to_action',
		
		//Home Page Three
		'about_us_v2',		
		'funfacts',
		'how_we_work',
		'our_testimonials_v2',
		
		//Home Page Four
		'parallax_image',
		'project_awards',
		'our_team',
		
		//Home Page Five
		'how_we_work_v2',
		'our_faqs',
		'our_approch',
		
		//Home Page Six
		'personal_portfolio',
		
		//Home Page Seven
		'portfolio_banner',
		'portfolio_showcase',
		'what_we_do',
		
		//Inner Pages
		'our_story',
		'digital_solution',
		'service_tabs',
		'portfolio_v2_banner',
		'our_team',
		'talented_team_title',
		'contact_us',
		'join_our_team',
		'our_careers',
		'career_benefits',
		'clients',
		'design_development',		
		'inspired_creativity',
		'select_work',
		'video_section',			
		'design_and_technology',
		'our_awards_v2',
		'showcase_carousel',
		'interactive_link',
		'portfolio_masonry',
		'interactive_image_slider',
		'showcase_parallax',
		'logo_showcase',
		'showcase_slider',
		'interactive_hover_showcase'
		
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = AXTRAPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}

			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\AXTRAPLUGIN\\Element\\' . ucwords( $widget );

			if ( class_exists( $class ) ) {
				$elemntor->register( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'axtra',
			[
				'title' => esc_html__( 'Axtra', 'axtra' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'crowdyflow', 'axtra' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}
}

Elementor::init();