<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Digital_Solution extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_digital_solution';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Digital Solution', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'digital_solution',
            [
                'label' => esc_html__( 'Digital Solution', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/solution/solution_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/solution/solution_layout_two.png'
					],
				],
			]
		);
		$this->add_control(
			'show_pattern_image',
			[
				'label'       => __( 'ON/OFF Pattern Icon', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);	
		$this->add_control(
			'feature_image1',
			[
				'label' => __( 'Feature Image V1', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'feature_image2',
			[
				'label' => __( 'Feature Image V2', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'feature_image3',
			[
				'label' => __( 'Feature Image V3', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'title2',
			[
				'label'       => __( 'Title V2', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title V2', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'service_title',
			[
				'label'       => __( 'Service Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Service Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->end_controls_section();
   		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .hero__text-7 .about',
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .hero__text-7 .about' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .solution__title,   
                    {{WRAPPER}} .hero__title-7',               
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .solution__title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .hero__title-7' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .solution__mid p, 
                    {{WRAPPER}} .solution__btm li, 
                    {{WRAPPER}} .hero__text-7 p',               
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .solution__mid p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .solution__btm li' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .hero__text-7 p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <?php if($settings['layout_control'] == 'two'): ?>
    
    <!-- Hero area start -->
    <section class="hero__area-7">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12">
                    <?php if($settings['title'] || $settings['title2']){ ?>
                    <div class="hero__title-wrap-7">
                        <h1 class="hero__title-7"><?php echo wp_kses($settings['title'], true);?> <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/home-7/shape-1.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>">
                        <?php echo wp_kses($settings['title2'], true);?> <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/home-7/shape-2.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>"></h1>
                    </div>
                    <?php } ?>
                    <div class="hero__text-7">
                        <?php if($settings['service_title']){ ?><h2 class="about"><?php echo wp_kses($settings['service_title'], true);?></h2><?php } ?>
                        <?php if($settings['text']){ ?><p><?php echo wp_kses($settings['text'], true);?></p><?php } ?>
                    </div>
                </div>
            </div>
        </div>
    	<?php if($settings['show_pattern_image']){ ?>
    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/home-7/shape-3.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>" class="shape-1">
        <?php } ?>
    </section>
    <!-- Hero area end -->
    
	<?php else: ?>
    
    <!-- Hero area start -->
    <section class="solution__area">
    	<div class="container hero-line"></div>
        <div class="solution__wrapper">
            <?php if($settings['feature_image1']['id'] || $settings['feature_image2']['id']){ ?>
            <div class="solution__left">
                <?php if($settings['feature_image1']['id']){ ?>
                <div class="solution__img-1">
                	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image1']['id']));?>" alt="<?php esc_attr_e('Solution Image', 'axtra'); ?>">
                </div>
                <?php } ?>
                <?php if($settings['feature_image2']['id']){ ?>
                <div class="solution__img-2">
                	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image2']['id']));?>" alt="<?php esc_attr_e('Solution Image', 'axtra'); ?>">
                </div>
                <?php } ?>
            </div>
        	<?php } ?>
            
			<?php if($settings['title'] || $settings['text']){ ?>
            <div class="solution__mid">
                <?php if($settings['title']){ ?><h1 class="solution__title animation__char_come"><?php echo wp_kses($settings['title'], true);?></h1><?php } ?>
                <?php if($settings['text']){ ?><p><?php echo wp_kses($settings['text'], true);?></p><?php } ?>
            </div>
        	<?php } ?>
            
            <?php if($settings['feature_image3']['id']){ ?>
            <div class="solution__right">
                <div class="solution__img-3">
                	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image3']['id']));?>" alt="<?php esc_attr_e('Solution Image', 'axtra'); ?>">
                </div>
            </div>
            <?php } ?>
        </div>
    	
        <?php $features_list = $settings['features_list'];
			if(!empty($features_list)){
			$features_list = explode("\n", ($features_list)); 
		?>
        <div class="container pb-130">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="solution__btm">
                        <ul>
                            <?php foreach($features_list as $features): ?>
                            <li><?php echo wp_kses($features, true); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
        
    	<?php if($settings['show_pattern_image']){ ?>
        <div class="solution__shape">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/icon/1.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>" class="shape-1">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images//icon/2.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>" class="shape-2">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images//icon/3.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>" class="shape-3">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images//icon/4.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>" class="shape-4">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images//icon/5.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>" class="shape-5">
        </div>
        <?php } ?>
    </section>
    <!-- Hero area end -->
              
    <?php endif; 
    }
}
