<?php namespace AXTRAPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Call_To_Action extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_call_to_action';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Call To Action', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'call_to_action',
            [
                'label' => esc_html__( 'Call To Action', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/cta/cta_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/cta/cta_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/cta/cta_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/cta/cta_layout_four.png'
					],
					'five' => [
						'label' => esc_html__('Layout 5', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/cta/cta_layout_five.png'
					],
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF Line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['four', 'five']
				],
			]
		);
		$this->add_control(
			'style_two',
			[
				'label'       => __( 'Enable/Disable Top Space', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'show_pattern_image',
			[
				'label'       => __( 'ON/OFF Pattern Images', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['four']
				],
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['four']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->end_controls_section();
   		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .cta__sub-title-2,
					{{WRAPPER}} .cta__sub-title',
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .cta__sub-title-2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta__sub-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .cta__title-2,
					{{WRAPPER}} .cta__title,
					{{WRAPPER}} .cta__title-4,
					{{WRAPPER}} .sec-title',
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .cta__title-2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta__title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta__title-4' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .cta__content-4 p,
                    {{WRAPPER}} .faq__btm p',
				'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .cta__content-4 p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .faq__btm p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .btn-item,{{WRAPPER}} .btn-started',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item:hover span,	
					{{WRAPPER}} .btn-started:hover',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn-started' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-started',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'border-color: {{VALUE}}!important',
                    '{{WRAPPER}} .btn-started:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' =>
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-started',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn-started' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .btn-item,
					{{WRAPPER}} .btn-started',				
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'color: {{VALUE}}!important',
                    '{{WRAPPER}} .btn-started' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'color: {{VALUE}}!important',
                    '{{WRAPPER}} .btn-started:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <?php if($settings['layout_control'] == 'five'): ?>
	
    <!-- CTA area start -->
    <section class="faq__btm">
        <div class="container line pb-130">
        	<?php if($settings[ 'show_line_pattern' ]){ ?><div class="line-3"></div><?php } ?>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper">
                        <?php if($settings[ 'title' ]){ ?><h2 class="sec-title title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'text' ]){ ?><p class="sub-title-anim"><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                        <?php if($settings[ 'btn_title' ]){ ?>
                        <div id="btn_wrapper">
                        	<a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="wc-btn-primary btn-hover btn-item"><span></span><?php echo wp_kses( $settings[ 'btn_title' ], true );?> <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA area end -->
	
	<?php elseif($settings['layout_control'] == 'four'): ?>
    
    <!-- CTA area start -->
    <div class="cta__area-4">
        <div class="container g-0 line_4 pb-150">
            <?php if($settings[ 'show_line_pattern' ]){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
            
            <div class="cta__inner-4">
                <div class="row">
                    <?php if($settings['feature_image']['id']){ ?>
                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                        <div class="cta__content-4">
                        	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
                        </div>
                    </div>
                    <?php } ?>
                    
					<?php if($settings[ 'title' ]){ ?>
                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                        <div class="cta__content-4">
                        	<h2 class="cta__title-4 title-anim"><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                        </div>
                    </div>
                    <?php } ?>
                    
                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                        <div class="cta__content-4 text-anim">
                            <?php if($settings[ 'text' ]){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                            <?php if($settings[ 'btn_link' ]['url']){ ?><a class="btn-started" href="<?php echo esc_url( $settings[ 'btn_link' ]['url'] );?>"><?php echo wp_kses( $settings[ 'btn_title' ], true );?> <span><i class="fa-solid fa-arrow-right"></i></span></a><?php } ?>
                        </div>
                    </div>
                </div>
            	
				<?php if($settings[ 'show_pattern_image' ]){ ?>
                <img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/shape/21.png" alt="<?php esc_attr_e('shape Image', 'axtra'); ?>" class="cta-shape">
                <img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images//shape/22.png" alt="<?php esc_attr_e('shape Image', 'axtra'); ?>" class="cta-shape-2">
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- CTA area end -->
	
	<?php elseif($settings['layout_control'] == 'three'): ?>
    
    <!-- CTA area start -->
    <section class="cta__area cta__area-7 pt-130">
        <div class="container pb-110">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="cta__content">
                    	<?php if($settings['subtitle']){ ?><p class="cta__sub-title"><?php echo wp_kses($settings['subtitle'], true);?></p><?php } ?>
                        <?php if($settings['title']){ ?><h2 class="cta__title title-anim"><?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
                        <?php if($settings['btn_title']){ ?>
                        <div id="btn_wrapper">
                            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="wc-btn-primary btn-hover btn-item"><span></span><?php echo wp_kses($settings['btn_title'], true); ?> <i
                            class="fa-solid fa-arrow-right"></i></a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA area end -->
	
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- CTA area start -->
    <section class="cta__area">
        <div class="container line <?php if($settings['style_two']) echo 'pt-140'; ?> pb-110">
        	<div class="line-3"></div>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="cta__content">
                        <?php if($settings['subtitle']){ ?><p class="cta__sub-title"><?php echo wp_kses($settings['subtitle'], true);?></p><?php } ?>
                        <?php if($settings['title']){ ?><h2 class="cta__title title-anim"><?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
                        <?php if($settings['btn_title']){ ?>
                        <div id="btn_wrapper">
                            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="wc-btn-primary btn-hover btn-item"><span></span><?php echo wp_kses($settings['btn_title'], true); ?> <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA area end -->
    
    <?php else: ?>
    
    <!-- CTA area start -->
    <section class="cta__area-2">
        <div class="container line pt-130 pb-120">
        	<div class="line-3"></div>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="cta__content-2">
                        <?php if($settings['subtitle']){ ?><p class="cta__sub-title-2 title-anim"><?php echo wp_kses($settings['subtitle'], true);?></p><?php } ?>
                        <?php if($settings['title']){ ?><h2 class="cta__title-2 title-anim"><?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
                        <?php if($settings['btn_title']){ ?>
                        <div id="btn_wrapper">
                            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="wc-btn-pink btn-hover btn-item"><span></span><?php echo wp_kses($settings['btn_title'], true); ?> <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA area end -->
               
    <?php endif;
    }
}
