jQuery(document).ready(function(){	
function {{uc_id}}_start(){		
  
  var objCarousel = jQuery('#{{uc_id}}');
  
  //start count buttons	
  {% if show_quantity_increment_buttons == "true" %}
  
  function initIncrButtons(){
  
    var addToCartBtn = objCarousel.find(".add_to_cart_button");      
      var minusBtn = objCarousel.find(".uc_carousel-count-buttons__minus");
      var parentItem, quantity, inputNumber;

      //if no add to cart button found then hide the incr buttons
      function checkButtonsVisibility(){

        var objItems = objCarousel.find('.ue-woo-item');

        objItems.each(function(){

          var objItem = jQuery(this);
          var objAddToCart = objItem.find(".add_to_cart_button");
          var objIncrButtons = objItem.find(".uc_carousel-count-buttons");
			
          if(!addToCartBtn.length)
          objIncrButtons.hide();

        });

      }

      // finds related elements of the parent item
      function findElements(buttonElement){
          parentItem = buttonElement.parents(".ue-woo-item");

          inputNumber = parentItem.find(".uc_carousel-count-buttons__number");

          addToCartBtn = parentItem.find(".add_to_cart_button");      
          minusBtn = parentItem.find(".uc_carousel-count-buttons__minus");

          quantity = parseInt(inputNumber.val());
      }

      // define count functions
      function plusItem(buttonElement){

          findElements(buttonElement);
          var newQuantity = quantity + 1;

          inputNumber.val(newQuantity);
          addToCartBtn.attr('data-quantity', newQuantity); 

          minusBtn.prop('disabled', false); 
      } 

      function minusItem(buttonElement){

          findElements(buttonElement);
          var newQuantity = quantity-1;

          if(newQuantity <= 0)
             return(true);

          inputNumber.val(newQuantity); 
          addToCartBtn.attr('data-quantity', newQuantity);

          if(newQuantity == 1)
            minusBtn.prop('disabled', true);

      }

      /**
      * on quantity input change
      */
      function onQuantityInputChange(){

        var objInput = jQuery(this);

        //get custom value
        var newQuantity = parseInt(objInput.val());

        //update general value quantity
        quantity = newQuantity;

        //find add to cart link
        var objAddToCartWrap = objInput.parents('.ue-woo-item');
        var objAddToCartLink = objAddToCartWrap.find('.uc-button-addcart');

        //update data-quantity attribute
        objAddToCartLink.attr('data-quantity', newQuantity); 

        //disable obj minus button if new quantity is 1
        var objMinusButton = objAddToCartWrap.find('.uc_carousel-count-buttons__minus');

        //enable click on minus button
        objMinusButton.prop('disabled', false); 

        if(newQuantity == 1)
        objMinusButton.prop('disabled', true);

      }

      jQuery("body").on("added_to_cart", function(event, arg,arg2,objButton){

          findElements(objButton);
          inputNumber.val(1); 

      });

      //init inputs

      var objInputs = objCarousel.find(".uc_carousel-count-buttons__number");
      objInputs.val(1);

      checkButtonsVisibility();

      objCarousel.on('click',".uc_carousel-count-buttons__plus", function(){
          plusItem(jQuery(this));

      });

      objCarousel.on('click', ".uc_carousel-count-buttons__minus", function(){
          minusItem(jQuery(this));
      });

      objCarousel.on('click', ".add_to_cart_button", function(){
          objLastButton = jQuery(this);
      });

      objInputs.on('input', onQuantityInputChange);
  
  }
  
  initIncrButtons();  
   
  {% endif %} 
  //end count buttons

  {% if redirect_to_checkout == "true" %}
      jQuery('#{{uc_id}} .uc-button-addcart').click(function(e) {

        var ueAddCartButton = jQuery(this);

        function checkAndRedirect(tryCount) {
          if (ueAddCartButton.hasClass('added')) {
            {% if redirect_to_checkout_open_in_new_tab == "false" %} window.location.href = "{{checkout_page_link}}"; {% endif %}
            {% if redirect_to_checkout_open_in_new_tab == "true" %} window.open("{{checkout_page_link}}", '_blank'); {% endif %}
          } else if (tryCount < 100) {
             setTimeout(function() {
             checkAndRedirect(tryCount + 1);
             }, 150);
          }
        }
                                                                                                                           
        checkAndRedirect(0);
                                                                                                                           
      });
  {% endif %}
  
  objCarousel.owlCarousel({
			    loop: {{loop}},
                rtl: {{rtl}},
                navText: ["<i class='{{left_arrow}}'></i>","<i class='{{right_arrow}}'></i>"],
                paddingType: "{{stage_padding_type}}",
                center:{{center}},
                nav: {{show_arrows}},
                autoplayTimeout:{{autoplay_interval}},
                smartSpeed: {{transition_speed}},  
                navigation:true,
                autoplay: {{autoplay}},
                autoplayHoverPause:{{autoplay_hover_pause}},
                setActiveClassOnMobile:{{active_on_mobile}},
                changeItemOnClick:{{scroll_on_click}},
                shuffle:{{shuffle}},
                mouseDrag:{{mouse_drag}},
                touchDrag:{{touch_drag}},
                mousewheelControl: {{enable_mouse_wheel_control}},
				margin: {{margin_between_items}},
                scrollToHead:{{scroll_to_head}},
                scrollToHeadOffset: {{scroll_to_head_offset}},
                autoWidth: {{justified_width}},
                responsive : {
					0 : {
						items:{{number_of_items_mobile}},
                        slideBy: {{slides_to_scroll_mobile}},
                        scrollToHeadForceOnMobile: {{scroll_to_head_forced_on_mobile}},          
                        {% if stage_padding_type != "none" %}
                             stagePadding: {{stagepadding_mobile}},
                        {% endif %}        
                        {% if center == "false" %}
                              dotsEach: {{show_dots_each_x_item_mobile}},
                        {% endif %}
                        {% if drag_end_speed_mobile is not empty %}dragEndSpeed:{{drag_end_speed_mobile}},{% endif %}
					},
					768 : {
						items:{{number_of_items_tablet}},
                        slideBy: {{slides_to_scroll_tablet}},

                                
                        {% if stage_padding_type != "none" %}
                             stagePadding: {{stagepadding_tablet}},
                        {% endif %}
                        {% if center == "false" %}
                              dotsEach: {{show_dots_each_x_item_tablet}},
                        {% endif %}
                        {% if drag_end_speed_tablet is not empty %}dragEndSpeed:{{drag_end_speed_tablet}},{% endif %}
					},
					980 : {
						items:{{number_of_items}},
                        slideBy: {{slides_to_scroll}},
                                
                        {% if stage_padding_type != "none" %}
                             stagePadding: {{stagepadding}},
                        {% endif %}   
                        {% if center == "false" %} 
                              dotsEach: {{show_dots_each_x_item}},
                        {% endif %}
                        {% if drag_end_speed is not empty %}dragEndSpeed:{{drag_end_speed}},{% endif %}
					} 
			}
	});
  
    {{ucfunc("put_remote_parent_js","objCarousel")}}  

	objCarousel.on("uc_ajax_sethtml",function(event, htmlItems, isAppend){
        
      	objCarousel.trigger("replace.owl.carousel",htmlItems);
      
        {% if show_quantity_increment_buttons == "true" %}
      		initIncrButtons();
        {% endif %}
        
      	objCarousel.trigger("refresh.owl.carousel");
         
    });
  
  
}if(jQuery("#{{uc_id}}").length) {{uc_id}}_start(); else
	jQuery( document ).on( 'elementor/popup/show', () => { if(jQuery("#{{uc_id}}").length) {{uc_id}}_start();});
});