#{{uc_id}}{
  min-height:1px;
  position:relative;
}

#{{uc_id}} *{
  box-sizing:border-box;
}


#{{uc_id}} .ue_woocommerce_product_label-custom-field{
	z-index: 100;
}

#{{uc_id}} .uc_image_carousel_content{ 
  box-sizing:border-box;
}

#{{uc_id}} .uc_image_carousel_placeholder{
  overflow:hidden;
  position:relative;
}


#{{uc_id}} .owl-nav .owl-prev{
    position:absolute;
    display:inline-block;
    text-align:center;
}

#{{uc_id}} .owl-nav .owl-next{
  position:absolute;
  display:inline-block;
  text-align:center;
}

#{{uc_id}} .uc_image_carousel_container_holder{
  text-align:{{text_align}};
  overflow:hidden;
}

#{{uc_id}} .uc_btn, 
#{{uc_id}} .uc-button-addcart, 
#{{uc_id}} .added_to_cart{
  display:{{button_style}};
  text-decoration:none;
  text-align:center;
}


#{{uc_id}} .uc_product_image--second{
  	width: 100%;
    height: 100%;
    object-fit: cover;
	position: absolute;
  	top: 0;
  	right: 0;
  	{% if swap_animation_type == "slide" %}
  		{% if swap_slide_direction == "left" %}
  			transform: translate(-100%, 0);
  		{% elseif swap_slide_direction == "right" %}
  			transform: translate(100%, 0);
  		{% elseif swap_slide_direction == "top" %}
    		transform: translate(0, -100%);
  		{% elseif swap_slide_direction == "bottom" %}
  			transform: translate(0, 100%);
  		{% endif %}    
  	{% elseif swap_animation_type == "fade" %}
  		opacity: 0;
  	{% endif %} 
  	transition: all .3s;
}

#{{uc_id}} .uc_image_carousel_placeholder:hover .uc_product_image--second{  
  	{% if swap_animation_type == "slide" %}
		transform: translate(0, 0);
  	{% elseif swap_animation_type == "fade" %}
  		opacity: 1;
  	{% endif %}
}


#{{uc_id}} .uc_product_image img{
  width:100%;
  font-size:0px;
}

#{{uc_id}} .owl-dots {
  overflow:hidden;
  display:{{show_dots}} !important;
  text-align:{{dot_alignment}};
}

#{{uc_id}} .owl-dot {
  border-radius:50%;
  display:inline-block;
}

{% if layout == "overlay" %}
	#{{uc_id}} .uc_image_carousel_content{
      position:absolute;
      top:0px;
      left:0px;
      bottom:0px;
      right:0px;
      opacity:0;
      transition:1s;
      display:flex;
      align-items:center;
      flex-direction:column;
      justify-content: center;
    }

	#{{uc_id}} .uc_image_carousel_container_holder:hover .uc_image_carousel_content{
      opacity:1;
    }

{% endif %}

{% if layout == "partial_overlay" %}
	#{{uc_id}} .uc_image_carousel_content{
     position:absolute;
     bottom:20px;
     left:20px;
     right:20px;
    }
{% endif %}

{% if layout == "partial_overlay" %}
	#{{uc_id}} .uc_image_carousel_content{
     position:absolute;
     bottom:20px;
     left:20px;
     right:20px;
    }
{% endif %}

{% if layout == "under_overlap" %}
	#{{uc_id}} .uc_image_carousel_content{
     margin-left:20px;
      margin-right:20px;
      margin-top:-30px;
      position:relative;
    }
{% endif %}

{% if layout == "reveal_from_bottom" %}
	#{{uc_id}} .uc_image_carousel_content{
        margin-left:0px;
        margin-right:0px;
        margin-top:0px;
        position:absolute;
      	bottom: -100%;
        left: 0;
        right: 0;
        transition: ease-in-out all 0.25s;
    }
    #{{uc_id}} .uc_image_carousel_container_holder:hover .uc_image_carousel_content{
		bottom: 0;
    }
{% endif %}

{% if layout == "side_by_side" %}
  #{{uc_id}} .uc_image_carousel_container_holder{
    display:flex;
    flex-direction:row!important;
  }
  #{{uc_id}} .uc_image_carousel_placeholder, #{{uc_id}} .uc_product_image, #{{uc_id}} .uc_image_carousel_placeholder a{
    display:flex;
  }
  #{{uc_id}} .uc_image_carousel_container_holder > div{
  }
  #{{uc_id}} .uc_image_carousel_container_holder img{
    height:100%;
  }
  #{{uc_id}} .uc_image_carousel_placeholder{
    width:50%;
  }

  #{{uc_id}} .uc_image_carousel_content{
    width:50%;
    display:flex;
    flex-direction:column;
    justify-content:center;
    align-items:center;
  }
{% endif %}

.uc-button-addcart.added{
  display:none !important;
}
.uc_post_title{
  font-size:21px;
}
.uc_overlay_image_carousel{
  min-height:1px;
}

.uc_prices > div{
  display:{{prices_style}};
}

#{{uc_id}} .uc_image_carousel_container_holder .uc_product_image{
  transition:0.5s;
}

{% if item_hover_effects == "grow" %}
  #{{uc_id}} .uc_image_carousel_container_holder:hover .uc_product_image{
    transform:scale(1.1,1.1);
  }
{% endif %}

{% if item_hover_effects == "desaturate" %}
  #{{uc_id}} .uc_image_carousel_container_holder:hover .uc_product_image{
    filter: grayscale(100%);
  }
{% endif %}

#{{uc_id}} .ue_woocommerce_product_carousel_sale_label{
  display:inline-flex;
  position:absolute;
  {{horizontal_snap}}:{{label_horizontal_distance}}px;
  {{vertical_snap}}:{{label_vertical_distance}}px;
  align-items:center;
  justify-content:center;
}

#{{uc_id}} .ue_woocommerce_product_grid_out_of_stock_label{
    position: absolute;
  	display:inline-flex;
    align-items:center;
    justify-content:center;
  	{{horizontal_snap}}:{{label_horizontal_distance}}px;
  	{{vertical_snap}}:{{label_vertical_distance}}px;
  	z-index: 1;
}

#{{uc_id}} .uc_image_carousel_content_inside{
  display:flex;
  flex-direction:column;
}

#{{uc_id}} .uc_buttons{
  margin-top:auto;
}

#{{uc_id}} .ue-woo-item{
  transition:0.3s;
}

{% if show_button_on_hover == "true" %}
  #{{uc_id}} .ue-woo-item .uc_buttons{
    opacity:0;
    transition:0.3s;
  }

  #{{uc_id}} .ue-woo-item:hover .uc_buttons{
    opacity:1;
    transition:0.3s;
  }
{% endif %}

{% if make_3d == "true" %} 
  #{{uc_id}} .ue-item {
      opacity: 0.3;
      transform: scale3d(0.8, 0.8, 1);
      transition: all 0.3s ease-in-out;
  }

  #{{uc_id}} .active.center .ue-item {
      opacity: 1;
      transform: scale3d(1, 1, 1);
      transition: all 0.3s ease-in-out;
  }
{% endif %}

#{{uc_id}} .jet-wishlist-button__container{
  	margin-top:10px;
}

/* hide default arrows in input type number */
/* Chrome, Safari, Edge, Opera */
#{{uc_id}} input.uc_carousel-count-buttons__number::-webkit-outer-spin-button,
#{{uc_id}} input.uc_carousel-count-buttons__number::-webkit-inner-spin-button{
	-webkit-appearance: none;
  	margin: 0;
}

/* Firefox */
#{{uc_id}} input.uc_carousel-count-buttons__number[type=number]{
	-moz-appearance: textfield;
}
/* end hide default arrows in input type number */

#{{uc_id}} .uc_carousel-count-buttons{
	display: inline-flex;
}

#{{uc_id}} .uc_carousel-count-buttons button{
	display: flex;
    align-items:center;
    justify-content:center;
    flex-grow:0;
    flex-shrink:0;
    line-height:1em;
}

#{{uc_id}} .uc_carousel-count-buttons button:disabled{
	opacity:0.5;
}

#{{uc_id}} .uc_carousel-count-buttons button svg{
	height:1em;
    width:1em;
}

#{{uc_id}} input.uc_carousel-count-buttons__number{
  text-align:center;
  flex-grow:1;
}

{% if transition_easing == "false" %}
	#{{uc_id}} .owl-stage
        {
            transition-timing-function: linear!important;
        }
{% endif %}


{% if items_equal_height == "true" %}
#{{uc_id}} .owl-stage{
   display: flex;
}
#{{uc_id}} .uc_image_carousel_container_holder{
    display: flex;
    align-items: stretch;
    flex-direction: column;
}
#{{uc_id}} .uc_image_carousel_content{
    display: flex;
    flex-direction: column;
    flex: 1;
}
#{{uc_id}} .owl-item {
    align-items: stretch;
    display: flex;
}
{% endif %}

{% if limit_title_single_line == "true" %}
  #{{uc_id}} .uc_post_title a{
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    display: block;
  }
{% endif %}