#{{uc_id}}.ucform-has-conditions{
	display: none;
}
{% if rtl == "true" %}
#{{uc_id}} *{
  direction: rtl;
}
{% endif %}

{% if uc_inside_editor == "yes" %}
  #{{uc_id}}.ucform-has-conditions{
      display: block;
  }
{% endif %}

{% if show_title == "true" %}
  #{{uc_id}}.ue-checkbox-field{
    display:flex;
  }
{% endif %}

{% if show_description == "true" %}
#{{uc_id}} .ue-checkbox-desc-wrapper{	
  display:flex;
}
{% endif %}

#{{uc_id}} .ue-checkbox-field-input{
  opacity: 0;
  pointer-events: none;
  position: absolute;
}

#{{uc_id}} .ue-checkbox-field-item{
  display: flex;
}
#{{uc_id}} .ue-checkbox-field-item-label{
  cursor: pointer;
}

{% if display_format == "simple" %}

#{{uc_id}} .ue-checkbox-field-form{
  display: flex;
}
#{{uc_id}} .ue-checkbox-field-item-label {
  display: flex;
  align-items: center;
  position: relative;
  transition-duration: 300ms;
}

#{{uc_id}} .ue-checkbox-field-item-input {
  position: absolute;
  opacity: 0;
}

#{{uc_id}} .ue-checkbox-field-item-input + .ue-checkbox-field-item-label {
  position: relative;
  cursor: pointer;
  padding: 0;
}

#{{uc_id}} .ue-checkbox-field-item-input + .ue-checkbox-field-item-label:before {
  content: "";
  display: inline-block;
  vertical-align: text-top;
  transition-duration: 300ms;
  cursor: pointer;
}

#{{uc_id}} .ue-checkbox-field-item-input:checked + .ue-checkbox-field-item-label:after {
  content: "";
  position: absolute;
  transition-duration: 300ms;
  width: 2px;
  height: 2px;
  transform: rotate(45deg);
}
{% endif %}

{% if display_format == "image" %}

#{{uc_id}} .ue-checkbox-field-form{
  display:grid;
}
#{{uc_id}} .ue-checkbox-field-item-input{
  display:none;
}
#{{uc_id}} .ue-checkbox-field-item-label{
  display: flex;
  flex-direction:column;
  overflow:hidden;
}
#{{uc_id}} .ue-checkbox-field-item-image-title{
  display:block;
  width:100%;
}
#{{uc_id}} .ue-checkbox-field-item-label{
  width:100%;
}
#{{uc_id}} .ue-checkbox-field-item-label img{
  width:100%;
}
#{{uc_id}} .ue-checkbox-desc-wrapper{
  width:100%;
}
{% endif %}

{% if display_format == "buttons" %}
  
#{{uc_id}} .ue-checkbox-field-form{
  display:flex;
}
#{{uc_id}} .ue-checkbox-field-item-input{
  display:none;
}
{% endif %}