<?php
return array(
	'title'      => 'Axtra Project Setting',
	'id'         => 'axtra_meta_projects',
	'icon'       => 'el el-cogs',
	'position'   => 'normal',
	'priority'   => 'core',
	'post_types' => array( 'project' ),
	'sections'   => array(
		array(
			'id'     => 'axtra_projects_meta_setting',
			'fields' => array(
				array(
                    'id' => 'show_project_info',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Project Information', 'axtra'),
                    'desc' => esc_html__('Enable to Show Project Information', 'axtra'),
                ),
				array(
                    'id'    => 'project_detail_cat',
                    'type'  => 'text',
                    'title' => esc_html__('Category Info', 'axtra'),
                    'required' => array('show_project_info', '=', true),
                ),
				array(
                    'id'    => 'project_detail_client',
                    'type'  => 'text',
                    'title' => esc_html__('Client Info', 'axtra'),
                    'required' => array('show_project_info', '=', true),
                ),
				array(
                    'id'    => 'project_start_date',
                    'type'  => 'text',
                    'title' => esc_html__('Project Start Date', 'axtra'),
                    'required' => array('show_project_info', '=', true),
                ),
				array(
                    'id'    => 'project_end_date',
                    'type'  => 'text',
                    'title' => esc_html__('Project End Date', 'axtra'),
                    'required' => array('show_project_info', '=', true),
                ),
				array(
                    'id'       => 'project_image1',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Project Detail Parallax Image', 'axtra'),
                    'desc'     => esc_html__('Insert Project Detail Parallax Image URl', 'axtra'),
                ),
				array(
                    'id' => 'show_section_info',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Block Section', 'axtra'),
                    'desc' => esc_html__('Enable to Show Block Information', 'axtra'),
                ),
				array(
                    'id'    => 'heading',
                    'type'  => 'textarea',
                    'title' => esc_html__('Section Title', 'axtra'),
                    'required' => array('show_section_info', '=', true),
                ),
				array(
                    'id'    => 'feature_list',
                    'type'  => 'textarea',
                    'title' => esc_html__('Feature List', 'axtra'),
                    'required' => array('show_section_info', '=', true),
                ),
				array(
                    'id'       => 'image',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Feature Image', 'axtra'),
                    'desc'     => esc_html__('Insert Feature Image URl', 'axtra'),
                ),
				array(
                    'id' => 'show_block_section_info',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Block Section', 'axtra'),
                    'desc' => esc_html__('Enable to Show Block Information', 'axtra'),
                ),
				array(
                    'id'    => 'heading_two',
                    'type'  => 'textarea',
                    'title' => esc_html__('Section Title', 'axtra'),
                    'required' => array('show_block_section_info', '=', true),
                ),
				array(
                    'id'    => 'text_two',
                    'type'  => 'textarea',
                    'title' => esc_html__('Text', 'axtra'),
                    'required' => array('show_block_section_info', '=', true),
                ),
				array(
                    'id'    => 'feature_list_two',
                    'type'  => 'textarea',
                    'title' => esc_html__('Feature List', 'axtra'),
                    'required' => array('show_block_section_info', '=', true),
                ),
				array(
                    'id' => 'show_gallery',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Gallery', 'axtra'),
                    'desc' => esc_html__('Enable to Show Gallery', 'axtra'),
                ),
				array(
					'id'       => 'gallery_imgs',
					'type'     => 'gallery',
					'url'      => true,
					'title'    => esc_html__('Gallery Images Image', 'sproperty'),
					'desc'     => esc_html__('Insert Gallery Images Image URl', 'sproperty'),
                    'required' => array('show_gallery', '=', true),
				),
				array(
                    'id'       => 'image_two',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Feature Image', 'axtra'),
                    'desc'     => esc_html__('Insert Feature Image URl', 'axtra'),
                ),
				array(
                    'id' => 'show_gallery_section',
                    'type' => 'switch',
                    'title' => esc_html__('Show/Hide Gallery and Text', 'axtra'),
                    'desc' => esc_html__('Enable to Show Gallery', 'axtra'),
                ),
				array(
					'id'       => 'gallery_imgs_two',
					'type'     => 'gallery',
					'url'      => true,
					'title'    => esc_html__('Gallery Images Image', 'sproperty'),
					'desc'     => esc_html__('Insert Gallery Images Image URl', 'sproperty'),
                    'required' => array('show_gallery_section', '=', true),
				),
				array(
                    'id'    => 'text_three',
                    'type'  => 'textarea',
                    'title' => esc_html__('Text', 'axtra'),
                    'required' => array('show_gallery_section', '=', true),
                ),
				array(
					'id'    => 'dimension',
					'type'  => 'select',
					'title' => esc_html__( 'Choose the Extra width and Extra height', 'axtra' ),
					'options'  => array(
						'normal_width' => esc_html__( 'Normal Width Height', 'axtra' ),
						'medium_width_height' => esc_html__( 'Medium Width Height', 'axtra' ),
						'extra_height' => esc_html__( 'Extra Height', 'axtra' ),
						'extra_width' => esc_html__( 'Extra Width', 'axtra' ),
					),
					'default'  => 'normal_width',
				),
				
				array(
					'id'    => 'link_option',
					'type'  => 'select',
					'title' => esc_html__( 'Choose Link Type', 'axtra' ),
					'default' => 'permalink',
					'options'  => array(
						'permalink' => esc_html__( 'Permalink', 'axtra' ),
						'external' => esc_html__( 'External Link', 'axtra' ),
					),
				),
				array(
					'id'    => 'ext_url',
					'type'  => 'text',
					'title' => esc_html__( 'External Link', 'axtra' ),
					'required' => array( 
						'link_option', '=', 'external', '=', true,
					),
				),
				array(
					'id'    => 'target_url',
					'type'  => 'select',
					'title' => esc_html__( 'Choose Link Target', 'axtra' ),
					'default' => '_blank',
					'options'  => array(
						'blank' => esc_html__( 'Blank', 'axtra' ),
						'self' => esc_html__( 'Self', 'axtra' ),
					),
				),
				
			),
		),
	),
);