<?php

return array(
	'id'     => 'axtra_header_settings',
	'title'  => esc_html__( "Axtra Header Settings", "konia" ),
	'fields' => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'axtra' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'axtra' ),
				'e' => esc_html__( 'Elementor', 'axtra' ),
			),
			'default'=> '',
		),
		array(
			'id'       => 'header_new_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'axtra-plugin' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page' => -1,
				'orderby'  => 'title',
				'order'     => 'DESC'
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id' => 'yt_dark_layout',
			'type' => 'switch',
			'title' => esc_html__('ON/OFF Dark Scheme', 'axtra'),
			'desc' => esc_html__('Enable to Show Dark Scheme', 'axtra'),
		),
		array(
			'id'       => 'header_style_settings',
			'type'     => 'image_select',
			'title'    => esc_html__( 'Choose Header Styles', 'axtra' ),
			'options'  => array(
				'header_v1' => array(
					'alt' => 'Header Style 1',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v1.png',
				),
				'header_v2' => array(
					'alt' => 'Header Style 2',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v2.png',
				),
				'header_v3' => array(
					'alt' => 'Header Style 3',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v3.png',
				),
				'header_v4' => array(
					'alt' => 'Header Style 4 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v4.png',
				),
				'header_v5' => array(
					'alt' => 'Header Style 5 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v5.png',
				),
				'header_v6' => array(
					'alt' => 'Header Style 6 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v6.png',
				),
				'header_v7' => array(
					'alt' => 'Header Style 7 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v7.png',
				),
				'header_v8' => array(
					'alt' => 'Header Style 8 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v8.png',
				),
				'header_v9' => array(
					'alt' => 'Header Style 9 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v9.png',
				),
				'header_v10' => array(
					'alt' => 'Header Style 10 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v10.png',
				),
				'header_v11' => array(
					'alt' => 'Header Style 11 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v11.png',
				),
				'header_v12' => array(
					'alt' => 'Header Style 12 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v12.png',
				),
				'header_v13' => array(
					'alt' => 'Header Style 13 ',
					'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v13.png',
				),
			),
			'required' => array( array( 'header_source_type', 'equals', 'd' ) ),
		),
	),
);