<?php namespace AXTRAPLUGIN\Element;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Services_Detail_Section_V4 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_services_detail_section_v4';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Services Detail Section V4', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'services_detail_section_v4',
            [
                'label' => esc_html__( 'Services Detail Section V4', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/s_detail_4.png'
					],
				],
			]
		);
		
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Product making for friendly users', 'axtra' ),
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		
		//Our Slider		
		$repeater = new Repeater();
				
		$repeater->add_control(
			'block_title',
			[
				'label'       => __( 'Block Title', 'insuco' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'Accordion Title', 'insuco' ),
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Title', 'insuco' ),
			]
		);
		
		$repeater->add_control(
			'block_text',
			[
				'label'       => __( 'Block Text', 'insuco' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'Accordion Content', 'insuco' ),
				'show_label' => false,
			]
		);
		
		$this->add_control(
			'faqs',
			[
				'label'                 => __('Add Faqs Item', 'insuco'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
				'default' => [
					[
						'block_title' => esc_html__( 'Design should enrich our day', 'insuco' ),
						'block_text' => esc_html__( 'Our design services starts and ends with a best-in-class experience strategy that
                              builds brands. Through a process of iteration and prototyping design interfaces that
                              bring joy to people', 'insuco' ),
					],
					[
						'block_title' => esc_html__( 'Bring their individual experience and creative', 'insuco' ),
						'block_text' => esc_html__( 'Our design services starts and ends with a best-in-class experience strategy that
                              builds brands. Through a process of iteration and prototyping design interfaces that
                              bring joy to people', 'insuco' ),
					],
					[
						'block_title' => esc_html__( 'Design should enrich our day', 'insuco' ),
						'block_text' => esc_html__( 'Our design services starts and ends with a best-in-class experience strategy that
                              builds brands. Through a process of iteration and prototyping design interfaces that
                              bring joy to people', 'insuco' ),
					],
					[
						'block_title' => esc_html__( 'Developing core web applications', 'insuco' ),
						'block_text' => esc_html__( 'Our design services starts and ends with a best-in-class experience strategy that
                              builds brands. Through a process of iteration and prototyping design interfaces that
                              bring joy to people', 'insuco' ),
					],
				],
				'title_field' => '{{{ block_title }}}',
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .te-axtra-title',                 
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .te-axtra-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		//Title Style
		$this->start_controls_section(
			'acc_title_style',
			[
				'label' => esc_html__( 'Accordian Title', 'insuco' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
            'acc_title__margin',
            [
                'label'      => esc_html__( 'Margin', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .acc-axtra-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
        $this->add_responsive_control(
            'acc_title_padding',
            [
                'label'      => esc_html__( 'Padding', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .acc-axtra-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'acc_title_bgtype',
				'label' => __( 'Background', 'insuco' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .acc-axtra-title',				
			]
		);
		
		$this->add_control(
			'acc_title_color',
			[
				'label' => esc_html__( 'Text Color', 'insuco' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .acc-axtra-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'acc_title_typography',
				'label' => __('Typography', 'insuco'),
				'selector' => '{{WRAPPER}} .acc-axtra-title',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'acc_title_text_shadow',
				'selector' => '{{WRAPPER}} .acc-axtra-title',
			]
		);

		$this->end_controls_section();
		
		//Text Style
		
		$this->start_controls_section(
			'acc_text_style',
			[
				'label' => esc_html__( 'Accordian Content', 'insuco' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
            'acc_text__margin',
            [
                'label'      => esc_html__( 'Margin', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .accordion-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
        $this->add_responsive_control(
            'acc_text_padding',
            [
                'label'      => esc_html__( 'Padding', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
		$this->add_control(
			'acc_text_color',
			[
				'label' => esc_html__( 'Text Color', 'insuco' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .accordion-body' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'acc_text_typography',
				'label' => __('Typography', 'insuco'),
				'selector' => '{{WRAPPER}} .accordion-body',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'acc_text_text_shadow',
				'selector' => '{{WRAPPER}} .accordion-body',
			]
		);


		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		$title	= $settings[ 'title' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
		}else{
			$anim_title = '';
		}
    ?>
    
    <!-- FAQ area start -->
    <section class="faq__area">
      <div class="container g-0 line pb-140">
        <div class="line-3"></div>
        <div class="row">
        
          <?php if( $settings['feature_image']['id'] ){ ?>
          <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
            <div class="faq__img">
              <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" data-speed="auto">
            </div>
          </div>
          <?php };?>
          
          <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
            <div class="faq__content">
              <?php if( $title ){?>
              <h2 class="faq__title te-axtra-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $title, true );?></h2>
    		  <?php };?>
              <div class="faq__list">
                <div class="accordion" id="accordionExample">
                  
                  <?php $i= 1; foreach($settings['faqs'] as $key => $item):?>
                  <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne<?php echo esc_attr( $key );?>">
                      <button class="accordion-button acc-axtra-title <?php if( $key == 1 ) echo ''; else echo 'collapsed';?>" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseOne<?php echo esc_attr( $key );?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr( $key );?>">
                        <?php echo wp_kses($item['block_title'], true) ;?>
                      </button>
                    </h2>
                    <div id="collapseOne<?php echo esc_attr( $key );?>" class="accordion-collapse collapse <?php if( $key == 1 ) echo 'show';?>" aria-labelledby="headingOne"
                      data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p><?php echo wp_kses($item['block_text'], true) ;?></p>
                      </div>
                    </div>
                  </div>
                  <?php endforeach;?>
                  
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- FAQ area end -->
               
    <?php
    }
}
