<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Product_Banner extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_product_banner';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Product Banner', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'product-banner-script', YT_URL . 'assets/js/product-banner.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'product-banner-script' ];
	}
	
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'product_banner',
            [
                'label' => esc_html__( 'Product Banner', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/product/product_layout_one.png'
					],
				],
			]
		);
		$this->add_control(
			'circle_image',
			[
				'label' => __( 'Circle Border Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'show_hero_line',
			[
				'label'       => __( 'ON/OFF Slide Hero Line', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		//Product Banner Repeater
		$repeater = new Repeater();
		$repeater->add_control(
			'slide_bg_image',
			[
				'label' => __( 'Slide BG Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'price_title',
			[
				'label' => esc_html__('Price Description', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'block_price',
			[
				'label' => esc_html__('Price', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'block_text',
			[
				'label' => esc_html__('Slide Description', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'product_slide',
			[
				'label'                 => __('Add Slide Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
				'condition'             => [
					'layout_control'    => ['one']
				],
			]
		);
		$this->end_controls_section();
		
		/*******************Style Tab*******************/
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .woocomerce__hero-htitle',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__hero-htitle' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Price Style**/
		$this->start_controls_section(
			'price_info_style',
			[
				'label' => esc_html__('PRICE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_price_title_style',
			[
				'label'       => __( 'ON/OFF Price Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_title_typography',
                'label' => __('Price Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .woocomerce__hero-subtitle',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_price_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'price_title_color',
            [
                'label' => __('Price Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__hero-subtitle' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_price_title_style'    => 'yes',
				]
            ]
        );
		//Price 
		$this->add_control(
			'show_price_style',
			[
				'label'       => __( 'ON/OFF Price Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'label' => __('Price Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .woocomerce__hero-price',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_price_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'price_color',
            [
                'label' => __('Price Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__hero-price' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_price_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .woocomerce__hero-dis',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__hero-dis' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
   	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
	?>
	
    <!-- woocomerce Slider -->
    <div class="woocomerce__hero">
        <?php if($settings['circle_image']['id']){ ?><img class="woocomerce__hero-circle" src="<?php echo esc_url(wp_get_attachment_url($settings['circle_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"><?php } ?>
        
		<?php if($settings['show_hero_line']){ ?>
        <span class="woocomerce__hero-line line1"></span>
        <span class="woocomerce__hero-line line2"></span>
        <span class="woocomerce__hero-line line3"></span>
        <span class="woocomerce__hero-line line4"></span>
      	<?php } ?>
      	<div class="swiper woocomerce-active">
        	<div class="swiper-wrapper">
                <?php foreach($settings['product_slide'] as $key => $item): ?>
                <!-- Slides -->
                <div class="swiper-slide">
                    <div class="woocomerce__hero-item" <?php if($item['slide_bg_image']['id']){ ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($item['slide_bg_image']['id']));?>);"<?php } ?>>
                    	<span class="woocomerce__hero-rectangle"></span>
                        <div class="woocomerce__hero-content">
                            <h1 class="woocomerce__hero-htitle">
                            	<?php echo wp_kses($item['block_title'], true); ?>
                            </h1>
                        	<span class="woocomerce__hero-subtitle"><?php echo wp_kses($item['price_title'], true); ?></span>
                        	<strong class="woocomerce__hero-price"><?php echo wp_kses($item['block_price'], true); ?></strong>
                            <p class="woocomerce__hero-dis"><?php echo wp_kses($item['block_text'], true); ?></p>
                        </div>
                    </div>
                </div>
          		<?php endforeach; ?>
        	</div>
            <!-- If we need pagination -->
            <div class="swiper-pagination"></div>

            <!-- If we need navigation buttons -->
            <div class="woocomerce__hero-prev"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/woocomerce/hero-prev.png" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"></div>
            <div class="woocomerce__hero-next"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/woocomerce/hero-right.png" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"></div>
    	</div>
    </div>
    <!-- /woocomerce Slider -->
           
    <?php 
    }
}
