<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Portfolio_Masonry extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_portfolio_masonry';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Portfolio Masonry', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'portfolio_masonry',
            [
                'label' => esc_html__( 'Portfolio Masonry', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/portfolio-masonry-image.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'description',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
			]
		);
		$this->add_control(
			'know_more_title',
			[
				'label'       => __( 'Know More Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Know More Title Here', 'axtra' ),
			]
		);
		//Social Info
		
		$repeater = new Repeater();
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Social Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'social_link',
			[
				'label' => __( 'Social Link', 'axtra' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => ['url' => '','is_external' => true,'nofollow' => true,],
			]
		);
		$this->add_control(
			'social_info',
			[
				'label'                 => __('Add Social Icons', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'axtra'),
			  'label_block' => true,
			  'options' => get_project_categories(),
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title-8',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title-8' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .dis_port_4',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .dis_port_4' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Know more Style**/
		$this->start_controls_section(
			'know_more_style',
			[
				'label' => esc_html__('KNOW MORE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_know_more_style',
			[
				'label'       => __( 'ON/OFF Know More Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'know_more_typography',
                'label' => __('Know More Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .section_title_wrapper .title_right__inner__left span,
					 {{WRAPPER}} .section_title_wrapper .title_right__inner__right ul li a',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_ACCENT,
				],
				'condition'             => [
					'show_know_more_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'know_more_color',
            [
                'label' => __('Know More Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .section_title_wrapper .title_right__inner__left span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .section_title_wrapper .title_right__inner__right ul li a' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_ACCENT,
				],
				'condition'             => [
					'show_know_more_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Post Title Style**/
		$this->start_controls_section(
			'post_title_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_post_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .showcase4__content h2',
					'{{WRAPPER}} .showcase4__content h2 span',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_post_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'post_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .showcase4__content h2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .showcase4__content h2 span' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_post_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_post_subtitle_style',
			[
				'label'       => __( 'ON/OFF Post Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_subtitle_typography',
                'label' => __('Post Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .showcase4__content span',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_post_subtitle_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'post_subtitle_color',
            [
                'label' => __('Post Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .showcase4__content span' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_post_subtitle_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$animation__char_come = 'animation__char_come';
			$fade_bottom = 'fade_bottom';
			$fade_left = 'fade_left';
			$fade_bottom_2 = 'fade_bottom_2';
			$fade_bottom_3 = 'fade_bottom_3';
		}else{
			$animation__char_come = '';
			$fade_bottom = '';
			$fade_left = '';
			$fade_bottom_2 = '';
			$fade_bottom_3 = '';
		}
		
		$paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( axtra_set( $settings, 'query_category' ) ) $args['project_cat'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
	{ ?>
	
    <div class="section_title_wrapper">
        <?php if($settings['title'] || $settings['description']){ ?>
        <div class="title_left">
        	<?php if($settings['title']){ ?><h2 class="sec-title-8 <?php echo esc_attr( $animation__char_come );?>"><?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
        	<?php if($settings['description']){ ?><p class="dis_port_4 <?php echo esc_attr( $fade_bottom );?>"><?php echo wp_kses($settings['description'], true);?></p><?php } ?>
        </div>
        <?php } ?>
        <div class="title_right">
            <div class="title_right__inner">
                <?php if($settings['know_more_title']){ ?>
                <div class="title_right__inner__left <?php echo esc_attr( $fade_left );?>">
                	<span><?php echo wp_kses($settings['know_more_title'], true);?></span>
                </div>
                <?php } ?>
                
                <div class="title_right__inner__right">
                    <ul>
                        <?php 
							foreach($settings['social_info'] as $key => $item): 
							if ( ! empty( $item['social_link']['url'] ) ) {
								$this->add_link_attributes( 'social_link', $item['social_link'] );
							}
						?>
                        <li class="<?php echo esc_attr( $fade_bottom_2 );?>"><a <?php echo $this->get_render_attribute_string( 'social_link' );?> target="_blank"><?php echo wp_kses($item['block_title'], true); ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>                
            </div>
        </div>
    </div>
    
    <!-- show case -->
    <div class="showcase__area-4">
        <div class="row">
        	<?php 
				while ( $query->have_posts() ) : $query->the_post(); 
				$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
				$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
				$target_url = get_post_meta( get_the_id(), 'target_url', true );
				if( $target_url == 'blank' ){
					$target = '_blank';
				}elseif( $target_url == 'self' ){
					$target = '_self';
				}else{
					$target = '_blank';
				}
			?>
            <div class="<?php if(get_post_meta( get_the_id(), 'dimension', true) == 'extra_width') echo 'col-xxl-12 col-xl-12 col-lg-12 col-md-12'; else echo 'col-xxl-6 col-xl-6 col-lg-6 col-md-6'?>">
                <div class="showcase4 wc-tilt-2 <?php echo esc_attr( $fade_bottom_3 );?>">
                    <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>">
                        <div class="showcase4__thumb">
                        <?php 
							$dimention = get_post_meta( get_the_id(), 'dimension', true );
							if($dimention == 'extra_width'){
								$image_size = 'extra_1820x500';
							}
							else{
								$image_size = 'extra_850x500'; 
							}
							the_post_thumbnail($image_size);
						?>
                        </div>
                        <div class="showcase4__content">
                            <div class="showcase4__content__left">
                            	<h2><?php the_title(); ?></h2>
                            </div>
                            <div class="showcase4__content__right">
                                <span><?php echo implode( ', ', (array)$term_list );?> <br> </span>
                                <span>- <?php echo esc_attr(get_the_date('Y')); ?> </span>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        	<?php endwhile; ?>
        </div>
    </div>
    <!-- /show case -->
           
    <?php }
    wp_reset_postdata();
	}

}
