<?php namespace AXTRAPLUGIN\Element;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Portfolio_Detail extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_portfolio_detail';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Portfolio Detail', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'portfolio_detail',
            [
                'label' => esc_html__( 'General', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_line',
			[
				'label'       => __( 'ON/OFF Border Lines', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
            'section_1',
            [
                'label' => esc_html__( 'Section 01', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Web and mobile development', 'axtra' ),
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		//Our Slider		
		$repeater = new Repeater();		
		$repeater->add_control(
			'block_title',
			[
				'label'       => __( 'Block Title', 'insuco' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Block Title', 'insuco' ),
			]
		);
		$repeater->add_control(
            'link',
			[
				'label' => __( 'External Url', 'insuco' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'insuco' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$repeater->add_control(
			'block_text',
			[
				'label' => esc_html__('Content', 'insuco'),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your content', 'insuco' ),
			]
		);
		$this->add_control(
			'slides',
			[
				'label'                 => __('Add Slide Item', 'insuco'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
				'default' => [
					[
						'block_title' => esc_html__( 'Category ', 'axtra' ),
						'block_text' => esc_html__( 'Development', 'axtra' ),
					],
					
					[
						'block_title' => esc_html__( 'Client ', 'axtra' ),
						'block_text' => esc_html__( 'Webflow', 'axtra' ),
					],
					
					[
						'block_title' => esc_html__( 'Start Date ', 'axtra' ),
						'block_text' => esc_html__( '23 January 2021', 'axtra' ),
					],
					
					[
						'block_title' => esc_html__( 'Handover ', 'axtra' ),
						'block_text' => esc_html__( '05 March 2021', 'axtra' ),
					],
				],
				'title_field' => '{{{ block_title }}}',
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'section_2',
            [
                'label' => esc_html__( 'Section 02', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'title2',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Build, streamline and evolve together with solution', 'axtra' ),
				'placeholder' => __( 'Enter Your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Always ready to push the boundaries, especially when it comes to our own platform, Our analytical eye to create a site that was visually engaging and also optimised for maximum performance. It also perfectly reflects the journey to help it tell a story to increase its understanding and drive action. To create a site that was visually engaging for maximum performance.', 'axtra' ),
				'placeholder' => __( 'Enter Your Text', 'axtra' ),
			]
		);
		$this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( '+ API Development
                    + WordPress
                    + Cloud Migration
                    + Front End Development
                    + JavaScript
                    + Fluter Framework', 'axtra' ),
				'placeholder' => __( 'Enter Your Feature List', 'axtra' ),
			]
		);
		$this->add_control(
			'feature_image_two',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'section_3',
            [
                'label' => esc_html__( 'Section 03', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'title3',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Visual and typograpy hierarchy', 'axtra' ),
				'placeholder' => __( 'Enter Your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Visual hierarchy is the principle of arranging elements to show their order of importance. Designers structure visual characteristics—e.g., menu icons—so users can understand information easily. By laying out elements logically and strategically, designers influence users’ perceptions and guide them to desired actions. Users notice larger elements more easily can convert. ', 'axtra' ),
				'placeholder' => __( 'Enter Your Content', 'axtra' ),
			]
		);
		//Our Slider		
		$repeate = new Repeater();		
		$repeate->add_control(
			'feature_title',
			[
				'label'       => __( 'Title', 'insuco' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'insuco' ),
			]
		);
		$repeate->add_control(
			'feature_class',
			[
				'label'   => esc_html__( 'Choose Class', 'insuco' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default'  => esc_html__( 'Default', 'insuco' ),
					'regular' => esc_html__( 'Regular ', 'insuco'),
					'medium'  => esc_html__( 'Medium', 'insuco' ),
					'semibold'  => esc_html__( 'Semibold', 'insuco' ),
					'blod'  => esc_html__( 'Blod', 'insuco' ),
				),
			]
		);
		$this->add_control(
			'features',
			[
				'label'                 => __('Add Features', 'insuco'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeate->get_controls(),
				'default' => [
					[
						'feature_title' => esc_html__( 'This is text message ', 'axtra' ),
						'feature_class' => esc_html__( 'regular', 'axtra' ),
					],
					
					[
						'feature_title' => esc_html__( 'Medium typography ', 'axtra' ),
						'feature_class' => esc_html__( 'medium', 'axtra' ),
					],
					
					[
						'feature_title' => esc_html__( 'Just Amazing ', 'axtra' ),
						'feature_class' => esc_html__( 'semibold', 'axtra' ),
					],
					
					[
						'feature_title' => esc_html__( 'Awesome ', 'axtra' ),
						'feature_class' => esc_html__( 'blod', 'axtra' ),
					],
				],
				'title_field' => '{{{ feature_title }}}',
			]
		);
		$this->add_control(
			'shape_image',
			[
				'label' => __( 'Shape Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Images', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);
		$this->add_control(
			'feature_image_three',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'gallery_two',
			[
				'label' => esc_html__( 'Add Images', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);
		$this->add_control(
			'text2',
			[
				'label'       => __( 'Text', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'For those of us who are blessed with good sight. So we seldom consider it. That’s why going off to investigate the whys and hows involved is a little like trying to get behind the wind ', 'axtra' ),
				'placeholder' => __( 'Enter Your Text', 'axtra' ),
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .te-axtra-title',                 
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .te-axtra-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .te-axtra-text',               
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .te-axtra-text' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		$title	= $settings[ 'title' ];
		$title2	= $settings[ 'title2' ];
		$title3	= $settings[ 'title3' ];
		$text	= $settings[ 'text' ];
		$text2	= $settings[ 'text2' ];
		$content	= $settings[ 'content' ];
		
		if( $anim_on === 'yes' ){
			$animation_char_come = 'animation__char_come';
			$anim_title = 'title-anim';
		}else{
			$animation_char_come = '';
			$anim_title = '';
		}
		
    ?>
    
    <!-- Portfolio area start -->
    <section class="portfolio__detail">
      <div class="portfolio__detail-top">
        <div class="container g-0 line pt-110 pb-130">
          <?php if( $settings[ 'show_line' ] === 'yes' ){?>
          <span class="line-3"></span>
    	  <?php };?>
          
          <div class="row">
            <?php if( $title ){?>
            <div class="col-xxl-8 col-xl-8 col-lg-7 col-md-7">
              <div class="sec-title-wrapper">
                <h2 class="sec-title te-axtra-title <?php echo esc_attr( $animation_char_come );?>"><?php echo wp_kses( $title, true );?></h2>
              </div>
            </div>
    		<?php };?>
            
            <?php if( !empty( $settings['slides'] ) ):?>
            <div class="col-xxl-4 col-xl-4 col-lg-5 col-md-5">
              <div class="portfolio__detail-info">
                <ul>
                  <?php 
				  	foreach($settings['slides'] as $key => $item):
					if ( ! empty( $item['link']['url'] ) ) {
						$this->add_link_attributes( 'link', $item['link'] );
					}
				  ?>
                  <li><?php echo wp_kses( $item[ 'block_title' ], true );?> <a <?php echo $this->get_render_attribute_string( 'link' );?>><?php echo wp_kses( $item[ 'block_text' ], true );?></a></li>
                  <?php endforeach;?>
                </ul>
              </div>
            </div>
            <?php endif;?>
            
          </div>
        </div>
      </div>
      <?php if($settings['feature_image']['id']){ ?>
      <div class="portfolio__detail-thumb">
        <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" data-speed="auto">
      </div>
      <?php };?>
      
      <div class="portfolio__detail-content">
        <div class="container g-0 line pt-140">
          <?php if( $settings[ 'show_line' ] === 'yes' ){?>
          <span class="line-3"></span>
    	  <?php };?>
    
          <?php if( $settings[ 'show_line' ] === 'yes' ){?>
          <div class="block-content">
            <div class="row">
              <?php if( $title2 ){?>
              <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                <h2 class="portfolio__detail-title <?php echo esc_attr( $anim_title );?> te-axtra-title"><?php echo wp_kses( $title2, true );?></h2>
              </div>
              <?php };?>
    
              <?php if( $text || $settings['features_list'] ){?>
              <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7">
                <div class="portfolio__detail-text">
                  <p class="te-axtra-text"><?php echo wp_kses( $text, true );?></p>
    			  
                  <?php $features_list = $settings['features_list'];
						if(!empty($features_list)){
						$features_list = explode("\n", ($features_list)); 
					?>                    
					<ul>
						<?php foreach($features_list as $features): ?>
						<li class="te-axtra-text"><?php echo wp_kses($features, true); ?></li>
						<?php endforeach; ?>                                        
					</ul>
					<?php } ?>
                </div>
                
              </div>
              <?php } ?>
            </div>
          </div>
    
          <?php if($settings['feature_image_two']['id']){ ?>
          <div class="block-thumb">
            <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image_two']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" data-speed="0.5">
          </div>
          <?php };?>
          <?php };?>
    
          <div class="block-content  pt-140">
            <div class="row">
              <?php if( $title3 ){?>
              <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                <h2 class="portfolio__detail-title <?php echo esc_attr( $anim_title );?> te-axtra-title"><?php echo wp_kses( $title3, true );?></h2>
              </div>
              <?php };?>
    
              <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7">
                <div class="portfolio__detail-text">
                  <p class="te-axtra-text"><?php echo wp_kses( $content, true );?></p>
    
                  <div class="fonts">
                    <?php if($settings['shape_image']['id']){ ?>
                    <img src="<?php echo esc_url(wp_get_attachment_url($settings['shape_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
                    <?php } ?>
                    
                    <?php if( !empty( $settings['features'] ) ):?>
                    <ul>
                      <?php foreach($settings['features'] as $key => $item):?>
                      <li class="<?php echo esc_attr( $item[ 'feature_class' ] );?> te-axtra-text"><span><?php echo wp_kses( $item[ 'feature_class' ], true );?></span><?php echo wp_kses( $item[ 'feature_title' ], true );?></li>
                      <?php endforeach;?>
                    </ul>
                    <?php endif;?>
                    
                  </div>
                </div>
              </div>
            </div>
          </div>
    		
          <?php if( !empty( $settings['gallery'] ) ):?>
          <div class="block-gallery">
            <?php foreach($settings['gallery'] as $image):?>
            	<img src="<?php echo esc_attr( $image[ 'url' ] )?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
            <?php endforeach;?>
          </div>
          <?php endif;?>
    
          <?php if($settings['feature_image_three']['id']){ ?>
          <div class="block-thumb">
            <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image_three']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" data-speed="0.5">
          </div>
          <?php };?>
    
          <div class="block-img-text">
            <?php foreach($settings['gallery_two'] as $img):?>
            	<img src="<?php echo esc_attr( $img[ 'url' ] )?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
            <?php endforeach;?>
            
            <p class="te-axtra-text"><?php echo wp_kses( $text2, true );?></p>
          </div>
          
        </div>
      </div>
    
    </section>
    <!-- Portfolio area end -->
               
    <?php
    }
}
