<?php

namespace AXTRAPLUGIN\Element;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'axtra_our_projects';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects', 'axtra' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'axtra' ];
	}
	
	public function get_script_depends() {
		wp_register_script( 'axtra_portfolio_slider', YT_URL . 'assets/js/portfolio.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'axtra_portfolio_slider' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_projects',
			[
				'label' => esc_html__( 'Our Projects', 'axtra' ),
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_four.png'
					],
					'five' => [
						'label' => esc_html__('Layout 5', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_five.png'
					],
					'six' => [
						'label' => esc_html__('Layout 6', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_six.png'
					],
					'seven' => [
						'label' => esc_html__('Layout 7', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_seven.png'
					],
					'eight' => [
						'label' => esc_html__('Layout 8', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/project/project_layout_eight.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF Line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['five']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['five', 'six' ]
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight' ]
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two', 'four', 'five', 'six', 'seven', 'eight']
				],
			]
		);
		$this->add_control(
			'feature_title',
			[
				'label'       => __( 'Feature Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['seven', 'eight']
				],
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight' ]
				],
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight' ]
				],
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight' ]
				],
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'axtra'),
			  'label_block' => true,
			  'options' => get_project_categories(),
			  'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight' ]
				],
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'layout_control'      => ['three' ]
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'layout_control'      => ['three' ]
				],
			]
		);
		$this->end_controls_section();
	
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '
					{{WRAPPER}} .sec-sub-title,
					{{WRAPPER}} .sec-subtile-6',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-subtile-6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__area-2 .sec-title-3, 
					 {{WRAPPER}} .portfolio__title-3,
					 {{WRAPPER}} .portfolio__text,
					 {{WRAPPER}} .portfolio__area-7 .sec-title,
					 {{WRAPPER}} .sec-title-6,
					 {{WRAPPER}} .portfolio__area-6 .sec-title,
					 {{WRAPPER}} .sec-title-2',                
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__area-2 .sec-title-3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title-3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__area-7 .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title-6' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__area-6 .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title-2' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__area-2 .sec-title-wrapper .sec-text,
					 {{WRAPPER}} .portfolio__area-7 p,
					 {{WRAPPER}} .portfolio__sec-title p,
					 {{WRAPPER}} .portfolio__area-6 .sec-title-wrapper p,
					 {{WRAPPER}} .blog__text p',                
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__area-2 .sec-title-wrapper .sec-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__area-7 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__sec-title p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__area-6 .sec-title-wrapper p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .blog__text p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item:hover span',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' =>
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .btn-item',				
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_ACCENT,
				],
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_ACCENT,
				],
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Post Item Style**/
		$this->start_controls_section(
			'loop_post_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		/**Post Title Style**/
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__slide-2 .sec-title,
					 {{WRAPPER}} .portfolio__title,
					 {{WRAPPER}} .portfolio__slide-7 .title,
					 {{WRAPPER}} .portfolio__title-4,
					 {{WRAPPER}} .portfolio__title-6,
					 {{WRAPPER}} .portfolio__project .pp-slide-title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__slide-2 .sec-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__slide-7 .title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title-4' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title-6' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__project .pp-slide-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Post Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__slide-2 .sec-title a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__slide-7 .title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title-4:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__title-6:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__project .pp-slide-title:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		
		/**Post Content Style**/
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF Post Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_content_typography',
                'label' => __('Post Text Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__slide-2 p,
					 {{WRAPPER}} .portfolio__info p,
					 {{WRAPPER}} .portfolio__slide-7 .date,
					 {{WRAPPER}} .portfolio__subtitle-4,
					 {{WRAPPER}} .portfolio__date,
					 {{WRAPPER}} .portfolio__project .pp-slide-thumb p',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_text_color',
            [
                'label' => __('Post Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__slide-2 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__info p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__slide-7 .date' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__subtitle-4' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__date' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__project .pp-slide-thumb p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		
		/**Post Button Style**/
		$this->add_control(
			'show_loop_btn_style',
			[
				'label'       => __( 'ON/OFF Post Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_btn_typography',
                'label' => __('Post Button Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .portfolio__slide-2 .btn-common,
					 {{WRAPPER}} .portfolio__icon-4',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_ACCENT,
				],
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_color',
            [
                'label' => __('Post Button Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__slide-2 .btn-common' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__icon-4' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_ACCENT,
				],
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_hover_color',
            [
                'label' => __('Post Button Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__slide-2 .btn-common:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio__icon-4:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
			$anim_text = 'text-anim';
			$animation__char_come = 'animation__char_come';
			$animation__char_come_long = 'animation__char_come_long';
		}else{
			$anim_title = '';
			$anim_text = '';
			$animation__char_come = '';
			$animation__char_come_long = '';
		}
		
		if ( ! empty( $settings['btn_link']['url'] ) ) {
			$this->add_link_attributes( 'link', $settings['btn_link'] );
		}
		
		$paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( axtra_set( $settings, 'query_category' ) ) $args['project_cat'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
	{ ?>
	
    <?php if($settings['layout_control'] == 'eight'): ?>
	
	<!-- Portfolio area start -->
    <section class="portfolio-v5 portfolio__project">
        <div class="container line">
        	<div class="line-3"></div>
            <?php if($settings[ 'title' ] || $settings[ 'text' ]){ ?>
            <div class="row pt-130 pb-100">
                <?php if($settings[ 'title' ]){ ?>
                <div class="col-xxl-8 col-xl-7 col-lg-6 col-md-6">
                    <div class="sec-title-wrapper">
                    	<h2 class="sec-title-2 <?php echo esc_attr( $animation__char_come );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                    </div>
                </div>
                <?php } ?>
                
				<?php if($settings[ 'text' ]){ ?>
                <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-6">
                    <div class="blog__text">
                        <p><?php echo wp_kses( $settings[ 'text' ], true );?> </p>
                    </div>
                </div>
                <?php } ?>
            </div>
        	<?php } ?>
            
            <?php if($settings['feature_title']){ ?>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="pp-title-wrap">
                    	<h2 class="pp-title"><?php echo wp_kses( $settings['feature_title'], true );?></h2>
                    </div>
                </div>
            </div>
        	<?php } ?>
            
            <div class="row">
                <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-8">
                    <div class="pp-slider-wrapper">
                        <div class="swiper portfolio__project-slider">
                            <div class="swiper-wrapper">
                                <?php 
									while ( $query->have_posts() ) : $query->the_post(); 
									$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
									$target_url = get_post_meta( get_the_id(), 'target_url', true );
									if( $target_url == 'blank' ){
										$target = '_blank';
									}elseif( $target_url == 'self' ){
										$target = '_self';
									}else{
										$target = '_blank';
									}
								?>
                                <div class="swiper-slide pp-slide">
                                    <div class="pp-slide-img">
                                        <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>"><?php the_post_thumbnail('axtra_520x700'); ?></a>
                                    </div>
                                </div>
                            	<?php endwhile; ?>
                            </div>
                        </div>
                    
                        <div class="pp-next swipper-btn"><?php esc_html_e('prev', 'axtra'); ?></div>
                        <div class="pp-prev swipper-btn"><?php esc_html_e('Next', 'axtra'); ?></div>
                    </div>
                </div>
            
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4">
                    <div class="swiper portfolio__project-thumbs">
                        <div class="swiper-wrapper">
                            <?php 
								while ( $query->have_posts() ) : $query->the_post(); 
							?>
                            <div class="swiper-slide">
                                <div class="pp-slide-thumb">
                                    <h3 class="pp-slide-title"><?php the_title(); ?></h3>
                                    <p><?php echo wp_kses(get_the_date(), true); ?></p>
                                </div>
                            </div>
                        	<?php endwhile; ?>
                        </div>
                    </div>
                </div>
            
            </div>
        </div>
    </section>
    <!-- Portfolio area end -->
    
	<?php elseif($settings['layout_control'] == 'seven'): ?>
    
    <!-- Portfolio area start -->
    <section class="portfolio__area-3 portfolio-v4">
        <div class="container pt-100 pb-150">
            <?php if($settings[ 'title' ] || $settings[ 'text' ]){ ?>
            <div class="row pb-150">
                <?php if($settings[ 'title' ]){ ?>
                <div class="col-xxl-8 col-xl-7 col-lg-6 col-md-6">
                    <div class="sec-title-wrapper">
                        <h2 class="sec-title-2 <?php echo esc_attr( $animation__char_come );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                    </div>
                </div>
                <?php } ?>
                <?php if($settings[ 'text' ]){ ?>
                <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-6">
                    <div class="blog__text">
                        <p><?php echo wp_kses( $settings[ 'text' ], true );?> </p>
                    </div>
                </div>
                <?php } ?>
            </div>
        	<?php } ?>
            
			<?php if($settings[ 'feature_title' ]){ ?>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper">
                        <h2 class="sec-sub-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $settings[ 'feature_title' ], true );?></h2>
                    </div>
                </div>
            </div>
            <?php } ?>
        
            <div class="row">
                <div class="col-xxl-12">
                    <div class="swiper portfolio__slider-3">
                        <div class="swiper-wrapper">
                        	<?php 
								while ( $query->have_posts() ) : $query->the_post(); 
								$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
								$target_url = get_post_meta( get_the_id(), 'target_url', true );
								if( $target_url == 'blank' ){
									$target = '_blank';
								}elseif( $target_url == 'self' ){
									$target = '_self';
								}else{
									$target = '_blank';
								}
							?>
                            <div class="swiper-slide">
                                <div class="portfolio__slide-3">
                                    <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>">
                                        <h3 class="portfolio__title-3"><?php the_title();?></h3>
                                        <?php the_post_thumbnail('axtra_550x670'); ?>
                                    </a>
                                </div>
                            </div>
                        	<?php endwhile; ?>
                        </div>
                    
                        <div class="swiper-pagination"></div>
                        <div class="swiper-btn">
                            <div class="pp-prev"><i class="fa-solid fa-arrow-left"></i></div>
                            <div class="pp-next"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Portfolio area end -->
    
	<?php elseif($settings['layout_control'] == 'six'): ?>
	
	<!-- Portfolio area start -->
    <section class="portfolio__area-6">
        <div class="container line pt-100 pb-140">
        	<span class="line-3"></span>
            <div class="zi-9">
                <div class="row">
                    <div class="col-xxl-4 col-xl-5 col-lg-5 col-md-6">
                        <div class="sec-title-wrapper portfolio__title-wrap-6">
                            <?php if($settings[ 'subtitle' ] || $settings[ 'title' ] || $settings[ 'text' ]){ ?>
                            <div class="">
                                <?php if($settings['subtitle']){ ?><h2 class="sec-sub-title <?php echo esc_attr( $animation__char_come );?>"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                                <?php if($settings['title']){ ?><h3 class="sec-title <?php echo esc_attr( $animation__char_come_long );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                                <?php if($settings['text']){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                            </div>
                            <?php } ?>
                            <div class="portfolio__pagination-6">
                            	<span class="portfolio__current">01</span> / 0<span class="portfolio__total"></span>
                            </div>
                        </div>
                    </div>
                
                    <div class="col-xxl-8 col-xl-7 col-lg-7 col-md-6">
                        <div class="portfolio__wrapper-6">
                            <div class="portfolio__list-6">
								<?php 
									$count = 1;
									while ( $query->have_posts() ) : $query->the_post(); 
									$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
									$target_url = get_post_meta( get_the_id(), 'target_url', true );
									if( $target_url == 'blank' ){
										$target = '_blank';
									}elseif( $target_url == 'self' ){
										$target = '_self';
									}else{
										$target = '_blank';
									}
								?>
                                <div class="portfolio__item-6" data-portfitem="<?php echo esc_attr( $count );?>">
                                    <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>">
                                        <?php the_post_thumbnail('axtra_770x980', array( 'data-speed' => '0.4' )); ?>
                                        <div class="portfolio__content-6">
                                        	<h4 class="portfolio__title-6"><?php the_title(); ?></h4>
                                        	<h5 class="portfolio__date"><?php echo wp_kses(get_the_date(), true); ?></h5>
                                        </div>
                                    </a>
                                </div>
                            	<?php $count++; endwhile; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Portfolio area end -->
	
	<?php elseif($settings['layout_control'] == 'five'): ?>
    
    <!-- Portfolio area start -->
    <section class="portfolio__area-4">
        <div class="container-fluid line_4 pt-150">
            <div class="row">
                <?php if($settings[ 'subtitle' ] || $settings[ 'title' ] || $settings[ 'text' ]){ ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="portfolio__sec-title <?php echo esc_attr( $anim_text );?>">
                        <?php if($settings['subtitle']){ ?><h2 class="sec-subtile-6"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if($settings['title']){ ?><h3 class="sec-title-6 <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                        <?php if($settings['text']){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                    </div>
                </div>
                <?php } ?>
                
                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8">
                    <div class="portfolio__wrapper-4">
                        <div class="swiper portfolio__slider-4">
                            <div class="swiper-wrapper">
                                <?php 
									while ( $query->have_posts() ) : $query->the_post(); 
									$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
									$target_url = get_post_meta( get_the_id(), 'target_url', true );
									if( $target_url == 'blank' ){
										$target = '_blank';
									}elseif( $target_url == 'self' ){
										$target = '_self';
									}else{
										$target = '_blank';
									}
								?>
                                <div class="swiper-slide">
                                    <div class="portfolio__item-4">
                                        <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>">
                                            <div class="portfolio__item-inner">
                                                <div class="portfolio__title-wrapper">
                                                    <h4 class="portfolio__title-4"><?php the_title(); ?></h4>
                                                    <h5 class="portfolio__subtitle-4"><?php echo wp_kses(get_the_date(), true); ?></h5>
                                                </div>
                                                <div class="portfolio__icon-link">
                                                	<span class="portfolio__icon-4"><i class="fa-solid fa-arrow-right"></i></span>
                                                </div>
                                            </div>
                                        	
                                            <?php the_post_thumbnail('axtra_560x700'); ?>
                                        </a>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    
                    
                    </div>
                </div>
            </div>
        </div>
    	<?php if($settings[ 'show_line_pattern' ]){ ?>
        <div class="container line_4 portfolio6__line">
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        </div>
        <?php } ?> 
    </section>
    <!-- Portfolio area end -->
    
    <?php elseif($settings['layout_control'] == 'four'): ?>
	
    <!-- Portfolio area start -->
    <section class="portfolio__area-7">
        <?php if($settings[ 'title' ] || $settings[ 'text' ]){ ?>
        <div class="container pt-140 pb-100">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper <?php echo esc_attr( $anim_text );?>">
                        <?php if($settings[ 'title' ]){ ?><h2 class="sec-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'text' ]){ ?><p class="sec-text"><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                    </div>
                </div>
            </div>
        </div>
    	<?php } ?>
        
    	<div class="swiper portfolio__slider-7">
            
            <div class="swiper-wrapper">
                <?php 
					while ( $query->have_posts() ) : $query->the_post(); 
					$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
					$target_url = get_post_meta( get_the_id(), 'target_url', true );
					if( $target_url == 'blank' ){
						$target = '_blank';
					}elseif( $target_url == 'self' ){
						$target = '_self';
					}else{
						$target = '_blank';
					}
				?>
                <div class="swiper-slide">
                    <div class="portfolio__slide-7">
                        <div class="slide-img">
                        	<a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>"><?php the_post_thumbnail('axtra_700x576'); ?></a>
                        </div>
                        <div class="slide-content">
                            <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>">
                            	<h2 class="title"> <?php the_title(); ?> </h2>
                            </a>
                            <h4 class="date"><?php echo wp_kses(get_the_date(), true); ?></h4>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>        
    <!-- Portfolio area end -->
	
	<?php elseif($settings['layout_control'] == 'three'): ?>
	
    <!-- Portfolio area start -->
    <section class="portfolio__area pb-140">
        <div class="container">
            <div class="row top_row">
            
            	<?php if($settings[ 'title' ]){ ?><h2 class="portfolio__text"><?php echo wp_kses( $settings[ 'title' ], true );?></h2><?php } ?>
                <div class="portfolio__list-1">
                	<?php 
						while ( $query->have_posts() ) : $query->the_post(); 
						$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
						$target_url = get_post_meta( get_the_id(), 'target_url', true );
						if( $target_url == 'blank' ){
							$target = '_blank';
						}elseif( $target_url == 'self' ){
							$target = '_self';
						}else{
							$target = '_blank';
						}
					?>
                    <div class="portfolio__item">
                        <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>"><?php the_post_thumbnail('axtra_520x700', array('class' => 'mover')); ?></a>
                        <div class="portfolio__info">
                            <h3 class="portfolio__title"><?php the_title(); ?></h3>
                            <p><?php echo wp_kses(get_the_date(), true); ?></p>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
            
        	<?php if($settings['btn_link']['url']){ ?>
            <div class="row row_bottom">
                <div class="col-xxl-12">
                    <div class="portfolio__btn" id="btn_wrapper" data-speed="1" data-lag="0.2">
                        <a class="wc-btn-secondary btn-hover btn-item" <?php echo $this->get_render_attribute_string( 'link' );?>><span></span><?php echo wp_kses($settings['btn_title'], true); ?> <i class="fa-solid fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </section>
    <!-- Portfolio area end -->
	
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Portfolio area start -->
    <section class="portfolio__area-2">
        <?php if($settings[ 'title' ] || $settings[ 'text' ]){ ?>
        <div class="container g-0 line pt-100 pb-140">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper <?php echo esc_attr( $anim_text );?>">
                        <?php if($settings[ 'title' ]){ ?><h2 class="sec-title-3 <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'text' ]){ ?><p class="sec-text"><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                    </div>
                </div>
            </div>
        </div>
    	<?php } ?>
        
        <div class="swiper portfolio__slider-2">
            <div class="swiper-wrapper">
            	<?php 
					while ( $query->have_posts() ) : $query->the_post(); 
					$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
					$target_url = get_post_meta( get_the_id(), 'target_url', true );
					if( $target_url == 'blank' ){
						$target = '_blank';
					}elseif( $target_url == 'self' ){
						$target = '_self';
					}else{
						$target = '_blank';
					}
				?>
                <div class="swiper-slide">
                    <div class="portfolio__slide-2">
                        <div class="slide-img">
                            <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>"><?php the_post_thumbnail('axtra_945x1000'); ?></a>
                        </div>
                        <div class="slide-content">
                            <h2 class="sec-title"> <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>"><?php the_title(); ?></a></h2>
                            <p><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                            <div class="btn-common-wrap">
                                <a href="<?php if($ext_url) echo esc_url( $ext_url ); else echo esc_url( the_permalink( get_the_id() ) );?>" target="<?php echo esc_attr( $target );?>" class="btn-common"><?php esc_html_e('View details', 'axtra'); ?> <i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            	<?php endwhile; ?>
            </div>
        
            <div class="portfolio__slider-2-pagination--">
                <div class="swiper-pagination circle-pagination right"></div>
            </div>
        </div>
    </section>
    <!-- Portfolio area end -->
    
    <?php else: ?>
    
    <!-- Portfolio area start -->
    <section class="portfolio__area-3">
        <div class="container pt-100 pb-150">
            <?php if($settings[ 'title' ]){ ?>
            <div class="row">
                <div class="col-xxl-12">
                    <div class="sec-title-wrapper">
                    	<h2 class="sec-sub-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                    </div>
                </div>
            </div>
            <?php } ?>
			        
            <div class="row">
                <div class="col-xxl-12">
                    <div class="swiper portfolio__slider-3" data-swiper-options='{
                    "slidesPerView": 1, 
                    "loop": true,
                    "effect": "fade",
                    "pagination": {
                        "el": ".swiper-pagination",
                        "type": "fraction",
                    },
                    "navigation": {
                        "nextEl": ".pp-next",
                        "prevEl": ".pp-prev"
                    },
                    "autoplay": {
                    	"delay": 8000,
                        "disableOnInteraction": false
                    }
            	}'>
                        <div class="swiper-wrapper">
							<?php 
                                while ( $query->have_posts() ) : $query->the_post(); 
								$ext_url = get_post_meta( get_the_id(), 'ext_url', true );
								$link_option = get_post_meta( get_the_id(), 'link_option', true );
								
								if( $link_option == 'external' ){
									$mount_link = $ext_url;
								}else{
									$mount_link = get_permalink( get_the_id() );
								}
								$target_url = get_post_meta( get_the_id(), 'target_url', true );
								if( $target_url == 'blank' ){
									$target = '_blank';
								}elseif( $target_url == 'self' ){
									$target = '_self';
								}else{
									$target = '_blank';
								}
                            ?>
                            <div class="swiper-slide">
                                <div class="portfolio__slide-3">
                                    <a href="<?php echo esc_url( $mount_link );?>" target="<?php echo esc_attr( $target );?>">
                                        <h3 class="portfolio__title-3"><?php the_title();?></h3>
                                        <?php the_post_thumbnail('axtra_550x670'); ?>
                                    </a>
                                </div>
                            </div>
                        	<?php endwhile; ?>
                        </div>
                    
                    	<div class="swiper-pagination"></div>
                    
                        <div class="swiper-btn">
                            <div class="pp-prev"><i class="fa-solid fa-arrow-left"></i></div>
                            <div class="pp-next"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Portfolio area end -->
             
	<?php endif; }
    wp_reset_postdata();
	}

}