<?php
namespace Woolentor\Modules\Popup_Builder_Pro\Frontend;
use Woolentor\Modules\Popup_Builder\Frontend\Popup_Rules_Checker;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if( class_exists('Woolentor\Modules\Popup_Builder\Frontend\Popup_Rules_Checker') ){
    class Popup_Rules_Checker_Pro extends Popup_Rules_Checker{

        private static $_instance = null;
    
        /**
         * Get Instance
         */
        public static function get_instance(){
            if( is_null( self::$_instance ) ){
                self::$_instance = new self();
            }
            return self::$_instance;
        }
    
        /**
         * Check Archives Rules (except WooCommerce).
         * 
         * @param string $rule_sub_name
         * @param string $rule_sub_id
         * 
         * @return bool
         */
        public function check_archives_rule( $rule_sub_name, $rule_sub_id ){
            $return_value = false;
            $rule_sub_ids = explode(',', $rule_sub_id);
    
            if( !is_archive() ){
                return $return_value;
            }
    
            // Exclude WooCommerce archives since they are available in separated rule.
            if( function_exists('is_product_taxonomy') && is_product_taxonomy() ){
                return $return_value;
            }
    
            $current_archive_taxonomy   = get_queried_object()->taxonomy;
            $current_archive_post_type  = get_taxonomy($current_archive_taxonomy)->object_type[0];
            $current_term_id            = get_queried_object()->term_id;
    
            // All Archives.
            if( empty($rule_sub_name) ){
                $return_value = true;
            }
    
            // All Archives of a specific post type.
            $selected_post_type = substr($rule_sub_name, 0, -8);
    
            // Check if the post type is valid.
            if(  post_type_exists($selected_post_type) ){
                // If the current archive is of the $selected_post_type.
                if( $selected_post_type == $current_archive_post_type ){
                    $return_value = true;
                }
            } else {
    
                // Specific taxonomy, all term archives.
                if( $rule_sub_name && empty($rule_sub_id) ){
    
                    // if $current_archive_taxonomy is same as $rule_sub_name.
                    if( $current_archive_taxonomy == $rule_sub_name ){
                        $return_value = true;
                    }
    
                }
    
                // Specific taxonomy, specific term archives.
                if( $rule_sub_name && $rule_sub_id ){
    
                    // if $current_term_id is in $rule_sub_ids.
                    if( in_array($current_term_id, $rule_sub_ids) ){
                        $return_value = true;
                    }
    
                }
    
            }
    
            return $return_value;
        }
    
        /**
         * Check WooCommerce Rules.
         * 
         * @return bool
         */
        public function check_woocommerce_rule( $rule_sub_name, $rule_sub_id ){
            $return_value = false;
            $rule_sub_ids = explode(',', $rule_sub_id);
    
            // Make sure woocommerce is active.
            if( !function_exists('is_woocommerce') ){
                return $return_value;
            }
    
            // Entire Shop.
            if( empty($rule_sub_name) ){
                if( is_woocommerce() || is_cart() || is_checkout() || is_account_page() ){
                    $return_value = true;
                }
            }
    
            // All Product taxonomy terms Archives (Tags,Categories).
            if( $rule_sub_name == 'product_archive' ){
                if( is_shop() || is_product_taxonomy() ){
                    $return_value = true;
                }
            }
    
            // All terms archive of product_cat taxonomy.
            if( $rule_sub_name == 'product_cat' && empty($rule_sub_id) ){
                if( is_product_category() ){
                    $return_value = true;
                }
            }
    
            // All terms archive of product_tag taxonomy.
            if( $rule_sub_name == 'product_tag' && empty($rule_sub_id) ){
                if( is_product_tag() ){
                    $return_value = true;
                }
            }
    
            // Specific terms archive of product_cat taxonomy.
            if( $rule_sub_name == 'product_cat' && !empty($rule_sub_id) ){
                // if is_product_category() and $current_term_id is in $rule_sub_ids.
                if( is_product_category() && in_array(get_queried_object()->term_id, $rule_sub_ids) ){
                    $return_value = true;
                }
            }
    
            // Specific terms archive of product_tag taxonomy.
            if( $rule_sub_name == 'product_tag' && !empty($rule_sub_id) ){
                // if is_product_tag() and $current_term_id is in $rule_sub_ids.
                if( is_product_tag() && in_array(get_queried_object()->term_id, $rule_sub_ids) ){
                    $return_value = true;
                }
            }
    
            // All Products.
            if( $rule_sub_name == 'product' && empty($rule_sub_id) ){
                if( is_product() ){
                    $return_value = true;
                }
            }
    
            // Specific Products.
            if( $rule_sub_name == 'product' && !empty($rule_sub_id) ){
                // if is_product() and $current_product_id is in $rule_sub_ids.
                if( is_product() && in_array( get_queried_object_id(), $rule_sub_ids) ){
                    $return_value = true;
                }
            }
    
            // Specific Products in a specific category.
            if( $rule_sub_name == 'in_product_cat' ){
                if( is_product() && $this->check_post_is_in_any_of_the_categories( 'product_cat', $rule_sub_id, get_queried_object_id() ) ){
                    $return_value = true;
                }
            }
    
            // Specific Products in a specific tag.
            if( $rule_sub_name == 'product_tag' && !empty($rule_sub_id) ){
                if( is_product() && $this->check_post_is_in_any_of_the_categories( 'product_tag', $rule_sub_id, get_queried_object_id() ) ){
                    $return_value = true;
                }
            }
    
            return $return_value;
        }
    }
}
