<?php
return array(
	'title'      => 'Axtra Service Setting',
	'id'         => 'axtra_meta_service',
	'icon'       => 'el el-cogs',
	'position'   => 'normal',
	'priority'   => 'core',
	'post_types' => array( 'service' ),
	'sections'   => array(
		array(
			'id'     => 'axtra_service_meta_setting',
			'fields' => array(
				array(
					'id'    => 'short_description',
					'type'  => 'textarea',
					'title' => esc_html__( 'Short Description', 'axtra' ),
					'default' => esc_html__( 'Planning and sketching Modern and unique design practically point of view, it risks not ... ', 'axtra' ),
				),
				array(
					'id'    => 'features_list',
					'type'  => 'textarea',
					'title' => esc_html__( 'Feature List', 'axtra' ),
				),
				array(
					'id'    => 'detail_description',
					'type'  => 'textarea',
					'title' => esc_html__( 'Detail Description', 'axtra' ),
				),
				array(
					'id'    => 'detail_features_list',
					'type'  => 'textarea',
					'title' => esc_html__( 'Detail Page Feature List', 'axtra' ),
				),
				array(
                    'id'       => 'service_image1',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Service Detail Image V1', 'axtra'),
                    'desc'     => esc_html__('Insert Service Detail Page Image URl', 'axtra'),
                ),
				array(
                    'id'       => 'service_image2',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => esc_html__('Service Detail Image V2', 'axtra'),
                    'desc'     => esc_html__('Insert Service Detail Page Image URl', 'axtra'),
                ),
				array(
					'id'    => 'link_option',
					'type'  => 'select',
					'title' => esc_html__( 'Choose Link Type', 'axtra' ),
					'default' => 'permalink',
					'options'  => array(
						'permalink' => esc_html__( 'Permalink', 'axtra' ),
						'external' => esc_html__( 'External Link', 'axtra' ),
					),
				),
				array(
					'id'    => 'ext_url',
					'type'  => 'text',
					'title' => esc_html__( 'External Link', 'axtra' ),
					'required' => array( 
						'link_option', '=', 'external',
						'external', '=', true, 
					),
				),
				array(
					'id'    => 'service_target',
					'type'  => 'select',
					'title' => esc_html__( 'Choose Link Target', 'axtra' ),
					'default' => '_blank',
					'options'  => array(
						'blank' => esc_html__( 'Blank', 'axtra' ),
						'self' => esc_html__( 'Self', 'axtra' ),
					),
				),
			),
		),
	),
);