<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Why_Choose_Us extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_why_choose_us';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Why Choose Us', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'choose-us-script', YT_URL . 'assets/js/choose-us.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'choose-us-script' ];
	}

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'why_choose_us',
            [
                'label' => esc_html__( 'General', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'bg_group_one',
				'label' => __( 'Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .choose-wrapper',				
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'main_title',
			[
				'label'       => __( 'Main Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title/Heading', 'axtra' ),
			]
		);
		$this->end_controls_section();
		
		//Why Choose Us
		$this->start_controls_section(
            'choose_us',
            [
                'label' => esc_html__( 'Choose Us Settings', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'bg_group_two',
				'label' => __( 'Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .research__area',				
			]
		);
		$this->add_control(
			'choose_subtitle_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'choose_subtitle_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .research__area .sec-sub-title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'choose_subtitle_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'choose_subtitle_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__area .sec-sub-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'choose_subtitle_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
			]
		);
		$this->add_control(
			'wc_choose_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'choose_title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .research__area .sec-title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'wc_choose_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'choose_title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__area .sec-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'wc_choose_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'wc_choose_content_style',
			[
				'label'       => __( 'ON/OFF Text Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'choose_text_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .research__area .sec-title-wrapper p',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'wc_choose_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'choose_content_color',
            [
                'label' => __('Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__area .sec-title-wrapper p' => 'color: {{VALUE}}'
                ],
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
                'separator' => 'before',
				'condition'             => [
					'wc_choose_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
			]
		);
		$this->add_control(
			'wc_social_media_style',
			[
				'label'       => __( 'ON/OFF Social Media Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'wc_social_media_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .research__tools li a',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'wc_social_media_color',
            [
                'label' => __('Social Media Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__tools li a' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'wc_social_media_hover_color',
            [
                'label' => __('Social Media Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__tools li a:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'wc_social_media_background',
			[
				'label'                 => __( 'Social Media Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'wc_social_media_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .research__tools li a',				
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'wc_social_media_hover_background',
			[
				'label'                 => __( 'Social Media Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'wc_social_media_hover_bg_bgtype',
				'label' => __( 'Social Media Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .research__tools li a:hover',				
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'wc_social_media_show_border_radius',
			[
				'label'       => __( 'ON/OFF Social Media Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'wc_social_media_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .research__tools li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'wc_social_media_show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'wc_social_media_show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'wc_social_media_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'wc_social_media_show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'wc_social_media_border_hover_color',
            [
                'label' => __('Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__tools li a:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'wc_social_media_show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'wc_social_media_show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'wc_social_media_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .research__tools li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'wc_social_media_show_btn_padding'    => 'yes',
				]
            ]
        );
		
		$this->end_controls_section();
		
		//Social Info Repeater
		$this->cf_repeater_social_control();
		
		
		//Our Skills Repeater
		$this->cf_repeater_skill_control();
		
		//Funfacts
		$this->start_controls_section(
            'funfact_section',
            [
                'label' => esc_html__( 'Our Funfacts', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'bg_group_three',
				'label' => __( 'Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .counter__area-3',				
			]
		);
		$this->add_control(
			'funfact_title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->end_controls_section();
		
		//Funfacts Info Repeater
		$this->cf_repeater_fact_control();
		
		//Call To Action
		$this->start_controls_section(
            'cta_section',
            [
                'label' => esc_html__( 'Call To Action', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'show_cta_section',
			[
				'label'       => __( 'ON/OFF CTA Section', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'bg_group_four',
				'label' => __( 'Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .cta__area-3',	
				'condition' => [
					'show_cta_section'      => 'yes'
				],			
			]
		);
		$this->add_control(
			'cta_subtitle',
			[
				'label'       => __( 'CTA Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your CTA Sub Title Here', 'axtra' ),
				'condition' => [
					'show_cta_section'      => 'yes'
				],
			]
		);
		$this->add_control(
			'cta_title',
			[
				'label'       => __( 'CTA Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your CTA Title Here', 'axtra' ),
				'condition' => [
					'show_cta_section'      => 'yes'
				],
			]
		);
		$this->add_control(
			'cta_btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'show_cta_section'      => 'yes'
				],
			]
		);
		$this->add_control(
            'cta_btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'show_cta_section'      => 'yes',
				],
			]
		);
		$this->end_controls_section();
   		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '
					{{WRAPPER}} .sec-sub-title,
					{{WRAPPER}} .cta__sub-title-2,
				',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta__sub-title-2' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '
						{{WRAPPER}} .choose-title,
						{{WRAPPER}} .cta__title-2,
					',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .choose-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta__title-2' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-text p',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-text p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'axtra' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn-item:hover span',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'axtra'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' =>
					'{{WRAPPER}} .btn-item',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'axtra' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .btn-item',				
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_ACCENT,
				],
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_ACCENT,
				],
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn-item:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Loop Style**/
		$this->start_controls_section(
			'counter_style',
			[
				'label' => esc_html__('COUNTER STYLE SETTING', 'insuco'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'counter_title_typography',
                'label' => __('Counter Title Typography', 'insuco'),
                'selector' => 
                    '{{WRAPPER}} .research__title',                 
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
			]
        );
		$this->add_control(
            'counter_title_color',
            [
                'label' => __('Counter Title Color', 'insuco'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
			]
        );
		$this->add_control(
            'funfact_borders_color',
            [
                'label' => __('Counter Border Color', 'insuco'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__number span' => 'border-color: {{VALUE}}'
                ],
                'separator' => 'before',
			]
        );
		//Content Style
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'counter_value_typography',
                'label' => __('Counter Value Typography', 'insuco'),
                'selector' => 
                    '{{WRAPPER}} .research__number span,
					 {{WRAPPER}} .counter__area-3 .counter__number',                 
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
			]
        );
		$this->add_control(
            'counter_value_color',
            [
                'label' => __('Counter Value Color', 'insuco'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__number span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter__area-3 .counter__number' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
			]
        );
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'counter_text_typography',
                'label' => __('Counter Text Typography', 'insuco'),
                'selector' => 
                    '{{WRAPPER}} .research__item p,
					 {{WRAPPER}} .counter__item-3 p',                 
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
        );
		$this->add_control(
            'counter_text_color',
            [
                'label' => __('Counter Text Color', 'insuco'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .research__item p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter__item-3 p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
			]
        );
		$this->end_controls_section();
		
	}
	
	/**
	 *	Repeater TAB
	 **/
	protected function cf_repeater_social_control()
	{

		$this->start_controls_section(
			'social_group',
			[
				'label'                 => __('Add Social Group', 'classyea'),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'social_btn_title',
			[
				'label' => esc_html__('Social Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'social_btn_link',
			[
				'label' => __( 'Social Link', 'axtra' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => ['url' => '','is_external' => true,'nofollow' => true,],
			]
		);
		$this->add_control(
			'social_info',
			[
				'label'                 => __('Add Social Icons', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
	
	$this->end_controls_section();
	}
	
	/**
	 *	Repeater TAB
	 **/
	protected function cf_repeater_skill_control()
	{

		$this->start_controls_section(
			'skills_group',
			[
				'label'                 => __('Add Skills Group', 'classyea'),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
		$repeater_skill = new Repeater();
		$repeater_skill->add_control(
			'counter_value',
			[
				'label' => esc_html__('Counter Value', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater_skill->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater_skill->add_control(
			'block_text',
			[
				'label' => esc_html__('Text', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'our_skills',
			[
				'label'                 => __('Add Skills', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater_skill->get_controls(),
			]
		);
	
	$this->end_controls_section();
	}
	
	/**
	 *	Repeater TAB
	 **/
	protected function cf_repeater_fact_control()
	{

		$this->start_controls_section(
			'funfact_group',
			[
				'label'                 => __('Add Funfacts Group', 'classyea'),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
		$repeater_fact = new Repeater();
		$repeater_fact->add_control(
			'counter_value1',
			[
				'label' => esc_html__('Counter Value', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater_fact->add_control(
			'block_title1',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater_fact->add_control(
			'block_text',
			[
				'label' => esc_html__('Text', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'funfacts',
			[
				'label'                 => __('Add Fun Facts', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater_fact->get_controls(),
			]
		);
	
	$this->end_controls_section();
	}
	
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
		}else{
			$anim_title = '';
		}
		if ( ! empty( $settings['cta_btn_link']['url'] ) ) {
			$this->add_link_attributes( 'link', $settings['cta_btn_link'] );
		}
		
	?>
	
    <!-- Workflow area start -->
    <section class="workflow__area-3">
        <div class="workflow__wrapper-3">
            <?php if($settings['main_title']){ ?>
            <div class="choose-wrapper wf_panel">
                <div class="container">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="choose-title-wrapper">
                            	<h2 class="choose-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses($settings['main_title'], true);?></h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        	<?php } ?>
            
            <div class="research__area wf_panel pt-150">
                <div class="container inner_content">
                    <div class="row">
                        <div class="col-xxl-6 col-xl-6 col-lg-6">
                            <?php if($settings['subtitle'] || $settings['title'] || $settings['text']) { ?>
                            <div class="sec-title-wrapper">
                                <?php if($settings['subtitle']) { ?><h2 class="sec-sub-title"><?php echo wp_kses($settings['subtitle'], true);?></h2><?php } ?>
                                <?php if($settings['title']) { ?><h3 class="sec-title"><?php echo wp_kses($settings['title'], true);?></h3><?php } ?>
                                <?php if($settings['text']) { ?><p><?php echo wp_kses($settings['text'], true);?></p><?php } ?>
                            </div>
                            <?php } ?>
                            
                            <ul class="research__tools">
                            	<?php 
									foreach($settings['social_info'] as $key => $item): 
									$ext_url = $item['social_btn_link'];
									$mount_link = $ext_url['url'];
									$target = $ext_url['is_external'] ? ' target="_blank"' : '';
									$nofollow = $ext_url['nofollow'] ? ' rel="nofollow"' : '';
								?>
                                <li><a href="<?php echo esc_url( $mount_link );?>" <?php echo esc_attr( $target );?> <?php echo esc_attr( $nofollow );?>><?php echo wp_kses($item['social_btn_title'], true); ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <div class="col-xxl-6 col-xl-6 col-lg-6">
                            <div class="research__list">
                            	<?php foreach($settings['our_skills'] as $key => $item): ?>
                                <div class="research__item">
                                    <div class="research__number">
                                    	<span><?php echo wp_kses($item['counter_value'], true); ?></span>
                                    </div>
                                    <div class="research__info">
                                        <h4 class="research__title"><?php echo wp_kses($item['block_title'], true); ?></h4>
                                        <p><?php echo wp_kses($item['block_text'], true); ?></p>
                                    </div>
                                </div>
                            	<?php endforeach; ?>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        
            <div class="counter__area-3 wf_panel">
                <div class="container">
                    <?php if($settings['funfact_title']){ ?>
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="sec-title-wrapper">
                            	<h2 class="sec-sub-title"><?php echo wp_kses($settings['funfact_title'], true);?></h2>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                            <div class="counter__wrapper-3">
                            	<?php foreach($settings['funfacts'] as $key => $item): ?>
                                <div class="counter__item-3">
                            	    <h2 class="counter__number"><?php echo wp_kses($item['counter_value1'], true); ?></h2>
                                	<p><?php echo wp_kses($item['block_title1'], true); ?></p>
                                </div>
                            	<?php endforeach; ?>
                            </div>
                        </div>
                        <?php if($settings['feature_image']['id']){ ?>
                        <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7">
                            <div class="counter__img-3">
                            	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        	
			<?php if($settings['show_cta_section']){ ?>
        	<!-- CTA area start -->
            <div class="cta__area-3 wf_panel">
                <div class="container pt-150 pb-150">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="cta__content-3">
                                <p class="cta__sub-title-2"><?php echo wp_kses($settings['cta_subtitle'], true); ?></p>
                                <h2 class="cta__title-2"><?php echo wp_kses($settings['cta_title'], true); ?></h2>
                                <?php if($settings['cta_btn_link']['url']){ ?>
                                <div id="btn_wrapper">
                                    <a <?php echo $this->get_render_attribute_string( 'link' );?> class="wc-btn-black btn-hover btn-item"><span></span><?php echo wp_kses($settings['cta_btn_title'], true); ?> <i class="fa-solid fa-arrow-right"></i></a>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        	<!-- CTA area end -->
        	<?php } ?>
        </div>
    </section>
    <!-- Workflow area end -->
           
    <?php
    }
}
