<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Video_Section extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_video_section';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Video Section', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'video_section',
            [
                'label' => esc_html__( 'Video Section', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/video-image.png'
					],
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		$this->add_control(
            'ext_link',
			[
				'label' => __( 'External Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'video_option',
			[
				'label' => __( 'Select Video Type', 'axtra' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'src_url',
				'options' => array(
					'src_url'       => esc_html__( 'Source URL', 'axtra' ),
					'src_media'      => esc_html__( 'Source Media', 'axtra' ),
				),
			]
		);
		$this->add_control(
            'video_source_link',
			[
				'label' => __( 'Video Source Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'video_option'      => 'src_url'
				],
			]
		);
		$this->add_control(
			'video_source_image',
			[
				'label' => __( 'Video Source Media', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'media_types' => ['video'],
				'condition' => [
					'video_option'      => 'src_media'
				],
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .award__text-8 .title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .award__text-8 .title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		if ( ! empty( $settings['ext_link']['url'] ) ) {
			$this->add_link_attributes( 'link', $settings['ext_link'] );
		}
		
		$video_option = $settings[ 'video_option' ];
		if( $video_option == 'src_url' ){
			$video = $settings[ 'video_source_link' ][ 'url' ];
		}elseif( $video_option == 'src_media' ){
			$video = $settings[ 'video_source_image' ]['url'];
		}else{
			$video = esc_html__( 'There is no Video', 'axtra' );
		}
		
	?>
	
    <section class="award__area-8">
        <div class="award__video-8">
            <?php if($settings['ext_link']['url']){ ?>
            <div class="award__text-8">
                <a <?php echo $this->get_render_attribute_string( 'link' );?>>
                    <h2 class="title"><?php echo wp_kses($settings['title'], true);?> <span><i class="fa-solid fa-arrow-right"></i></span></h2>
                </a>
            </div>
        	<?php } ?>
        	<video loop muted autoplay playsinline=""><source src="<?php echo esc_url( $video );?>" type="video/mp4"></video>
        </div>
    </section>
           
    <?php 
	}

}
