<?php namespace AXTRAPLUGIN\Element;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Shop_Sidebar extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_shop_sidebar';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Shop Sidebar', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	/**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'shop_sidebar',
            [
                'label' => esc_html__( 'Shop Sidebar', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/product/shop_sidebar.png'
					],
				],
			]
		);
		$this->add_control(
			'sidebar_slug',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => axtra_get_sidebars(),
			]
		);
        $this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'axtra'),
			  'label_block' => true,
			  'options' => get_product_categories(),
			]
		);
		
        $this->end_controls_section();
	
		
		/** Style Tab **/
			$this->register_style_background_controls();
		}
		
		/************************************************************************
									Tab Style Start
		*************************************************************************/
		
		protected function register_style_background_controls()
		{
			
			//General Style
			$this->start_controls_section(
				'general_style',
				[
					'label' => esc_html__( 'General Setting', 'axtra' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);		
			$this->add_responsive_control(
				'general_margin',
				[
					'label'      => esc_html__( 'Margin', 'pyloncore' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em'],
					'selectors'  => [
						'{{WRAPPER}} .woocomerce__feature' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);		
			$this->add_responsive_control(
				'general_padding',
				[
					'label'      => esc_html__( 'Padding', 'pyloncore' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em'],
					'selectors'  => [
						'{{WRAPPER}} .woocomerce__feature' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);		
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'general_bgtype',
					'label' => __( 'Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .woocomerce__feature',				
				]
			);
			$this->end_controls_section();
			
			/**Loop Item Style**/
			$this->start_controls_section(
				'loop_item_style',
				[
					'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_loop_category_style',
				[
					'label'       => __( 'ON/OFF loop category Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'category_bgtype',
					'label' => __( 'Category Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-categorytitle',				
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'category_hover_bgtype',
					'label' => __( 'Category Hover Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-categorytitle:hover',				
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'loop_category_title_typography',
					'label' => __('Category Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-categorytitle',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'category_title_color',
				[
					'label' => __('Category Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-categorytitle' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'category_title_hover_color',
				[
					'label' => __('Category Title Hover Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-categorytitle:hover' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			//Loop Title
			$this->add_control(
				'show_loop_title_style',
				[
					'label'       => __( 'ON/OFF Title Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'loop_title_typography',
					'label' => __('Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-producttitle',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_loop_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'loop_title_color',
				[
					'label' => __('Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-producttitle' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'loop_title_hover_color',
				[
					'label' => __('Title Hover Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-producttitle:hover' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_title_style'    => 'yes',
					]
				]
			);
			
			//Price Style 
			$this->add_control(
				'show_loop_item_price_style',
				[
					'label'       => __( 'ON/OFF Price Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'loop_price_typography',
					'label' => __('Price Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .price .woocommerce-Price-amount bdi',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_loop_item_price_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'loop_price_color',
				[
					'label' => __('Price Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .price .woocommerce-Price-amount bdi' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_item_price_style'    => 'yes',
					]
				]
			);			
			$this->end_controls_section();
			
			/**Button Style**/
			$this->start_controls_section(
				'cart_button_style',
				[
					'label' => esc_html__('CART BUTTON STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs( 'axtra_tabs_btn' );
			
				$this->start_controls_tab(
					'axtra_tab_btn_normal',
					[
						'label' => __( 'Normal', 'axtra' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'cart_btn_bgtype',
							'label' => __( 'Cart Button Background', 'axtra' ),
							'types' => [ 'classic', 'gradient' ],
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover',				
						]
					);
					$this->add_responsive_control(
						'cart_btn_width_size',
						[
							'label' => __( 'Width', 'axtra' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', 'em', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'width: {{SIZE}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'cart_btn_height_size',
						[
							'label' => __( 'Height', 'axtra' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', 'em', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'height: {{SIZE}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'cart_btn_space',
						[
							'label'              => __( 'Spacing', 'axtra' ),
							'type'               => Controls_Manager::DIMENSIONS,
							'size_units'         => [ 'px', 'em', '%' ],
							'selectors'          => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							
							'frontend_available' => true,
						]
					);
					$this->add_responsive_control(
						'cart_btn_padding',
						[
							'label'              => __( 'Padding', 'axtra' ),
							'type'               => Controls_Manager::DIMENSIONS,
							'size_units'         => [ 'px', 'em', '%' ],
							'selectors'          => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							
							'frontend_available' => true,
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'cart_btn_border_type',
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover',				
							'separator' => 'before',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'cart_border_box_shadow',
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover',				
							'separator' => 'before',
						]
					);
					$this->add_control(
						'cart_btn_border_radius',
						[
							'label' => esc_html__('Border Radius', 'axtra'),
							'type' => Controls_Manager::DIMENSIONS,
							'separator' => 'before',
							'size_units' => ['px'],
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'cart_btn_title_typography',
							'label' => __('Button Text Typography', 'axtra'),
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover a',				
							'separator' => 'before',
						]
					);
					$this->add_control(
						'cart_btn_title_color',
						[
							'label' => __('Button Text Color', 'axtra'),
							'type' => Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover a' => 'color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
				$this->end_controls_tab();
				
				$this->start_controls_tab(
					'axtra_tab_btn_hover',
					[
						'label' => __( 'Hover', 'axtra' ),
					]
				);
				
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'cart_btn_hover_bg_bgtype',
							'label' => __( 'Button Hover Background', 'axtra' ),
							'types' => [ 'classic', 'gradient' ],
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover:hover',				
						]
					);
					$this->add_control(
						'cart_btn_border_hover_color',
						[
							'label' => __('Button Border Hover Color', 'axtra'),
							'type' => Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover:hover' => 'border-color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
					$this->add_control(
						'cart_btn_title_hover_color',
						[
							'label' => __('Button Text Hover Color', 'axtra'),
							'type' => Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover a:hover' => 'color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
				
				$this->end_controls_tab();
				
			$this->end_controls_tabs();   
			$this->end_controls_section();
			
			//Wish List Style 
			$this->start_controls_section(
				'wishlist_button_style',
				[
					'label' => esc_html__('WISH LIST STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_loop_wishlist_style',
				[
					'label'       => __( 'ON/OFF Wish List Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'cart_wishlist_bg_bgtype',
					'label' => __( 'Wish List Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-heart',	
					'condition'             => [
						'show_loop_wishlist_style'    => 'yes',
					]			
				]
			);
			$this->add_control(
				'wishlist_icon_color',
				[
					'label' => __('Wishlist Icon Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-heart i' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_wishlist_style'    => 'yes',
					]
				]
			);			
			$this->end_controls_section();
			
		}

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'product',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		
		if( axtra_set( $settings, 'query_category' ) ) $args['product_cat'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
        
        <section class="woocomerce__shopfullwidth">
            <div class="woocomerce__filtering woocomerce-padding">
                <div class="row">
                    <?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) : ?>
                    <div class="col-lg-3">
                        <div class="woocomerce__shopsidebar wc_slide_btm">
                            <?php dynamic_sidebar( $settings['sidebar_slug'] ); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <div class="col-lg-9">
                    <!-- shop inner  -->
                        <div class="woocomerce__shopsidemain wc_feature_products">
                            <div class="woocomerce__feature-wrapper filteringwrapper shopsidebar">
                                
                                <?php 
                                    while ( $query->have_posts() ) : $query->the_post();
                                ?>
                            
                                <div class="woocomerce__feature-product">
                                    <div class="woocomerce__feature-thumb">
                                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                            <div class="img-box">
                                                <?php the_post_thumbnail('axtra_440x560', array('class'=>'image-box__item')); ?>
                                                <?php the_post_thumbnail('axtra_440x560', array('class'=>'woocomerce__feature-mainImg')); ?>
                                            </div>
                                        </a>
                                    
                                        <div class="woocomerce__feature-hover">
                                            <div class="woocomerce__feature-carttext">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/woocomerce/cart.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>">
                                                <?php woocommerce_template_loop_add_to_cart();?>
                                            </div>
                                            
                                            <?php if (class_exists('YITH_WCWL')) { ?>
                                            <div class="woocommerce-wishlist woocomerce__feature-heart ">
                                                <?php echo do_shortcode('[yith_wcwl_add_to_wishlist label=""]'); ?>
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="woocomerce__feature-content">
                                        <div class="woocomerce__feature-category">
                                            <div class="woocomerce__feature-categorytitle te-woo-cat"><?php echo wc_get_product_category_list( get_the_id() ); ?></div>
                                        </div>
                                        <div class="woocomerce__feature-titlewraper">
                                            <a class="woocomerce__feature-producttitle" href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title();?></a>
                                        </div>
                                        <span class="woocomerce__feature-newprice"><?php woocommerce_template_loop_price();?></span>
                                    </div>
                                </div>
                                
                                <?php endwhile; ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php }
		wp_reset_postdata();
	}

}