<?php namespace AXTRAPLUGIN\Element;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Services_Detail_Section_V3 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_services_detail_section_v3';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Services Detail Section V3', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'services_detail_section_v3',
            [
                'label' => esc_html__( 'Services Detail Section V3', 'axtra' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/s_detail_3.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Web and mobile development', 'axtra' ),
				'placeholder' => __( 'Enter your Title', 'axtra' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'Every decision we make needs to answer the million-dollar question: how will this benefit our partner’s goal best? We work to develop solutions', 'axtra' ),
				'placeholder' => __( 'Enter Your Text', 'axtra' ),
			]
		);
		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> esc_html__( 'We like to be different, in the same way that every mission is different. Every project is an opportunity to create result that will help you', 'axtra' ),
				'placeholder' => __( 'Enter Your Content', 'axtra' ),
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'feature_image_two',
			[
				'label' => __( 'Shape Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .te-axtra-title',                 
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .te-axtra-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .te-axtra-text',               
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .te-axtra-text' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		$title	= $settings[ 'title' ];
		$text	= $settings[ 'text' ];
		$content	= $settings[ 'content' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
		}else{
			$anim_title = '';
		}
    ?>
    
    <!-- Service detail area start -->
    <section class="service__detail">
      <div class="container g-0 line pb-140">
        <div class="line-3"></div>
        <div class="row">
          
		  <?php if( $title ){?>
          <div class="col-xxl-12">
            <div class="sec-title-wrapper">
              <h2 class="sec-title te-axtra-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $title, true );?></h2>
            </div>
          </div>
          <?php };?>
          
          <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3">
            <div class="service__detail-circle">
              <span></span>
            </div>
          </div>
          
          <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9">
            <?php if( $settings['feature_image']['id'] || $settings['feature_image_two']['id']){ ?>
            <div class="service__detail-img">
              <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
              <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image_two']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" class="sd-shape">
            </div>
            <?php };?>
            
            <?php if( $text || $content ){?>
            <div class="service__detail-content">
              <p class="te-axtra-text"><?php echo wp_kses( $text, true );?></p>
              <p class="te-axtra-text"><?php echo wp_kses( $content, true );?></p>
            </div>
          </div>
          <?php };?>
          
        </div>
      </div>
    </section>
    <!-- Service detail area end -->
               
    <?php
    }
}
