<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Services_Detail_Section_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_Services_Detail_Section_V2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Services Detail Section V2', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	/**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'Services_Detail_Section_V2',
            [
                'label' => esc_html__( 'Services Detail Section V1', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/services/s_detail_2.png'
					],
				],
			]
		);
		$this->add_control(
			'col_grid',
			[
				'label'   => esc_html__( 'Choose Column', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default'  => esc_html__( 'Default', 'axtra' ),
					'one' => esc_html__( 'One Column Grid ', 'axtra'),
					'two'  => esc_html__( 'Two Column Grid', 'axtra' ),
					'three'  => esc_html__( 'Three Column Grid', 'axtra' ),
					'four'  => esc_html__( 'Four Column Grid', 'axtra' ),
					'five'  => esc_html__( 'Six Column Grid', 'axtra' ),
				),
			]
		);
		//Funfacts Repeater
		$repeater = new Repeater();
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'block_text',
			[
				'label' => esc_html__('Content', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'funfact',
			[
				'label'                 => __('Add Work Process', 'axtra'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
				'default' => [
					[
						'block_title' => esc_html__( 'Planning and sketching', 'axtra' ),
						'block_text' => esc_html__( 'Modern and unique design practically point of view, it risks not meeting the huge expectations ', 'axtra' ),
					],
					
					[
						'block_title' => esc_html__( 'Team working', 'axtra' ),
						'block_text' => esc_html__( 'Modern and unique design practically point of view, it risks not meeting the huge expectations ', 'axtra' ),
					],
					
					[
						'block_title' => esc_html__( 'Flowchart and wireframe', 'axtra' ),
						'block_text' => esc_html__( 'Modern and unique design practically point of view, it risks not meeting the huge expectations ', 'axtra' ),
					],
					
					[
						'block_title' => esc_html__( 'User experience Testing', 'axtra' ),
						'block_text' => esc_html__( 'Modern and unique design practically point of view, it risks not meeting the huge expectations ', 'axtra' ),
					],
				],
				'title_field' => '{{{ block_title }}}',
			]
		);
		$this->end_controls_section();
		
		/************************************************************************
								Tab Style Start
		*************************************************************************/
		
		/**Service Box Style**/
		$this->start_controls_section(
			'service_box_style',
			[
				'label' => esc_html__('Box Setting', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'axtra_service_box_tab' );
		
			$this->start_controls_tab(
				'axtra_service_box_normal',
				[
					'label' => __( 'Normal', 'axtra' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'service_box_bgtype',
						'label' => __( 'Background', 'axtra' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-axtra-box',				
					]
				);
				$this->add_responsive_control(
					'service_box_space',
					[
						'label'              => __( 'Space', 'axtra' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-axtra-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_responsive_control(
					'service_box_padding',
					[
						'label'              => __( 'Padding', 'axtra' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-axtra-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'service_box_border_type',
						'selector' => 
							'{{WRAPPER}} .te-axtra-box',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'service_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-axtra-box',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'service_border_radius',
					[
						'label' => esc_html__('Border Radius', 'axtra'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-axtra-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'axtra_services_box_hover',
				[
					'label' => __( 'Hover', 'axtra' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'service_hover_bg_bgtype',
						'label' => __( 'Hover Background', 'axtra' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-axtra-box:hover',				
					]
				);
				
				$this->add_control(
					'service_background_hover_transition',
					[
						'label' => esc_html__( 'Transition Duration', 'axtra' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'max' => 3,
								'step' => 0.1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-axtra-box' => 'transition-duration: {{SIZE}}s',
						],
					]
				);
		
				$this->add_control(
					'hover_animation',
					[
						'label' => esc_html__( 'Hover Animation', 'axtra' ),
						'type' => Controls_Manager::HOVER_ANIMATION,
					]
				);
				
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();
		
		//Title Style
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title Setting', 'axtra' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
            'title__margin',
            [
                'label'      => esc_html__( 'Margin', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-axtra-work-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__( 'Padding', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-axtra-work-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Text Color', 'axtra' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-axtra-work-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),

			[
				'name' => 'title_typography',
				'label' => __('Typography', 'axtra'),
				'selector' => 
					'{{WRAPPER}} .te-axtra-work-title',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => 
					'{{WRAPPER}} .te-axtra-work-title',
			]
		);

		$this->end_controls_section();
		
		//Text Style
		
		$this->start_controls_section(
			'text_style',
			[
				'label' => esc_html__( 'Text', 'axtra' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
            'text__margin',
            [
                'label'      => esc_html__( 'Margin', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-axtra-work-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'separator'  => 'before',
            ]
        );
		
        $this->add_responsive_control(
            'text_padding',
            [
                'label'      => esc_html__( 'Padding', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-axtra-work-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'separator'  => 'before',
            ]
        );
		
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'axtra' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-axtra-work-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __('Typography', 'axtra'),
				'selector' => 
				'{{WRAPPER}} .te-axtra-work-text',
			]
		);

		$this->end_controls_section();
		
   	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$grid_col = $settings[ 'col_grid' ];
		if( $grid_col == 'one' ){
			$classes = 'col-xxl-12 col-xl-12 col-lg-12 col-md-12';
		}elseif( $grid_col == 'two' ){
			$classes = 'col-xxl-6 col-xl-6 col-lg-6 col-md-6';
		}elseif( $grid_col == 'three' ){
			$classes = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4';
		}elseif( $grid_col == 'four' ){
			$classes = 'col-xxl-3 col-xl-3 col-lg-3 col-md-3';
		}elseif( $grid_col == 'five' ){
			$classes = 'col-xxl-2 col-xl-2 col-lg-2 col-md-12';
		}else{
			$classes = 'col-xxl-3 col-xl-3 col-lg-3 col-md-3';
		}
	?>
	
    <!-- Workflow area start -->
    <section class="workflow__area-6">
        <div class="container g-0 line pb-130">
            <div class="line-3"></div>
            <div class="workflow__wrapper-6 te-axtra-box">
                <div class="row">
                	<?php foreach($settings['funfact'] as $key => $item): ?>
                    <div class="<?php echo esc_attr( $classes );?>">
                        <div class="workflow__slide-6">
                            <h6 class="workflow__title-6 te-axtra-work-title"><?php echo wp_kses($item['block_title'], true); ?></h6>
                            <p class="te-axtra-work-text"><?php echo wp_kses($item['block_text'], true); ?></p>
                        </div>
                    </div>
                	<?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- Workflow area end -->
           
    <?php  
    }
}
