<?php namespace AXTRAPLUGIN\Element;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Product_Tabs extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_product_tabs';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Product Tabs', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'product_tabs',
            [
                'label' => esc_html__('Product Tabs', 'organiqo'),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/product/product_layout_four.png'
					],
				],
			]
		);
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'axtra' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'axtra' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
        
		//Product Tab Repeater
		$repeater = new Repeater();
		$repeater->add_control(
            'tab_btn_title',
            [
                'label'       => __( 'Tab Button Title', 'axtra' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$repeater->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$repeater->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
			]
		);
		$repeater->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
			]
		);
		$repeater->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'axtra'),
			  'label_block' => true,
			  'options' => get_product_categories(),
			]
		);
		$this->add_control(
			'product_tab',
			[
				'label'                 => __('Add Tab Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
    
	
		/** Style Tab **/
			$this->register_style_background_controls();
		}
		
		/************************************************************************
									Tab Style Start
		*************************************************************************/
		
		protected function register_style_background_controls()
		{
			
			//General Style
			$this->start_controls_section(
				'general_style',
				[
					'label' => esc_html__( 'General Setting', 'axtra' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);		
			$this->add_responsive_control(
				'general_margin',
				[
					'label'      => esc_html__( 'Margin', 'pyloncore' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em'],
					'selectors'  => [
						'{{WRAPPER}} .woocomerce__feature' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);		
			$this->add_responsive_control(
				'general_padding',
				[
					'label'      => esc_html__( 'Padding', 'pyloncore' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em'],
					'selectors'  => [
						'{{WRAPPER}} .woocomerce__feature' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);		
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'general_bgtype',
					'label' => __( 'Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .woocomerce__feature',				
				]
			);
			$this->end_controls_section();
			
			/**Title Style**/
			$this->start_controls_section(
				'title_style',
				[
					'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_title_style',
				[
					'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => __('Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-title',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => __('Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-title' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_title_style'    => 'yes',
					]
				]
			);
			$this->end_controls_section();
			
			
			/**View Button Title Style**/
			$this->start_controls_section(
				'view_btn_title_style',
				[
					'label' => esc_html__('VIEW BUTTON STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_btn_title_style',
				[
					'label'       => __( 'ON/OFF Button Title Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'btn_title_typography',
					'label' => __('Button Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-viewall',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_btn_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'btn_title_color',
				[
					'label' => __('Button Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-viewall' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_btn_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'btn_title_hover_color',
				[
					'label' => __('Button Title Hover Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-viewall:hover' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_btn_title_style'    => 'yes',
					]
				]
			);
			$this->end_controls_section();
			
			/**Tab Button Title Style**/
			$this->start_controls_section(
				'tab_btn_title_style',
				[
					'label' => esc_html__('TAB BUTTON STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_tab_btn_title_style',
				[
					'label'       => __( 'ON/OFF Tab Button Title Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'tab_btn_title_typography',
					'label' => __('Tab Button Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .nav-link',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_tab_btn_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'tab_btn_title_color',
				[
					'label' => __('Tab Button Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .nav-link' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_tab_btn_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'tab_btn_title_hover_color',
				[
					'label' => __('Tab Button Title Hover Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .nav-link:hover' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_tab_btn_title_style'    => 'yes',
					]
				]
			);
			$this->end_controls_section();
		
			/**Loop Item Style**/
			$this->start_controls_section(
				'loop_item_style',
				[
					'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_loop_category_style',
				[
					'label'       => __( 'ON/OFF loop category Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'category_bgtype',
					'label' => __( 'Category Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-categorytitle',				
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'category_hover_bgtype',
					'label' => __( 'Category Hover Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-categorytitle:hover',				
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'loop_category_title_typography',
					'label' => __('Category Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-categorytitle',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'category_title_color',
				[
					'label' => __('Category Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-categorytitle' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'category_title_hover_color',
				[
					'label' => __('Category Title Hover Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-categorytitle:hover' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_category_style'    => 'yes',
					]
				]
			);
			//Loop Title
			$this->add_control(
				'show_loop_title_style',
				[
					'label'       => __( 'ON/OFF Title Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'loop_title_typography',
					'label' => __('Title Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-producttitle',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_loop_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'loop_title_color',
				[
					'label' => __('Title Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-producttitle' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_title_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'loop_title_hover_color',
				[
					'label' => __('Title Hover Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-producttitle:hover' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_title_style'    => 'yes',
					]
				]
			);
			
			//Price Style 
			$this->add_control(
				'show_loop_item_price_style',
				[
					'label'       => __( 'ON/OFF Price Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'loop_price_typography',
					'label' => __('Price Typography', 'axtra'),
					'selector' => 
						'{{WRAPPER}} .price .woocommerce-Price-amount bdi',                 
					'separator' => 'before',
					'global' => [
						'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
					],
					'condition'             => [
						'show_loop_item_price_style'    => 'yes',
					]
				]
			);
			$this->add_control(
				'loop_price_color',
				[
					'label' => __('Price Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .price .woocommerce-Price-amount bdi' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_item_price_style'    => 'yes',
					]
				]
			);			
			$this->end_controls_section();
			
			/**Button Style**/
			$this->start_controls_section(
				'cart_button_style',
				[
					'label' => esc_html__('CART BUTTON STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs( 'axtra_tabs_btn' );
			
				$this->start_controls_tab(
					'axtra_tab_btn_normal',
					[
						'label' => __( 'Normal', 'axtra' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'cart_btn_bgtype',
							'label' => __( 'Cart Button Background', 'axtra' ),
							'types' => [ 'classic', 'gradient' ],
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover',				
						]
					);
					$this->add_responsive_control(
						'cart_btn_width_size',
						[
							'label' => __( 'Width', 'axtra' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', 'em', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'width: {{SIZE}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'cart_btn_height_size',
						[
							'label' => __( 'Height', 'axtra' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', 'em', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'height: {{SIZE}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'cart_btn_space',
						[
							'label'              => __( 'Spacing', 'axtra' ),
							'type'               => Controls_Manager::DIMENSIONS,
							'size_units'         => [ 'px', 'em', '%' ],
							'selectors'          => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							
							'frontend_available' => true,
						]
					);
					$this->add_responsive_control(
						'cart_btn_padding',
						[
							'label'              => __( 'Padding', 'axtra' ),
							'type'               => Controls_Manager::DIMENSIONS,
							'size_units'         => [ 'px', 'em', '%' ],
							'selectors'          => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							
							'frontend_available' => true,
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'cart_btn_border_type',
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover',				
							'separator' => 'before',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'cart_border_box_shadow',
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover',				
							'separator' => 'before',
						]
					);
					$this->add_control(
						'cart_btn_border_radius',
						[
							'label' => esc_html__('Border Radius', 'axtra'),
							'type' => Controls_Manager::DIMENSIONS,
							'separator' => 'before',
							'size_units' => ['px'],
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'cart_btn_title_typography',
							'label' => __('Button Text Typography', 'axtra'),
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover a',				
							'separator' => 'before',
						]
					);
					$this->add_control(
						'cart_btn_title_color',
						[
							'label' => __('Button Text Color', 'axtra'),
							'type' => Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover a' => 'color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
				$this->end_controls_tab();
				
				$this->start_controls_tab(
					'axtra_tab_btn_hover',
					[
						'label' => __( 'Hover', 'axtra' ),
					]
				);
				
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'cart_btn_hover_bg_bgtype',
							'label' => __( 'Button Hover Background', 'axtra' ),
							'types' => [ 'classic', 'gradient' ],
							'selector' => 
								'{{WRAPPER}} .woocomerce__feature-hover:hover',				
						]
					);
					$this->add_control(
						'cart_btn_border_hover_color',
						[
							'label' => __('Button Border Hover Color', 'axtra'),
							'type' => Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover:hover' => 'border-color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
					$this->add_control(
						'cart_btn_title_hover_color',
						[
							'label' => __('Button Text Hover Color', 'axtra'),
							'type' => Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .woocomerce__feature-hover a:hover' => 'color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
				
				$this->end_controls_tab();
				
			$this->end_controls_tabs();   
			$this->end_controls_section();
			
			//Wish List Style 
			$this->start_controls_section(
				'wishlist_button_style',
				[
					'label' => esc_html__('WISH LIST STYLE SETTING', 'axtra'),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'show_loop_wishlist_style',
				[
					'label'       => __( 'ON/OFF Wish List Style', 'axtra' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'axtra' ),
					'label_off' => esc_html__( 'Hide', 'axtra' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);	
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'cart_wishlist_bg_bgtype',
					'label' => __( 'Wish List Background', 'axtra' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => 
						'{{WRAPPER}} .woocomerce__feature-heart',	
					'condition'             => [
						'show_loop_wishlist_style'    => 'yes',
					]			
				]
			);
			$this->add_control(
				'wishlist_icon_color',
				[
					'label' => __('Wishlist Icon Color', 'axtra'),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .woocomerce__feature-heart i' => 'color: {{VALUE}}',
					],
					'separator' => 'before',
					'global' => [
						'default' => Global_Colors::COLOR_SECONDARY,
					],
					'condition'             => [
						'show_loop_wishlist_style'    => 'yes',
					]
				]
			);			
			$this->end_controls_section();
	
	}

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
	?>
    
    <!-- feature  -->
    <section class="woocomerce__feature woocomerce-padding missed_products woocommerce m-bt-0">
        <div class="woocomerce__feature-top">
        	<?php if($settings['title']){ ?><p class="woocomerce__feature-title"><?php echo wp_kses( $settings['title'], true ); ?></p><?php } ?>
            <div class="woocomerce__feature-rightwrapper rightwrapper2">
                <div class="woocomerce__feature-arrowwrapper">
                    <ul class="nav nav-pills woocomerce__feature-filtermenu" id="pills-tab" role="tablist">
                    	<?php foreach($settings['product_tab'] as $key => $item):?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if($key == 0) echo 'active';?>" id="pills-home-tab-<?php echo esc_attr($key);?>" data-bs-toggle="pill" data-bs-target="#pills-home-<?php echo esc_attr($key);?>" type="button" role="tab" aria-selected="<?php if($key == 0) echo 'true'; else echo 'false'?>"><?php echo wp_kses($item['tab_btn_title'], true);?></button>
                        </li>
                    	<?php endforeach; ?>
                    </ul>
                </div>
                <?php if($settings['btn_link']['url'] & $settings['btn_title']){ ?>
            	<a class="woocomerce__feature-viewall" href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>"><?php echo wp_kses( $settings['btn_title'], true ); ?></a>
                <?php } ?>
            </div>
        </div>
        
        <div class="tab-content" id="pills-tabContent">
        	<?php foreach($settings['product_tab'] as $keys => $item):
                                                
				$paged = get_query_var('paged');
				$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
				$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
				$args = array(
					'post_type'      => 'product',
					'posts_per_page' => axtra_set( $item, 'query_number' ),
					'orderby'        => axtra_set( $item, 'query_orderby' ),
					'order'          => axtra_set( $item, 'query_order' ),
					'paged'         => $paged
				);
				
				if( axtra_set( $settings, 'query_category' ) ) $args['product_cat'] = axtra_set( $settings, 'query_category' );
				$query = new \WP_Query( $args );
		
				if ( $query->have_posts()): 	
			?>
            <div class="tab-pane fade <?php if($keys == 0) echo 'show active';?>" id="pills-home-<?php echo esc_attr($keys);?>" role="tabpanel" aria-labelledby="pills-home-tab-<?php echo esc_attr($key);?>" tabindex="0">
                <div class="woocomerce__feature-wrapper filteringwrapper">
                	<?php 
						while ( $query->have_posts() ) : $query->the_post();
					?>
                    <div class="woocomerce__feature-product ">
                        <div class="woocomerce__feature-thumb">
                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                <div class="img-box">
                                	<?php the_post_thumbnail('axtra_440x560', array('class'=>'image-box__item')); ?>
                                    <?php the_post_thumbnail('axtra_440x560', array('class'=>'woocomerce__feature-mainImg')); ?>
                                </div>
                            </a>
                            <div class="woocomerce__feature-hover">
                                <div class="woocomerce__feature-carttext">
                                	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/woocomerce/cart.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>">
                                    <?php woocommerce_template_loop_add_to_cart();?>
                                </div>
                                
								<?php if (class_exists('YITH_WCWL')) { ?>
                                <div class="woocommerce-wishlist woocomerce__feature-heart ">
                                    <?php echo do_shortcode('[yith_wcwl_add_to_wishlist label=""]'); ?>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        
                        <div class="woocomerce__feature-content">
                            <div class="woocomerce__feature-category">
                           		<div class="woocomerce__feature-categorytitle te-woo-cat"><?php echo wc_get_product_category_list( get_the_id() ); ?></div>
                            </div>
                            <div class="woocomerce__feature-titlewraper">
                                <a class="woocomerce__feature-producttitle" href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title();?></a>
                            </div>
                            <span class="woocomerce__feature-newprice"><?php woocommerce_template_loop_price();?></span>
                        </div>
                    </div>
                	<?php endwhile;?>
                </div>
            </div>
        	<?php endif;?>
            <?php endforeach;?>
        </div>
    </section>
    <!-- /feature  -->
    
	<?php 
	}

}
