<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Product_Category extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_product_category';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Product Category', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

	public function get_script_depends() {
		wp_register_script( 'product-category-script', YT_URL . 'assets/js/product-category.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'product-category-script' ];
	}

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'product_category',
            [
                'label' => esc_html__( 'Product Category', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/product/product_layout_five.png'
					],
				],
			]
		);
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'axtra' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'axtra' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		//Funfacts Repeater
		$repeater = new Repeater();
		$repeater->add_control(
			'feature_image',
			[
				'label' => __( 'Choose Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'block_title',
			[
				'label' => esc_html__('Title', 'axtra'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
            'btn_title_v1',
            [
                'label'       => __( 'Button Title', 'axtra' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$repeater->add_control(
            'btn_link_v1',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'slide_category',
			[
				'label'                 => __('Add Slide Item', 'classyea'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
				'condition'             => [
					'layout_control'    => ['one', 'two']
				],
			]
		);
		$this->end_controls_section();
		
		/*******************Style Tab*******************/
		
		//General Style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__( 'General Setting', 'axtra' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		
		$this->add_responsive_control(
			'general_margin',
			[
				'label'      => esc_html__( 'Margin', 'pyloncore' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .woocomerce__feature' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);		
		$this->add_responsive_control(
			'general_padding',
			[
				'label'      => esc_html__( 'Padding', 'pyloncore' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .woocomerce__feature' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'general_bgtype',
				'label' => __( 'Background', 'axtra' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .woocomerce__feature',				
			]
		);
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Title Typography', 'axtra'),
				'selector' => 
					'{{WRAPPER}} .woocomerce__feature-title',                 
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __('Title Color', 'axtra'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .woocomerce__feature-title' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
			]
		);
		$this->end_controls_section();
		
		
		/**View Button Title Style**/
		$this->start_controls_section(
			'view_btn_title_style',
			[
				'label' => esc_html__('VIEW BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_title_style',
			[
				'label'       => __( 'ON/OFF Button Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_title_typography',
				'label' => __('Button Title Typography', 'axtra'),
				'selector' => 
					'{{WRAPPER}} .woocomerce__feature-viewall',                 
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
				],
				'condition'             => [
					'show_btn_title_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'btn_title_color',
			[
				'label' => __('Button Title Color', 'axtra'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .woocomerce__feature-viewall' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_btn_title_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'btn_title_hover_color',
			[
				'label' => __('Button Title Hover Color', 'axtra'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .woocomerce__feature-viewall:hover' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'condition'             => [
					'show_btn_title_style'    => 'yes',
				]
			]
		);
		$this->end_controls_section();
		
		/**Loop Title Style**/
		$this->start_controls_section(
			'Loop_title_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .woocomerce__category-title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__category-title a' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__category-title a:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		//Loop Overlay Button
		$this->add_control(
			'show_loop_btn_style',
			[
				'label'       => __( 'ON/OFF Button Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'axtra' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => 
					'{{WRAPPER}} .woocomerce__category-thumb::after',				
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_btn_title_typography',
                'label' => __('Button Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .woocomerce__category-hover',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_title_color',
            [
                'label' => __('Button Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__category-hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_title_hover_color',
            [
                'label' => __('Button Title Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .woocomerce__category-hover:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
				
   	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
	?>
	
    <!-- category  -->
    <section class="woocomerce__feature category-feature woocomerce-padding wc_category_products">
        <div class="woocomerce__feature-top">
        	<?php if($settings['title']){ ?><p class="woocomerce__feature-title"><?php echo wp_kses( $settings['title'], true ); ?></p><?php } ?>
            <div class="woocomerce__feature-rightwrapper">
                <div class="woocomerce__feature-arrowwrapper">
                    <div class="swiper-button-narrow"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images//woocomerce/arrow-left.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>"></div>
                    <div class="swiper-button-parrow"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images//woocomerce/arrow-right.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>"></div>
                </div>
            	
                <?php if($settings['btn_link']['url'] & $settings['btn_title']){ ?>
                <a class="woocomerce__feature-viewall" href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>"><?php echo wp_kses( $settings['btn_title'], true ); ?></a>
                <?php } ?>
            </div>
        </div>
    
        <div class="woocomerce__category">
            <div class="swiper category-active">
                <div class="swiper-wrapper">
                    <?php foreach($settings['slide_category'] as $key => $item): ?>
                    <!-- Slides -->
                    <div class="swiper-slide">
                        <div class="woocomerce__category-item">
                            <div class="woocomerce__category-thumb">
                                <img src="<?php echo esc_url(wp_get_attachment_url($item['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>">
                                <?php if($item['btn_link_v1']['url'] || $item['btn_title_v1']){ ?>
                                <a class="woocomerce__category-hover" href="<?php echo esc_url($item['btn_link_v1']['url']); ?>"><?php echo wp_kses($item['btn_title_v1'], true); ?></a>
                            	<?php } ?>
                            </div>
                            <div class="woocomerce__category-content">
                                <h2 class="woocomerce__category-title"><a href="<?php echo esc_url($item['btn_link_v1']['url']); ?>"><?php echo wp_kses($item['block_title'], true); ?></a></h2>
                            </div>
                        </div>
                    </div>
                	<?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- /category  -->
	           
    <?php
    }
}
