<?php

namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Testimonials extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'axtra_our_testimonials';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Testimonials', 'axtra' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'axtra' ];
	}
	
	public function get_script_depends() {
		wp_register_script( 'testimonial-script', YT_URL . 'assets/js/testimonial.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'testimonial-script' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_testimonials',
			[
				'label' => esc_html__( 'Our Testimonials', 'axtra' ),
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial_layout_four.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
            'video_source_link',
			[
				'label' => __( 'Video Source Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'layout_control'      => ['three']
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF Line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two' ]
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two' ]
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'show_images',
			[
				'label'       => __( 'ON/OFF Testimonials Images', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'feature_image1',
			[
				'label' => __( 'Feature Image V1', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_images'      => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'feature_image2',
			[
				'label' => __( 'Feature Image V2', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_images'      => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'feature_image3',
			[
				'label' => __( 'Feature Image V3', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_images'      => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'feature_image4',
			[
				'label' => __( 'Feature Image V4', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_images'      => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'feature_image5',
			[
				'label' => __( 'Feature Image V5', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_images'      => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'feature_image6',
			[
				'label' => __( 'Feature Image V6', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_images'      => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four']
				],
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'axtra' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four']
				],
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'axtra' ),
					'title'      => esc_html__( 'Title', 'axtra' ),
					'menu_order' => esc_html__( 'Menu Order', 'axtra' ),
					'rand'       => esc_html__( 'Random', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four']
				],
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'axtra' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'axtra' ),
					'ASC'  => esc_html__( 'ASC', 'axtra' ),
				),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four']
				],
			]
		);
		$this->add_control(
            'query_category', 
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__('Category', 'axtra'),
				'label_block' => true,
				'options' => get_testimonials_categories(),
				'condition' => [
					'layout_control'      => ['one', 'two', 'three', 'four']
				],
			]
		);
		$this->end_controls_section();
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .sec-sub-title,
					{{WRAPPER}} .sec-subtile-6',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-subtile-6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title,
					{{WRAPPER}} .sec-title-6',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sec-title-6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .testimonial__sec-title p',
				'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial__sec-title p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		/**Post Item Style**/
		$this->start_controls_section(
			'loop_post_style',
			[
				'label' => esc_html__('LOOP ITEM STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_loop_author_style',
			[
				'label'       => __( 'ON/OFF Author Name Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_author_color',
            [
                'label' => __('Post Author Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .client__role-3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial__name-4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial__author' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocomerce__testimonial-post' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_author_style'    => 'yes',
				]
            ]
        );	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_author_typography',
                'label' => __('Post Author Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .client__role-3,
                    {{WRAPPER}} .testimonial__name-4,
                    {{WRAPPER}} .testimonial__author,
					{{WRAPPER}} .woocomerce__testimonial-post',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_loop_author_style'    => 'yes',
				]
            ]
        );
		
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF Post Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Post Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .client__name-3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial__role-4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial__title-2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocomerce__testimonial-name' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Post Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .client__name-3,
                    {{WRAPPER}} .testimonial__role-4,
                    {{WRAPPER}} .testimonial__title-2,
					{{WRAPPER}} .woocomerce__testimonial-name',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF Post Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
            'loop_content_color',
            [
                'label' => __('Post Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial__slide-3 p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial__info-4 p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial__text-2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocomerce__testimonial-dis' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_content_typography',
                'label' => __('Post Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .testimonial__slide-3 p,
                    {{WRAPPER}} .testimonial__info-4 p,
                    {{WRAPPER}} .testimonial__text-2,
					{{WRAPPER}} .woocomerce__testimonial-dis',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
			$anim_text = 'text-anim';
			$animation_image_zoom = 'animation_image_zoom';
		}else{
			$anim_title = '';
			$anim_text = '';
			$animation_image_zoom = '';
		}
		
        $paged = get_query_var('paged');
		$paged = axtra_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-axtra' );
		$args = array(
			'post_type'      => 'testimonials',
			'posts_per_page' => axtra_set( $settings, 'query_number' ),
			'orderby'        => axtra_set( $settings, 'query_orderby' ),
			'order'          => axtra_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( axtra_set( $settings, 'query_category' ) ) $args['testimonials_cat'] = axtra_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
	{ ?>
	
    <?php if($settings['layout_control'] == 'four'): ?>
    
    <!-- testimonial  -->
    <div class="woocomerce__testimonial woocomerce-padding">
        <div class="woocomerce__testimonial-wrapper">
            <div class="swiper woocomerce-testimonial">
                <div class="swiper-wrapper">
                	<?php 
						while ( $query->have_posts() ) : $query->the_post(); 
					?>
                    <div class="swiper-slide">
                        <div class="woocomerce__testimonial-item">
                            <div class="woocomerce__testimonial-thumb">
                            	<img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/woocomerce/quote.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>">
                            </div>
                            <div class="woocomerce__testimonial-content">
                                <p class="woocomerce__testimonial-dis"><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                <h2 class="woocomerce__testimonial-name"><?php the_title(); ?></h2>
                                <span class="woocomerce__testimonial-post"><?php echo (get_post_meta( get_the_id(), 'author_designation', true ));?></span>
                            </div>
                        </div>
                    </div>
                	<?php endwhile; ?> 
                </div>
            </div>
        </div>
    </div>
    <!-- /testimonial  -->
	
	<?php elseif($settings['layout_control'] == 'three'): ?>
	
    <!-- Testimonial area start -->
    <section class="testimonial__area-2">
        <div class="container g-0 line pb-140">
        	<span class="line-3"></span>
        
            <div class="row g-0">
                <?php if($settings[ 'video_source_link' ]['url']){ ?>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                    <div class="testimonial__video">
                        <video autoplay muted loop>
                        	<source src="<?php echo esc_url( $settings[ 'video_source_link' ]['url'] );?>" type="video/mp4">
                        </video>
                    </div>
                </div>
            	<?php } ?>
                <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7">
                    <div class="testimonial__slider-wrapper-2">
                        <div class="swiper testimonial__slider">
                            <div class="swiper-wrapper">
								<?php 
                                    while ( $query->have_posts() ) : $query->the_post(); 
                                ?>
                                <div class="swiper-slide testimonial__slide">
                                    <div class="testimonial__inner-2">
                                        <h2 class="testimonial__title-2"><?php the_title(); ?></h2>
                                        <p class="testimonial__text-2"><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                        <h3 class="testimonial__author"><?php echo (get_post_meta( get_the_id(), 'author_name', true ));?></h3>
                                        <h4 class="testimonial__role"><?php echo (get_post_meta( get_the_id(), 'author_designation', true ));?></h4>
                                    </div>
                                </div>
                                <?php endwhile; ?>                      
                            </div>
                        </div>
                    
                    	<div class="testimonial__pagination">
                            <div class="prev-button"><i class="fa-solid fa-arrow-right"></i></div>
                            <div class="next-button"><i class="fa-solid fa-arrow-left"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Testimonial area end -->
	
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Testimonial area start -->
    <section class="testimonial__area-4 ">
        <div class="container g-0 line_4">
            <?php if($settings[ 'show_line_pattern' ]){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
            
            <div class="row">
                <?php if($settings[ 'subtitle' ] || $settings[ 'title' ] || $settings[ 'text' ]){ ?>
                <div class="col-xxl-12">
                    <div class="testimonial__sec-title <?php echo esc_attr( $anim_text );?>">
                        <?php if($settings[ 'subtitle' ]){ ?><h2 class="sec-subtile-6"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></h2><?php } ?>
                        <?php if($settings[ 'title' ]){ ?><h3 class="sec-title-6 <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses( $settings[ 'title' ], true );?></h3><?php } ?>
                        <?php if($settings[ 'text' ]){ ?><p><?php echo wp_kses( $settings[ 'text' ], true );?></p><?php } ?>
                    </div>
                </div>
                <?php } ?>
                <div class="swiper testimonial__slider-4">
                    <div class="swiper-wrapper">
                        <?php 
							while ( $query->have_posts() ) : $query->the_post(); 
						?>
                        <div class="swiper-slide testimonial__slide-4">
                        	<?php the_post_thumbnail('axtra_85x85', array('class'=> 'testimonial__img-4')); ?>
                            <div class="testimonial__info-4">
                                <h4 class="testimonial__feedback-4"><?php echo (get_post_meta( get_the_id(), 'author_feedback', true ));?></h4>
                                <p><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                <h5 class="testimonial__name-4"><?php the_title(); ?></h5>
                                <h6 class="testimonial__role-4"><?php echo (get_post_meta( get_the_id(), 'author_designation', true ));?> </h6>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    
                    <div class="testimonial__btn-4">
                        <div class="next-button swipper-btn"><i class="fa-solid fa-arrow-left"></i></div>
                        <div class="prev-button swipper-btn"><i class="fa-solid fa-arrow-right"></i></div>
                        <div class="pagination testimonial__pagination-4">
                            <div class="pag"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Testimonial area end -->
    
    <?php else: ?>
    
    <!-- Testimonial area start -->
    <section class="testimonial__area-3">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="swiper testimonial__slider-3">
                        <div class="swiper-wrapper">
                        	<?php 
								while ( $query->have_posts() ) : $query->the_post(); 
							?>
                            <div class="swiper-slide testimonial__slide-3">
                                <p><?php echo wp_kses(axtra_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                <h2 class="client__name-3"><?php the_title(); ?></h2>
                                <h3 class="client__role-3"><?php echo (get_post_meta( get_the_id(), 'author_designation', true ));?></h3>
                            </div>
                        	<?php endwhile; ?>
                        </div>
                        <div class="next-button swipper-btn"><i class="fa-solid fa-arrow-left"></i></div>
                        <div class="prev-button swipper-btn"><i class="fa-solid fa-arrow-right"></i></div>
                    </div>
                </div>
            </div>
        </div>
        
		<?php if($settings[ 'show_images' ]){ ?>
        <div class="testimonial__images-3 <?php echo esc_attr( $animation_image_zoom );?>">
            <?php if($settings['feature_image1']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="testimonial3__img"><?php } ?>
            <?php if($settings['feature_image2']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="testimonial3__img-2"><?php } ?>
            <?php if($settings['feature_image3']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image3']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="testimonial3__img-3"><?php } ?>
            <?php if($settings['feature_image4']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image4']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="testimonial3__img-4"><?php } ?>
            <?php if($settings['feature_image5']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image5']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="testimonial3__img-5"><?php } ?>
            <?php if($settings['feature_image6']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image6']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="testimonial3__img-6"><?php } ?>
        </div>
        <?php } ?>
        
    </section>
    <!-- Testimonial area end -->
             
	<?php endif; }
    wp_reset_postdata();
	}

}