<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Story extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_our_story';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Story', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'our_story',
            [
                'label' => esc_html__( 'Our Story', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/story/story_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/story/story_layout_two.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'experience_year',
			[
				'label'       => __( 'Experience Year', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Year', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one']
				],
			]
		);
		$this->add_control(
			'features_list',
			[
				'label'       => __( 'Features List', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Features List', 'axtra' ),
				'condition' => [
					'layout_control'      => ['two']
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image V1', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'feature_image2',
			[
				'label' => __( 'Feature Image V2', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'feature_image3',
			[
				'label' => __( 'Feature Image V3', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'feature_image4',
			[
				'label' => __( 'Feature Image V4', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one', 'two']
				],
			]
		);
		$this->end_controls_section();
   		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Sub title Style**/		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '{{WRAPPER}} .sec-sub-title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-sub-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .sec-title,   
                    {{WRAPPER}} .career__gallery ul li',               
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .career__gallery ul li' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => 
                    '{{WRAPPER}} .about__area-2 .sec-text p,  
                    {{WRAPPER}} .story__text p,           
                    {{WRAPPER}} .career__gallery p',         
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about__area-2 .sec-text p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .story__text p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .career__gallery p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
			$anim_text = 'text-anim';
			$img_anim = 'img-anim';
		}else{
			$anim_title = '';
			$anim_text = '';
			$img_anim = '';
		}
    ?>
	
    <?php if($settings['layout_control'] == 'two'): ?>
    
    <!-- Career gallery start -->
    <section class="career__gallery">
        <div class="container g-0 line pt-140 pb-140">
        	<span class="line-3"></span>
            <div class="row">
                <div class="col-xxl-12">
                    <?php 
						$features_list = $settings['features_list'];
						if(!empty($features_list)){
						$features_list = explode("\n", ($features_list)); 
					?>
                    <ul>
                        <?php foreach($features_list as $features): ?>
                        <li><?php echo wp_kses($features, true); ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <?php } ?>
					<?php echo wp_kses($settings['text'], true);?>
                </div>
            </div>
        
            <div class="row">
                <?php if($settings['feature_image']['id']){ ?>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3">
                    <div class="career__gallery-img">
                    	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>">
                    </div>
                </div>
                <?php } ?>
                <?php if($settings['feature_image2']['id']){ ?>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                    <div class="career__gallery-img <?php echo esc_attr( $img_anim );?>">
                    	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image2']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" data-speed="auto">
                    </div>
                </div>
                <?php } ?>
                <?php if($settings['feature_image3']['id'] || $settings['feature_image4']['id']){ ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="career__gallery-img">
                        <?php if($settings['feature_image3']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image3']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"><?php } ?>
                        <?php if($settings['feature_image4']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image4']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"><?php } ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </section>
    <!-- Career gallery end -->
    
    <?php else: ?>
    
    <!-- Story area start -->
    <section class="story__area">
        <div class="container g-0 line pt-140">
        	<span class="line-3"></span>
            <div class="sec-title-wrapper">
            	<?php if($settings['experience_year']){ ?><div class="from-text"><?php echo wp_kses($settings['experience_year'], true);?></div><?php } ?>
            	
				<?php if($settings['subtitle'] || $settings['title'] || $settings['text']){ ?>
                <div class="row">
                    <?php if($settings['subtitle'] || $settings['title']){ ?>
                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                        <?php if($settings['subtitle']){ ?><h2 class="sec-sub-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses($settings['subtitle'], true);?></h2><?php } ?>
                        <?php if($settings['title']){ ?><h3 class="sec-title <?php echo esc_attr( $anim_title );?>"><?php echo wp_kses($settings['title'], true);?></h3><?php } ?>
                    </div>
                    <?php } ?>
                    
					<?php if($settings['text']){ ?>
                    <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7">
                        <div class="story__text">
                            <?php echo wp_kses($settings['text'], true);?>
                        </div>
                    </div>
                	<?php } ?>
                </div>
                <?php } ?>
            </div>
            
            <div class="row">
                <?php if($settings['feature_image']['id']){ ?>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3">
                    <div class="story__img-wrapper">
                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" class="w-100">
                    </div>
                </div>
                <?php } ?>
                <?php if($settings['feature_image2']['id']){ ?>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5">
                    <div class="story__img-wrapper <?php echo esc_attr( $img_anim );?>">
                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image2']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>" data-speed="auto">
                    </div>
                </div>
                <?php } ?>
                
				<?php if($settings['feature_image3']['id'] || $settings['feature_image4']['id']){ ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="story__img-wrapper">
                        <?php if($settings['feature_image3']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image3']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"><?php } ?>
                        <?php if($settings['feature_image4']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image4']['id']));?>" alt="<?php esc_attr_e('Awesome Images', 'axtra'); ?>"><?php } ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </section>
    <!-- Story area end -->
               
    <?php endif;
    }
}
