<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Banner extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_our_banner';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Banner', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'our_banner',
            [
                'label' => esc_html__( 'Our Banner', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner_layout_one.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner_layout_two.png'
					],
					'three' => [
						'label' => esc_html__('Layout 3', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner_layout_three.png'
					],
					'four' => [
						'label' => esc_html__('Layout 4', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner_layout_four.png'
					],
					'five' => [
						'label' => esc_html__('Layout 5', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner_layout_five.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label' => __( 'BG Pattern Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['two', 'three' ]
				],
			]
		);
		$this->add_control(
			'show_line_pattern',
			[
				'label'       => __( 'ON/OFF Line Pattern', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => 'five',
				],
			]
		);
		$this->add_control(
			'show_service_link',
			[
				'label'       => __( 'ON/OFF Service Button', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => 'three',
				],
			]
		);
		$this->add_control(
			'service_btn_title',
			[
				'label'       => __( 'Service Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Service Button Title', 'axtra' ),
				'condition' => [
					'show_service_link' => 'yes',
				],
			]
		);
		$this->add_control(
			'service_btn_link',
			[
				  'label' => __( 'External Button Url', 'buildy' ),
				  'type' => Controls_Manager::URL,
				  'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				  'show_external' => true,
				  'default' => [
				    'url' => '',
				    'is_external' => true,
				    'nofollow' => true,
				  ],
				  'condition' => [
					'show_service_link' => 'yes',
				  ],
			 ]
		);
		
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'axtra' ),
				'condition' => [
					'layout_control' => 'one',
				],
			]
		);
		$this->add_control(
			'title1',
			[
				'label'       => __( 'Left Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Left Title', 'axtra' ),
				'condition' => [
					'layout_control' => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'show_cat_title',
			[
				'label'       => __( 'ON/OFF Promo Text', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => 'three',
				],
			]
		);
		$this->add_control(
			'cat_title',
			[
				'label'       => __( 'Promo Text', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Pro', 'axtra' ),
				'condition' => [
					'show_cat_title' => 'yes'
				],
			]
		);
		$this->add_control(
			'title2',
			[
				'label'       => __( 'Right Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Right Title', 'axtra' ),
				'condition' => [
					'layout_control' => ['one', 'two']
				],
			]
		);
		$this->add_control(
			'show_text_area',
			[
				'label'       => __( 'ON/OFF Description', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control' => ['one', 'two', 'three', 'four', 'five']
				],
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'axtra' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'axtra' ),
				'condition' => [
					'show_text_area' => 'yes',
				],
			]
		);
		$this->add_control(
			'show_arrow_img',
			[
				'label'       => __( 'ON/OFF Arrow Image', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'arrow_down_image',
			[
				'label' => __( 'Arrow Down Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'show_arrow_img'	  => 'yes'
				],
			]
		);
		$this->add_control(
			'show_video_area',
			[
				'label'       => __( 'ON/OFF Video Info', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'video_title1',
			[
				'label'       => __( 'Video Watch Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Video Watch Title', 'axtra' ),
				'condition' => [
					'show_video_area' => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'video_title2',
			[
				'label'       => __( 'Video Close Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Video Close Title', 'axtra' ),
				'condition' => [
					'show_video_area' => 'yes',
					'layout_control'      => 'one',
				],
			]
		);
		$this->add_control(
			'video_option',
			[
				'label' => __( 'Select Video Type', 'axtra' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'src_url',
				'options' => array(
					'src_url'       => esc_html__( 'Source URL', 'axtra' ),
					'src_media'      => esc_html__( 'Source Media', 'axtra' ),
				),
			   'condition' => [
				'show_video_area' => 'yes',
				'layout_control'      => 'one',
			   ],
			]
		);
		$this->add_control(
            'video_link',
			[
				'label' => __( 'Video Source Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'video_option'      => 'src_url'
				],
			]
		);
		$this->add_control(
			'video_source_image',
			[
				'label' => __( 'Video Source Media', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'media_types' => ['video'],
				'condition' => [
					'video_option'      => 'src_media'
				],
			]
		);
		$this->add_control(
			'feature_image',
			[
				'label' => __( 'Feature Image', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => ['one', 'five']
				],
			]
		);
		$this->add_control(
			'feature_image1',
			[
				'label' => __( 'Feature Image V1', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => 'four',
				],
			]
		);
		$this->add_control(
			'feature_image2',
			[
				'label' => __( 'Feature Image V2', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => 'four',
				],
			]
		);
		$this->add_control(
			'feature_image3',
			[
				'label' => __( 'Feature Image V3', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => 'four',
				],
			]
		);
		$this->add_control(
			'feature_image4',
			[
				'label' => __( 'Feature Image V4', 'axtra' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
					'layout_control'      => 'four',
				],
			]
		);
		$this->add_control(
			'show_banner_shape',
			[
				'label'       => __( 'ON/OFF Shape', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['four', 'five']
				],
			]
		);
		$this->add_control(
			'show_button',
			[
				'label'       => __( 'ON/OFF Button', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => ['two', 'five']
				],
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'axtra' ),
				'condition' => [
					'show_button'      => 'yes',
					'layout_control'      => ['two', 'five']
				],
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'axtra' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'show_button'      => 'yes',
					'layout_control'      => ['two', 'five']
				],
			]
		);
		//Experience Area
		$this->add_control(
			'show_experience_area',
			[
				'label'       => __( 'ON/OFF Experience Info', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'axtra' ),
				'label_off' => __( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_control'      => 'three',
				],
			]
		);
		$this->add_control(
			'experience_year',
			[
				'label'       => __( 'Experience Years', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Years', 'axtra' ),
				'condition' => [
					'show_experience_area' => 'yes',
					'layout_control'      => 'three',
				],
			]
		);
		$this->add_control(
			'experience_title',
			[
				'label'       => __( 'Experience Description', 'axtra' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Description', 'axtra' ),
				'condition' => [
					'show_experience_area' => 'yes',
					'layout_control'      => 'three',
				],
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub title Style**/
		
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'axtra'),
                'selector' => '{{WRAPPER}} .hero__area-3 .sec-sub-title',
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .hero__area-3 .sec-sub-title' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'axtra'),
                'selector' => '{{WRAPPER}} .hero__area-3 .sec-title,{{WRAPPER}} .hero__area-2 .sec-title-3,{{WRAPPER}} .hero__title,{{WRAPPER}} .service__hero-right-2 .title,{{WRAPPER}} .hero__area-6 .hero__title-6',                
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .hero__area-3 .sec-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .hero__area-2 .sec-title-3' => 'color: {{VALUE}}', 
					'{{WRAPPER}} .hero__title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service__hero-2 .service__hero-right-2 .title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .hero__area-6 .hero__title-6' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'axtra'),
                'selector' => '
                    {{WRAPPER}} .hero__text-3 p, 
					{{WRAPPER}} .hero__text-2 p, 
					{{WRAPPER}} .hero__area  .hero__sub-title,
					{{WRAPPER}} .service__hero-right-2 p,
					{{WRAPPER}} .hero__area-6 .hero__content-6 p
				',               
                'separator' => 'before',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .hero__text-3 p, {{WRAPPER}} .hero__text-2 p, {{WRAPPER}} .hero__area  .hero__sub-title, {{WRAPPER}} .service__hero-right-2 p, {{WRAPPER}} .hero__area-6 .hero__content-6 p' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'axtra'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'axtra_tabs_btn' );
		
			$this->start_controls_tab(
				'axtra_tab_btn_normal',
				[
					'label' => __( 'Normal', 'axtra' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'btn_bgtype',
						'label' => __( 'Button Background', 'axtra' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .axtratheme-btn',				
					]
				);
				$this->add_responsive_control(
					'btn_width_size',
					[
						'label' => __( 'Width', 'axtra' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .axtratheme-btn' => 'width: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'btn_height_size',
					[
						'label' => __( 'Height', 'axtra' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .axtratheme-btn' => 'height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'btn_padding',
					[
						'label'              => __( 'Padding', 'axtra' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .axtratheme-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'btn_border_type',
						'selector' => 
							'{{WRAPPER}} .axtratheme-btn',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'border_box_shadow',
						'selector' => 
							'{{WRAPPER}} .axtratheme-btn',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'btn_border_radius',
					[
						'label' => esc_html__('Border Radius', 'axtra'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .axtratheme-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' => 'btn_title_typography',
						'label' => __('Button Text Typography', 'axtra'),
						'selector' => 
							'{{WRAPPER}} .axtratheme-btn',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'btn_title_color',
					[
						'label' => __('Button Text Color', 'axtra'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .axtratheme-btn' => 'color: {{VALUE}}!important',
						],
						'separator' => 'before',
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'axtra_tab_btn_hover',
				[
					'label' => __( 'Hover', 'axtra' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'btn_hover_bg_bgtype',
						'label' => __( 'Button Hover Background', 'axtra' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .axtratheme-btn:hover',				
					]
				);
				$this->add_control(
					'btn_border_hover_color',
					[
						'label' => __('Button Border Hover Color', 'axtra'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .axtratheme-btn:hover' => 'border-color: {{VALUE}}!important',
						],
						'separator' => 'before',
					]
				);
				$this->add_control(
					'btn_title_hover_color',
					[
						'label' => __('Button Text Hover Color', 'axtra'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .axtratheme-btn:hover' => 'color: {{VALUE}}!important',
						],
						'separator' => 'before',
					]
				);
			
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();
	}

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$hero__six_anim = 'hero__six_anim';
			$hero7__thum_anim = 'hero7__thum-anim';
			$animate_content = 'animate_content';
			$animation__hero_one = 'animation__hero_one';
			$animation__text = 'hero__text-animation';
		}else{
			$hero__six_anim = '';
			$hero7__thum_anim = '';
			$animate_content = '';
			$animation__hero_one = '';
			$animation__text = '';
		}
		if ( ! empty( $settings['btn_link']['url'] ) ) {
			$this->add_link_attributes( 'link', $settings['btn_link'] );
		}
		if ( ! empty( $settings['service_btn_link']['url'] ) ) {
			$this->add_link_attributes( 'service_link', $settings['service_btn_link'] );
		}
    ?>
	
    
	<?php if($settings['layout_control'] == 'five'): ?>
    
    <!-- Hero area start -->
    <section class="hero__area-6">
        <div class="container g-0 line_4">
            <?php if($settings['show_line_pattern']){ ?>
            <div class="line-col-4">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        	<?php } ?>
            
            <div class="row">
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                    <div class="hero__content-6 <?php echo esc_attr( $hero__six_anim );?>">
                        <?php if($settings[ 'show_arrow_img' ] == 'yes' ){ ?>
                        <img class="hero__arrow-icon" src="<?php echo esc_url(wp_get_attachment_url($settings['arrow_down_image']['id'])); ?>" alt="<?php esc_attr_e('scroll Image', 'axtra'); ?>">
                        <?php } ?>
                        <?php if($settings['title1']){ ?><h1 class="hero__title-6 "><?php echo wp_kses($settings['title1'], true); ?> </h1><?php } ?>
                        <?php if($settings['show_text_area']){ ?><p><?php echo wp_kses($settings['text'], true); ?></p><?php } ?>
                        
						<?php if($settings['show_button']){ ?>
                        <a class="btn-started btn-hover axtratheme-btn" <?php echo $this->get_render_attribute_string( 'link' );?>><?php echo wp_kses($settings['btn_title'], true); ?></a>
                        <?php } ?>
                    </div>
                </div>
				
				<?php if($settings['feature_image']['id']){ ?>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                    <div class="hero__right-6">
                    	<img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id'])); ?>" alt="<?php esc_attr_e('Hero Image', 'axtra'); ?>">
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
        
        <?php if($settings['show_banner_shape']){ ?>
        <img class="hero__shape" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/hero/4/hero-shape.png" alt="<?php esc_attr_e('Shape Image', 'axtra'); ?>">
        <img class="hero__shape-2" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/hero/4/hero-shape-2.png" alt="<?php esc_attr_e('Layout', 'axtra'); ?>">
        <img class="hero__shape-3" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/hero/4/hero-shape-3.png" alt="<?php esc_attr_e('Star Icon', 'axtra'); ?>">
        <img class="shape-4" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/20.png" alt="<?php esc_attr_e('Star Icon', 'axtra'); ?>">
        <?php } ?>
    </section>
    <!-- Hero area end -->
	
	<?php elseif($settings['layout_control'] == 'four'): ?>
    
    <!-- Hero area start -->
    <section class="service__hero-2">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="service__hero-inner-2">
                        
                        <div class="service__hero-left-2">
                            <?php if($settings['feature_image1']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="image-1"><?php } ?>
                            <?php if($settings['feature_image1']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="image-2"><?php } ?>
                            <?php if($settings['feature_image1']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image3']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="image-3"><?php } ?>
                            <?php if($settings['feature_image1']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image4']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="image-4"><?php } ?>
                        </div>
                        
                        <div class="service__hero-right-2 <?php echo esc_attr( $hero7__thum_anim );?>">
                            <?php if($settings['title1']){ ?><h1 class="title creative"><?php echo wp_kses($settings['title1'], true); ?> </h1><?php } ?>
                            <?php if($settings['show_text_area']){ ?><p class="<?php echo esc_attr( $animate_content );?>"> <?php echo wp_kses($settings['text'], true); ?> </p><?php } ?>
                            <?php if($settings[ 'show_arrow_img' ] == 'yes' ){ ?>
                            <img src="<?php echo esc_url(wp_get_attachment_url($settings['arrow_down_image']['id'])); ?>" alt="<?php esc_attr_e('scroll Image', 'axtra'); ?>" class="scroll">
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    	
        <?php if($settings['show_banner_shape']){ ?>
    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/home-7/shape-6.png" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="shape-1">
        <?php } ?>
    </section>
    <!-- Hero area end -->
    
    <?php elseif($settings['layout_control'] == 'three'): ?>
    <!-- Hero area start -->
    <section class="hero__area ">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="hero__content <?php echo esc_attr( $animation__hero_one );?>">
                        <?php if($settings['show_service_link']){ ?>
                        <a class="axtratheme-btn" <?php echo $this->get_render_attribute_string( 'service_link' );?>> <?php echo wp_kses($settings['service_btn_title'], true); ?> <span><i class="fa-solid fa-arrow-right"></i></span></a>
                        <?php } ?>
                        
						<?php if($settings['title1'] || $settings['show_text_area']){ ?>
                        <div class="hero__title-wrapper">
                            <?php if($settings['title1']){ ?>
                                <h1 class="hero__title"><?php echo wp_kses($settings['title1'], true); ?> 
                                	<?php if( $settings[ 'show_cat_title' ] == 'yes' ){?>
                                    <span class="te-hero-title"><?php echo wp_kses( $settings[ 'cat_title' ], true );?></span>
                                    <?php };?>
                                </h1>
							<?php } ?>
                            <?php if($settings['show_text_area']){ ?><p class="hero__sub-title"><?php echo wp_kses($settings['text'], true); ?> </p><?php } ?>
                        </div>
                    	<?php } ?>
                        
						<?php if($settings[ 'show_arrow_img' ] == 'yes' ){ ?>
                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['arrow_down_image']['id'])); ?>" alt="<?php esc_attr_e('Arrow Down Icon', 'axtra'); ?>">
                        <?php } ?>
                        
						<?php if($settings['show_experience_area']){ ?>
                        <div class="experience">
                            <?php if($settings['experience_year']){ ?><h2 class="title"><?php echo wp_kses($settings['experience_year'], true); ?></h2><?php } ?>
                            <?php if($settings['experience_title']){ ?><p><?php echo wp_kses($settings['experience_title'], true); ?></p><?php } ?>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        
    	<?php if($settings['bg_image']['id']){ ?>
    	<img src="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'axtra'); ?>" class="hero1_bg">
        <?php } ?>
    </section>
    <!-- Hero area end -->
	
	<?php elseif($settings['layout_control'] == 'two'): ?>
    
    <!-- Hero area start -->
    <section class="hero__area-2" <?php if($settings['bg_image']['id']){ ?>style="background-image:url('<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>');"<?php } ?>>
        <div class="hero__inner-2">
            <?php if($settings['title1'] || $settings['title2']){ ?>
            <div class="sec-title-wrapper">
                <?php if($settings['title1']){ ?><h2 class="sec-title-3 bg-shape"><?php echo wp_kses($settings['title1'], true); ?></h2><?php } ?>
                <?php if($settings['title2']){ ?><h2 class="sec-title-3"><?php echo wp_kses($settings['title2'], true); ?></h2><?php } ?>
            </div>
            <?php } ?>
          	  
            <div class="hero__text-2">
                <?php if($settings['show_text_area']){ ?>


                <p><?php echo wp_kses($settings['text'], true); ?></p>
                <?php } ?>
                
                <?php if($settings['show_button']){ ?>
                <div id="btn_wrapper" class="hero__button">
                    <a <?php echo $this->get_render_attribute_string( 'link' );?> class="wc-btn-pink btn-item btn-hover axtratheme-btn"><span></span> <?php echo wp_kses($settings['btn_title'], true); ?> <i class="fa-solid fa-arrow-right"></i></a>
                </div>
                <?php } ?>
            </div>
            
        </div>
        <?php if($settings[ 'show_arrow_img' ] == 'yes' ){ ?>
        <div class="hero2-shape">
        	<img src="<?php echo esc_url(wp_get_attachment_url($settings['arrow_down_image']['id'])); ?>" alt="<?php esc_attr_e('BG Shape', 'axtra'); ?>">
        </div>
        <?php } ?>
    </section>
    <!-- Hero area end -->
    
    <?php else: ?>
    
    <!-- Hero area start -->
    <section class="hero__area-3">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12">
                    <div class="hero__inner-3">
                        <?php if($settings['subtitle'] || $settings['title1'] || $settings['title2']){ ?>
                        <div class="sec-title-wrapper">
                            <?php if($settings['subtitle']){ ?><h2 class="sec-sub-title"><?php echo wp_kses($settings['subtitle'], true); ?></h2><?php } ?>
                            <?php if($settings['title1']){ ?><h3 class="sec-title title-left"><?php echo wp_kses($settings['title1'], true); ?></h3><?php } ?>
                            <?php if($settings['title2']){ ?><h3 class="sec-title title-right"><?php echo wp_kses($settings['title2'], true); ?></h3><?php } ?>
                        </div>
                        <?php } ?>
                        
						<?php if($settings['show_text_area']){ ?>
                        <div class="hero__text-3">
                            <p class="<?php echo esc_attr( $animation__text );?>"><?php echo wp_kses($settings['text'], true); ?></p>
                        </div>
                        <?php } ?>
                        
                        <?php if($settings[ 'show_arrow_img' ] == 'yes' ){ ?>
                        <div class="scroll-down">
                            <button><img src="<?php echo esc_url(wp_get_attachment_url($settings['arrow_down_image']['id'])); ?>" alt="<?php esc_attr_e('arrow icon', 'axtra'); ?>"></button>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php 
			if($settings['show_video_area']){ 
			$video_option = $settings[ 'video_option' ];
			if( $video_option == 'src_url' ){
				$video = $settings[ 'video_link' ][ 'url' ];
			}elseif( $video_option == 'src_media' ){
				$video = $settings[ 'video_source_image' ]['url'];
			}else{
				$video = esc_html__( 'There is no Video', 'axtra' );
			}
		?>
        <div class="wrapper">
            <div class="video-info">
                <div class="video-intro">
                    <input id="video_check" type="checkbox">
                    <div class="intro-title">
                        <?php if($settings['video_title1']){ ?><h4 class="video-title"><?php echo wp_kses($settings['video_title1'], true); ?></h4><?php } ?>
                        <?php if($settings['video_title2']){ ?><h4 class="video-title close-video-title"><?php echo wp_kses($settings['video_title2'], true); ?></h4><?php } ?>
                    </div>
                    <div class="video">
                        <video src="<?php echo esc_url( $video );?>" loop muted autoplay playsinline></video>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
        
    	<?php if($settings['feature_image']['id']){ ?>
        <div class="hero3-img-ani">
            <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id'])); ?>" alt="<?php esc_attr_e('Hero Image', 'axtra'); ?>" class="hero3-img">
        </div>
        <?php } ?>
    </section>
        
	<?php endif;
    }
}
