<?php namespace AXTRAPLUGIN\Element;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Client_Carousel extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'axtra_client_carousel';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Client Carousel', 'axtra' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'axtra' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'client-script', YT_URL . 'assets/js/client.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'client-script' ];
	}
	
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'client_carousel',
            [
                'label' => esc_html__( 'Client Carousel', 'axtra' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'axtra' ),
				'type'        => 'elementor-layout-control',
				'default' => 'one',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'axtra' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/clients/client_layout_six.png'
					],
				],
			]
		);
		$this->add_control(
			'anim_on',
			[
				'label'       => __( 'ON/OFF Animation', 'axtra' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra' ),
				'label_off' => esc_html__( 'Hide', 'axtra' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		//Repeater
		$repeater = new Repeater();
		$repeater->add_control(
			'client_image',
			[
				'label'                 => esc_html__('Choose Image', 'axtra'),
				'type'                  => Controls_Manager::MEDIA,
				'default'               => [
					'url' => Utils::get_placeholder_image_src(),
				]
			]
		);
		$this->add_control(
			'client',
			[
				'label'                 => __('Add Clients Item', 'axtra'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
	}
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$anim_on	= $settings[ 'anim_on' ];
		
		if( $anim_on === 'yes' ){
			$anim_title = 'title-anim';
			$fade_bottom = 'fade_bottom';
			$fade_bottom_5 = 'fade_bottom_5';
		}else{
			$anim_title = '';
			$fade_bottom = '';
			$fade_bottom_5 = '';
		}
    ?>
	
    <!-- brand  -->
    <div class="woocomerce__brand woocomerce-padding">
        <div class="woocomerce__brand-wrapper">
            <div class="swiper woocomerce-brand-active">
                <div class="swiper-wrapper">
                	<?php foreach($settings['client'] as $key => $item): ?>
                    <div class="swiper-slide">
                        <div class="woocomerce__brand-item">
                        	<img src="<?php echo esc_url(wp_get_attachment_url($item['client_image']['id']));?>" alt="<?php esc_attr_e('Brand Logo', 'axtra'); ?>">
                        </div>
                    </div>
                	<?php endforeach;?>
                </div>
            </div>
        </div>
    </div>
    <!-- /brand  -->
            
    <?php
    }
}
