{{ ucfunc("put_docready_start") }}
		
  var jQuerytabs = jQuery('#{{uc_id}}');
  var htmlAccordion = jQuerytabs.find(".uc-accordion-contents-template").html();  
  var objTabs = jQuerytabs.find(".ue-tab-btn");
  
  var g_dataScrollToHashedTab = jQuerytabs.data("hash-scroll");
  var g_scrollOffset = jQuerytabs.data("scroll-to-selected-tab-offset");
  
  var tabsOptions = {
    
      startCollapsed: '{{start_hidden}}',
      {% if accordion_breakpoint == "true" %}
        collapsible: 'accordion',
       closeCurrent: true,
      {% else %}
        collapsible: 'tabs',
        closeCurrent: {{close_active_tab_on_click}},  
      {% endif %}      
      setHash: {{set_url_hash}},
      accordionAnchorHTML:htmlAccordion ,
      breakpoint: {{responsive_breakpoint}},
       
  }
  
  //init the tabs
  jQuerytabs.responsiveTabs('init', tabsOptions);

  /**
  * before - after widget template tab fix
  */  
  jQuerytabs.on("click", function(){
  
  	var objBeforeAfterWidgets = jQuerytabs.find(".cocoen");
    
    if(!objBeforeAfterWidgets.length)
    return(true);  
      
   	objBeforeAfterWidgets.trigger("delayed_start"); 
   
  });
  
  /**
  * scrolls the page
  */  
  function scrollToTop(elementOffsetTop, offset){

     jQuery('html, body').animate({
       
       scrollTop: elementOffsetTop + offset
                                  
     }, 400);
    
  }

  /**
  * scrolls to head in responsive mode
  */  
  function initScrollOption(){

    {% if scroll_to_head == "true" %}

      var objTab = jQuerytabs.find('.r-tabs-anchor');
      var isMobileViewport = window.matchMedia("(max-width: " + {{responsive_breakpoint}} + "px)");

      objTab.click(function(){
        
          var jQuerytabsOffsetTop = jQuerytabs.offset().top;
          var tabsItemOffsetTop = jQuery(this).offset().top;

          if(isMobileViewport.matches == true)
              scrollToTop(tabsItemOffsetTop, {{scroll_to_head_offset}});
        
      });

    {% endif %}
  
  }
     
  /**
  * returns jQuery object of the hashed tab
  */     
  function getHashedTab(){
  
  	if (!window.location.hash) 
    return false;

    var hash = window.location.hash.replace("#", "");
    
    var objHash = jQuery("[data-hash-id="+hash+"]");
  
    return(objHash);
  
  }   
     
  /**
  * scrolls to tab with different g_dataScrollToHashedTab values
  */     
  function scrollToTab(objTab){
  
    var objTabTop = objTab.offset().top;
    
    if (g_dataScrollToHashedTab == "desktop" && window.matchMedia("(min-width: 1024px)").matches){
      scrollToTop(objTabTop, g_scrollOffset);
    }
    
    if (g_dataScrollToHashedTab == "mobile" && window.matchMedia("(max-width: 1024px)").matches){
	  scrollToTop(objTabTop, g_scrollOffset);
    }
    
    if (g_dataScrollToHashedTab == "desktop+mobile"){
      scrollToTop(objTabTop, g_scrollOffset);
    }
  
  }   
     
  /**
  * scrolls to hashed tab after page load
  */  
  function scrollToHashedTab(){
  
  	var dataHash = jQuerytabs.data("hash");
    
    if(dataHash == false)
    return(false);
        
    if(g_dataScrollToHashedTab == "off")
    return(false); 
    
    var objHash = getHashedTab();
    
    if(!objHash || !objHash.length || objHash == false)
    return(false); 
      
    var objHashTop = objHash.offset().top;
    
    scrollToTab(objHash);
      	
  } 
     
  /**
  * check if element is in viewport
  */
  function isElementInViewport(element) {
    
    var elementTop = element.offset().top;
    var elementBottom = elementTop + element.outerHeight();
    
    var viewportTop = jQuery(window).scrollTop();
    var viewportBottom = viewportTop + jQuery(window).height();
    
    var isInViwport = elementBottom > viewportTop && elementTop < viewportBottom;
    
    return(isInViwport);
  } 
    
  /**
  * scrolls to selected tab
  */   
  function scrollToSelectedTab(objTab){  
  	            
    scrollToTab(objTab);
  
  }      
     
  /**
  * check if tab is in viewport and scroll
  */    
  function onTabsClick(){
  
    var dataScrollAfterSelected = jQuerytabs.data("scroll-after-selected");
    
    if(dataScrollAfterSelected == false)
    return(true);
    
    var objTab = jQuery(this);
    
    //if in viewport - do nothing
    if(isElementInViewport(objTab) == true)
    return(true);  
      
    scrollToSelectedTab(objTab);

  }   
  
  //set timeout in case other script scrolls the page so this one was last   
  setTimeout(scrollToHashedTab, 400);
     
  //scroll to tab after remote widget triggered click   
  objTabs.on("click", onTabsClick);
     
  //scrolls to head in responsive mode   
  initScrollOption(); 
    
  //reinit tabs after ajax (filters) refresh   
  jQuerytabs.on("uc_ajax_refreshed", function(){
    
    jQuerytabs.responsiveTabs("init", "destroy");
    jQuerytabs.responsiveTabs("reinit", tabsOptions);
    initScrollOption();
  
  });
     
  var objRemoteOptions = {
    	class_items:"r-tabs-tab",
    	class_active:"r-tabs-state-active",
    	selector_item_trigger:".r-tabs-anchor"
  };
      
  {{ucfunc("put_remote_parent_js","jQuerytabs","objRemoteOptions")}}  
    	
{{ ucfunc("put_docready_end") }}