#{{uc_id}} *
{
  box-sizing:border-box;
  -webkit-box-sizing: border-box;
  -moz-box-sizing: border-box;
}

body.uc-menu-push{
  	transition: padding-left {{menu_open_speed}}s, padding-right {{menu_open_speed}}s;
}

.swiper-container{
  transition: transform {{menu_open_speed}}s;
}

{% if disable_scroll_when_menu_opened == "true" %}
  body.menu-opened{
      overflow: hidden;
  }
{% endif %}

#{{uc_id}} .uc-side-menu-wrapper
{
  position:relative;
}

#{{uc_id}} .uc-menu-button-wrapper{
	position: relative;
}


#{{uc_id}} .menu-right-open {
	width: {{menu_width}};
	top: 0;
	right: 0;
	margin-right: 0px;
	margin-left: 0px;
	transition: {{menu_open_speed}}s;
	z-index: 999999;
	position: fixed;
}

#{{uc_id}} .menu-right-close {
	width: {{menu_width}};
	top: 0;
	right: 0;
	margin-right: -{{menu_width}};
	transition: {{menu_open_speed}}s;
	z-index: 1;
	height: 100%;
	position: fixed;
}

#{{uc_id}} .menu-left-open {
	width: {{menu_width}};
	top: 0;
	left: 0;
	margin-right: 0px;
	margin-left: 0px;
	transition: {{menu_open_speed}}s;
	z-index: 999999;
	height: 100%;
	position: fixed;
}

#{{uc_id}} .menu-left-close {
	width: {{menu_width}};
	top: 0;
	left: 0;
	margin-left: -{{menu_width}};
	transition: {{menu_open_speed}}s;
	z-index: 1;
	height: 100%;
	position: fixed;
}
	
#{{uc_id}} .uc-menu-item-pointer {
    display: inline-block;
    margin:0px 15px;
    vertical-align: middle;
}






#{{uc_id}} .uc-side-menu-items
{
  position:relative;
  height:100vh;
  overflow-x: hidden;
  transition:1s;
}

#{{uc_id}} .open_side_menu
{
  cursor:pointer;
  align-items:center;
  justify-content:center;
  transition: 0.4s ease;
  position: relative;
  line-height:1em;
  {% if toggle_button_icon == "animated" %}
  z-index: 1000000;
  {% endif %}
  {% if (hide_toggle_button == 'true') and (uc_inside_editor == "yes") %}
  	display: flex;  
  	opacity: 0.3;
  {% elseif (hide_toggle_button == 'true') and (uc_inside_editor == "no") %}
  	display:none;
  {% else %}
  	display: flex;
  {% endif %}
}

#{{uc_id}} .open_side_menu svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .open_side_menu_toggle
{
  position: relative;
  -webkit-box-flex: 0;
  flex: none;
  width: 100%;
  height: 2px;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.4s ease;
}
#{{uc_id}} .open_side_menu_toggle:before,
#{{uc_id}} .open_side_menu_toggle:after {
  content: '';
  position: absolute;
  z-index: 1;
  top: -10px;
  left: 0;
  width: 100%;
  height: 2px;
  background: inherit;
}
	
#{{uc_id}} .open_side_menu_toggle:after {
  top: 10px;
}

{% if toggle_button_icon == "animated" %}
#{{uc_id}} .uc-close-side-menu
{
  display: none;
}  
{% endif %}	

#{{uc_id}} .open_side_menu.uc-close-action .open_side_menu_toggle
{
  -webkit-transform: rotate(90deg);
  transform: rotate(135deg);
}
#{{uc_id}} .open_side_menu.uc-close-action .open_side_menu_toggle:before,
#{{uc_id}} .open_side_menu.uc-close-action .open_side_menu_toggle:after
{
  top: 0;
  -webkit-transform: rotate(90deg);
  transform: rotate(90deg);
}
#{{uc_id}} .open_side_menu.uc-close-action .open_side_menu_toggle:after
{
 opacity: 0;
}
#{{uc_id}} .open_side_menu.uc-close-action:hover .open_side_menu_toggle
{
  -webkit-transform: rotate(225deg);
  transform: rotate(225deg);
}


#{{uc_id}} .uc-side-menu-title
{
  text-align:{{menu_title_alignment}};
}

.menu-left-open .uc-close-side-menu, .menu-right-open .uc-close-side-menu
{
  display:flex;
  opacity:1;
}

.menu-left-close .uc-close-side-menu, .menu-right-close .uc-close-side-menu
{
  display:none;
}

.uc-close-side-menu
{
  line-height:1em;
}

.uc-close-side-menu svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .menu-left-open .ue_side_menu_overlay, #{{uc_id}} .menu-right-open .ue_side_menu_overlay
{
  display:block;
  opacity:1;
  transition:1s;
}

#{{uc_id}} .menu-left-close .ue_side_menu_overlay, #{{uc_id}} .menu-right-close .ue_side_menu_overlay
{
  display:none;
  opacity:0;
  transition:1s;
}

#{{uc_id}} .uc-close-side-menu
{
  position:absolute;
  {{close_button_alignment}}:{{close_button_horizontal_distance}}px;
  cursor:pointer;
  justify-content:center;
  align-items:center;
  z-index:1;
}


#{{uc_id}} .uc-side-menu-items ul
{
  padding:0px;
  margin-left:0px;
  margin-right: 0;
  margin-bottom: 0;
  list-style:none;
}

#{{uc_id}} .uc-side-menu-items ul a
{
  display:flex;
  align-items: center;
  justify-content: start;
  text-decoration:none;
  position:relative;
}


#{{uc_id}} .sub-menu {
    overflow: hidden;
    list-style: none;
    height: auto;
    transition: 0.5s;
  	
}

#{{uc_id}} .side-menu-search-holder
{
  display:flex;
  overflow:hidden;
}

#{{uc_id}} .side-menu-search-holder input
{
  border:none;
  border-radius:0px;
  flex:1;
  min-width: 0;
  
}
#{{uc_id}} .side-menu-search-holder button
{
  border:none;
  display:flex;
  cursor:pointer;
  align-items:center;
  justify-content:center;
  border-radius:0px;
  flex-grow: 0;
  flex-shrink: 0;
}

#{{uc_id}} .side-menu-buttons
{
  display:flex;
}

#{{uc_id}} .side-menu-button
{
  flex:1;
  text-decoration:none;
}

.side-menu-button
{
  font-size:12px;
}


#{{uc_id}}  .ue_side_menu_overlay
{
  position:fixed;
  top:0;
  bottom:0;
  left:0;
  right:0;
  transition:1s;
  opacity:0;
}



{% if pointer == "underline" %}
	#{{uc_id}} .uc-side-menu-items ul a:hover:after {
    content: "";
    bottom: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
    }  
{% endif %}	

  


{% if pointer == "overline" %}
#{{uc_id}} .uc-side-menu-items ul a:hover:before {
    content: "";
    top: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
}
{% endif %}


{% if pointer == "double" %}
#{{uc_id}} .uc-side-menu-items ul a:hover:after {
    content: "";
    bottom: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
    }  
#{{uc_id}} .uc-side-menu-items ul a:hover:before {
    content: "";
    top: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
}
{% endif %}


{% if pointer == "framed" %}
#{{uc_id}} .uc-side-menu-items ul a:hover:before {
    content: "";
    top: 0;
    bottom:0;
    left:0;
    right:0;
    height: 100%;
    width: 100%;
    border-style:solid;
    border-width:3px;
    border-color:{{pointer_color}};
    z-index: 2;
    position:absolute;
}
{% endif %}


/* On screens that are 768px */
@media screen and (max-width: 768px) {
  
  #{{uc_id}} .menu-right-open {
      width: {{menu_width_tablet}};
  }

  #{{uc_id}} .menu-right-close {
      width: {{menu_width_tablet}};
      margin-right: -{{menu_width_tablet}};

  }

  #{{uc_id}} .menu-left-open {
      width: {{menu_width_tablet}};	
  }

  #{{uc_id}} .menu-left-close {
      width: {{menu_width_tablet}};
      margin-left: -{{menu_width_tablet}};
  }
}

/* On screens that are 420px */
@media screen and (max-width: 420px) {
  
  #{{uc_id}} .menu-right-open {
      width: {{menu_width_mobile}};
  }

  #{{uc_id}} .menu-right-close {
      width: {{menu_width_mobile}};
      margin-right: -{{menu_width_mobile}};

  }

  #{{uc_id}} .menu-left-open {
      width: {{menu_width_mobile}};

  }

  #{{uc_id}} .menu-left-close {
      width: {{menu_width_mobile}};
      margin-left: -{{menu_width_mobile}};
  }
  
}