#{{uc_id}} *{
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
}


#{{uc_id}} .ue-item-overlay
{
  position:absolute;
  top:0;
  left:0;
  right:0;
  bottom:0;
  transition:0.3s;
}


#{{uc_id}} .uc_hover_switcher_row{
	position: relative;
	width: 100%;
	overflow: hidden;
	display: {{layout}};
    background: {{background_color}};
    direction:{{direction_ltr_rtl}};
}
#{{uc_id}} .uc_hover_switcher_col{
	position: relative;
	z-index: 2;
    
  {% if layout == "grid" %}
  		border-top-color:{{border_color}};
      border-top-width:{{border_width}}px;
      border-top-style:solid;
  {% endif %}
  
    {% if direction_ltr_rtl == "ltr" %}
      border-right-color:{{border_color}};
      border-right-width:{{border_width}}px;
      border-right-style:solid;
    {% endif %}
    {% if direction_ltr_rtl == "rtl" %}
      border-left-color:{{border_color}};
      border-left-width:{{border_width}}px;
      border-left-style:solid;
    {% endif %}	
    flex:1;
    overflow: hidden;
}

#{{uc_id}} .uc_hover_switcher_content{
	display: flex;
	height: 100%;
	flex-direction: column;
	justify-content: flex-end;
	color: #fff;
    text-align:{{alignment}};
    position:relative;
}
 #{{uc_id}} .uc_hover_switcher_title{
	
	transition: {{hover_duration}}ms;

}

.uc_hover_switcher_title
{
  font-size: 21px;
}

#{{uc_id}} .uc_hover_switcher_link{
	overflow: hidden;
	transform-origin: bottom;
	transition: {{hover_duration_out}}ms;
    max-height: 0px;
  
}
#{{uc_id}} .uc_hover_switcher_col:hover .uc_hover_switcher_link{
    max-height: 500px;
	overflow: visible;
    transition: {{hover_duration}}ms;
}

#{{uc_id}}[data-remoteid] .uc_hover_switcher_col.uc_hover .uc_hover_switcher_link,
#{{uc_id}}[data-sync] .uc_hover_switcher_col.uc_hover .uc_hover_switcher_link{
 	max-height: 500px;
	overflow: visible;
}

#{{uc_id}} .uc_hover_switcher_desc{
	
}
#{{uc_id}} .uc_button{
	
	display: {{button_style}};
	text-decoration: none;
    text-align:center;
}

#{{uc_id}} .uc_background_img img {
    width: 100% !important;
    height: 100% !important;
    object-fit: cover;
}
#{{uc_id}} .uc_hover_switcher_overlay{	
	position: absolute;
	top: 0;
	left: 0;
	height: 100%;
	width: 100%;
	z-index: 0;
	overflow: hidden;
}
#{{uc_id}} .uc_hover_switcher_overlay{
	z-index: 1;
}

#{{uc_id}} .uc_background_img{
	position: absolute;
  
	top: 0;
    {% if direction_ltr_rtl == "ltr" %}
      left: 0;
    {% endif %}
    {% if direction_ltr_rtl == "rtl" %}
      right: 0;
    {% endif %}	
	
	height: 100%;
	width: 100%;
	z-index: 0;
	overflow: hidden;
	visibility: hidden;
	opacity: 0;
}

#{{uc_id}} .uc_hover_switcher_col + .uc_background_img{
	transition-duration: {{hover_duration}}ms;
}

#{{uc_id}} .uc_hover_switcher_col.uc_hover + .uc_background_img{
	transition-duration: {{hover_duration}}ms;
	opacity: 1;
	margin: 0;
	visibility: visible;
	transform: scale(1.05);
}

#{{uc_id}} .uc_hover_switcher_col:last-of-type{
  
  {% if direction_ltr_rtl == "ltr" %}
      border-right: 0px;
    {% endif %}
  
  {% if direction_ltr_rtl == "rtl" %}
      border-left: 0px;
    {% endif %}
	
}

@media screen and (max-width: {{responsive_breakpoint}}px) {
  
  #{{uc_id}} .uc_hover_switcher_row{

	display: flex;
  }
}



{% if direction == "horizontal" %}

@media screen and (max-width: {{responsive_breakpoint}}px) {
	#{{uc_id}}.uc_list_image_background_hover_switcher .uc_hover_switcher_col{ 
     
        flex:1 0 {{item_width_on_mobile}}px
    }
  

  
  	#{{uc_id}}.uc_list_image_background_hover_switcher .uc_hover_switcher_row{ overflow-x: auto;}	
  	#{{uc_id}}.uc_list_image_background_hover_switcher .uc_background_img {
    	width: calc({{item_width_on_mobile}}px * {{uc_num_items}}) !important;
    }
  
  
}
{% endif %}



{% if direction == "vertical" %}
    #{{uc_id}} .uc_hover_switcher_row{
        
		flex-direction: column;
		justify-content: space-around;
    }
    #{{uc_id}} .uc_hover_switcher_col {
        
        border-right-style:none;
        border-right-color:transparent;
        border-left-color:transparent;
        border-right-width:0px;
        border-left-width:0px;
        border-bottom-color:{{border_color}};
        border-bottom-style:solid;
        border-bottom-width:{{border_width}}px;
        flex:auto;
    }
	#{{uc_id}} .uc_hover_switcher_col:last-of-type{
        border-bottom: 0px;
    }

	
	
{% endif %}

@media screen and (max-width: 767px) {
  
  {% if vertical_direction_on_mobile == "true" %}
     #{{uc_id}} .uc_hover_switcher_row{
          flex-direction: column;
          justify-content: space-around;
      }
      #{{uc_id}} .uc_hover_switcher_col {

          border-right-style:none;
          border-right-color:transparent;
          border-left-color:transparent;
          border-right-width:0px;
          border-left-width:0px;
          border-bottom-color:{{border_color}};
          border-bottom-style:solid;
          border-bottom-width:{{border_width}}px;
          flex:auto;
      }
      #{{uc_id}} .uc_hover_switcher_col:last-of-type{
          border-bottom: 0px;
      }
  {% endif %}

}