#{{uc_id}} {
  display: flex;  
  flex-direction: column;
}
#{{uc_id}} .wpcf7-list-item {
    margin: 0 0 0 8px;
}

#{{uc_id}} .wpcf7-form p:has(.wpcf7-submit){
  display:flex;
  flex-wrap: wrap;
}

#{{uc_id}} .ue_contact_form_7 label{
  display: block;
}

#{{uc_id}} .wpcf7-checkbox, #{{uc_id}} .wpcf7-radio{
  display:flex;
  flex-wrap: wrap;
}

#{{uc_id}} .wpcf7-form-control-wrap{
  display:flex;
  width:100%;
  flex-wrap: wrap;
}

{% if checkbox_style == "true" %}

#{{uc_id}} .wpcf7-checkbox .wpcf7-list-item-label{
  display: flex;
  align-items: center;
}
#{{uc_id}} .wpcf7-checkbox input{
  position: absolute;
  opacity: 0;
}
#{{uc_id}} .wpcf7-checkbox input + .wpcf7-list-item-label{
  position: relative;
  cursor: pointer;
  padding: 0;
}
#{{uc_id}} .wpcf7-checkbox input + .wpcf7-list-item-label:before{
  content: "";
  display: inline-block;
  vertical-align: text-top;
  transition-duration: 300ms;
}

#{{uc_id}} .wpcf7-checkbox input:checked + .wpcf7-list-item-label:after {
  content: "";
  position: absolute;
  width:2px;
  height:2px;
  background: {{check_color}};
  box-shadow: 2px 0 0 {{check_color}}, 4px 0 0 {{check_color}}, 4px -2px 0 {{check_color}}, 4px -4px 0 {{check_color}}, 4px -6px 0 {{check_color}}, 4px -8px 0 {{check_color}};
  transform: rotate(45deg);
}
{% endif %}

{% if radio_style == "true" %}
#{{uc_id}} .wpcf7-radio *{
  transition: 300ms;
}
#{{uc_id}} .wpcf7-radio .wpcf7-list-item-label{
  display: flex;
  align-items: center;
}
#{{uc_id}} .wpcf7-radio input{
  position: absolute;
  opacity: 0;
}
#{{uc_id}} .wpcf7-radio input + .wpcf7-list-item-label{
  position: relative;
  cursor: pointer;
  padding: 0;
}
#{{uc_id}} .wpcf7-radio input + .wpcf7-list-item-label:before{
  content: "";
  display: inline-block;
  vertical-align: text-top;
  transition-duration: 300ms;
}

#{{uc_id}} .wpcf7-radio input:checked + .wpcf7-list-item-label:after {
  content: "";
  transform: translate(-50%);
  position: absolute;
  border-radius:50%;
}
{% endif %}

{% if acceptance_style == "true" %}

#{{uc_id}} .wpcf7-acceptance .wpcf7-list-item-label{
  display: flex;
  align-items: center;
}
#{{uc_id}} .wpcf7-acceptance input{
  position: absolute;
  opacity: 0;
}
#{{uc_id}} .wpcf7-acceptance input + .wpcf7-list-item-label{
  position: relative;
  cursor: pointer;
  padding: 0;
}
#{{uc_id}} .wpcf7-acceptance input + .wpcf7-list-item-label:before{
  flex-shrink: 0;
  content: "";
  display: inline-block;
  vertical-align: text-top;
  transition-duration: 300ms;
}

#{{uc_id}} .wpcf7-acceptance input:checked + .wpcf7-list-item-label:after {
  flex-shrink: 0;
  content: "";
  position: absolute;
  width:2px;
  height:2px;
  background: {{acc_check_color}};
  box-shadow: 2px 0 0 {{acc_check_color}}, 4px 0 0 {{acc_check_color}}, 4px -2px 0 {{acc_check_color}}, 4px -4px 0 {{acc_check_color}}, 4px -6px 0 {{acc_check_color}}, 4px -8px 0 {{acc_check_color}};
  transform: rotate(45deg);
}
{% endif %}

.ue_contact_form_7 p > label{
  line-height: inherit;
}