#{{uc_id}}.ue-table {
  display: flex;
  flex-direction: column;
  opacity: 1;
  transition: opacity .3s ease-in-out;
}


#{{uc_id}} .tabulator-header .tabulator-col svg,
#{{uc_id}} .tabulator-table .tabulator-cell svg {
  height:1em;
  width:1em;
}


#{{uc_id}}.ue-table.uc-show {
  opacity: 1;
}


#{{uc_id}} .ue-table__tools {
  display: flex;
  justify-content: flex-end;
  {% if tools_enable_copy == 'true' or tools_enable_print == 'true' or tools_enable_download == 'true'%} 
  	min-height: 2em;
  {% endif %}
}

#{{uc_id}} .ue-table__search-btn,
#{{uc_id}} .ue-table__search-fields-toggle {
  height: 100%
}

#{{uc_id}} .ue-table__filter-container {
  position: relative;
  display: flex;
  justify-content: center;
  align-items: center;
}

#{{uc_id}} .ue-table__search-fields {
  position: absolute;
  top: 0;
  width: 100%;
  max-height: 200px;
  overflow: auto;
  list-style-type: none;
  z-index: 2;
  display: flex;
  flex-direction: column;
  gap: .5em;
  transform-origin: top center;
  transform: scaleY(0);
  transition: transform .3s ease-in-out;
}

#{{uc_id}} .ue-table__search-fields.uc-show {
  transform: scaleY(1);
}

#{{uc_id}} .ue-table__search-fields li {
  display: flex;
  align-items: center;
  gap: 0.5em;
}

#{{uc_id}} .ue-table-icon {
  position: relative;
	display: flex;
    justify-content: center;
    align-items: center;
  cursor: pointer;
  padding: 5px;
}

{% if tools_enable_icons_tooltips == "true" %}

#{{uc_id}} .ue-table-icon:before {
  content: attr(data-tooltip);
    opacity: 0;
    position: absolute;
    top: -150%;
    left: 50%;
    transform: translate(-50%, 100%);
    display: inline-block;
    transition: opacity .3s ease-in-out;
    padding: 0.2rem 0.4rem;
    z-index: 1;
    width: max-content;
  	white-space: nowrap;
}

#{{uc_id}} .ue-table-icon:hover:before {
  opacity: 1;
}

{% endif %}

.ue-table__templates-container {
	display: none;
}

#{{uc_id}} .tabulator-cell {	
  white-space: normal;
}

{% if wrap_content == 'true' %}
  #{{uc_id}} .tabulator-responsive-collapse {	
      white-space: normal;
  }
{% endif %}

#{{uc_id}} .tabulator .tabulator-header .tabulator-col {
  color: {{header_color}};
  background-color: {{header_background_color}};
}

#{{uc_id}} .tabulator .tabulator-header .tabulator-col:hover {
  background-color: {{header_background_color_hover}};
}


{% if text_direction == "rtl" %}
#{{uc_id}} .tabulator.tabulator-rtl .tabulator-header .tabulator-col,
  #{{uc_id}} .tabulator.tabulator-rtl .tabulator-header .tabulator-cell,
  #{{uc_id}} .tabulator.tabulator-rtl .tabulator-row .tabulator-col,
  #{{uc_id}} .tabulator.tabulator-rtl .tabulator-row .tabulator-cell {
      border-right-style: solid;
    border-right: none;
    border-left: none;
  }
  #{{uc_id}} .tabulator-col-resize-handle {
    border-width: {{resize_handler_width}};
    border-right-color: {{resize_handler_color}};
    border-right-style: solid;
  }
{% else %}
  #{{uc_id}} .tabulator .tabulator-header .tabulator-col,
  #{{uc_id}} .tabulator .tabulator-header .tabulator-cell,
  #{{uc_id}} .tabulator .tabulator-row .tabulator-col,
  #{{uc_id}} .tabulator .tabulator-row .tabulator-cell {
      border-left-style: solid;
    border-left: none;
  }
  #{{uc_id}} .tabulator-col-resize-handle {
    border-width: {{resize_handler_width}};
      border-left-color: {{resize_handler_color}};
    border-left-style: solid;
  }
{% endif %}

@media screen and (max-width: 1024px) {
  #{{uc_id}} .tabulator-col-resize-handle {
    border-width: {{resize_handler_width_tablet}};
  }
}
@media screen and (max-width: 767px) {
  #{{uc_id}} .tabulator-col-resize-handle {
    border-width: {{resize_handler_width_mobile}};
  }
}

#{{uc_id}} .tabulator-headers .tabulator-col:last-of-type,
#{{uc_id}} .tabulator-row .tabulator-cell:last-of-type{
  border-right: none !important;
}

#{{uc_id}} .tabulator-col-resize-handle:last-of-type {
  display: none;
}


.tabulator-col,
.tabulator-row,
.tabulator-cell,
.ue-table-column__button {
  transition: all .2s ease-in-out;
}

.ue-table-column__button {
  display: inline-block;
}

/*
.tabulator-headers>.tabulator-col:not([class*='elementor-repeater-item']),
.tabulator-table>.tabulator-row>.tabulator-cell:not([tabulator-field*='column']) {
	width: 100px !important;
}
*/

.tabulator-table>.tabulator-row>.tabulator-cell:not([tabulator-field*='column'])